/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib;

import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.ConstraintMapI;
import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.NameMapI;
import edu.neu.ccs.demeter.aplib.NoSuchClassGraphNodeException;
import edu.neu.ccs.demeter.aplib.OrderPreservingHashMap;
import edu.neu.ccs.demeter.aplib.StrategyGraphI;
import edu.neu.ccs.demeter.aplib.StrategyI;
import edu.neu.ccs.demeter.aplib.TraversalGraphException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TraversalGraph {
    StrategyI strategy;
    ClassGraphI classGraph;
    NameMapI nameMap;
    ConstraintMapI constraintMap;
    StrategyGraphI strategyGraph;
    int copies;
    protected boolean debug = false;
    OrderPreservingHashMap sourceNodeSets = new OrderPreservingHashMap();
    OrderPreservingHashMap targetNodeSets = new OrderPreservingHashMap();
    Map icis = new HashMap();
    static BitSet empty = new BitSet(0);
    OrderPreservingHashMap nodes = new OrderPreservingHashMap();
    OrderPreservingHashMap edges = new OrderPreservingHashMap();
    List nodesList;
    List edgesList;
    OrderPreservingHashMap startSets = new OrderPreservingHashMap();
    List startSet;

    public static String getVersion() {
        return "AP Library version 0.8.4";
    }

    public TraversalGraph(StrategyI S, ClassGraphI G, NameMapI N, ConstraintMapI B) throws TraversalGraphException {
        this(S, G, N, B, false);
    }

    public TraversalGraph(StrategyI S, ClassGraphI G, NameMapI N, ConstraintMapI B, boolean debug) throws TraversalGraphException {
        this.debug = debug;
        this.compute(S, G, N, B);
    }

    public TraversalGraph(StrategyI S, ClassGraphI G) throws TraversalGraphException {
        this(S, G, false);
    }

    public TraversalGraph(StrategyI S, ClassGraphI G, boolean debug) throws TraversalGraphException {
        this(S, G, null, null, debug);
    }

    protected TraversalGraph() {
    }

    public StrategyI getStrategy() {
        return this.strategy;
    }

    public ClassGraphI getClassGraph() {
        return this.classGraph;
    }

    public NameMapI getNameMap() {
        return this.nameMap;
    }

    public ConstraintMapI getConstraintMap() {
        return this.constraintMap;
    }

    protected void compute(StrategyI S, ClassGraphI G, NameMapI N, final ConstraintMapI B) throws TraversalGraphException {
        ConstraintMapI Bprime;
        this.classGraph = G;
        this.strategy = S;
        this.nameMap = N;
        if (this.nameMap == null) {
            this.nameMap = new NameMapI(){

                public Collection get(String l, ClassGraphI CG) throws NoSuchClassGraphNodeException {
                    return Collections.singleton(CG.getNode(l));
                }

                public boolean match(String l, Object cgv) {
                    return l.equals(String.valueOf(cgv));
                }

                public boolean match(String l, String cgl) {
                    return l.equals(cgl);
                }

                public String toString() {
                    return "I";
                }
            };
        }
        this.constraintMap = (Bprime = this.strategy.getConstraintMap()) == null ? B : (B == null ? Bprime : new ConstraintMapI(){

            public boolean meetsConstraint(int i, Object v, NameMapI NM) {
                return B.meetsConstraint(i, v, NM) && Bprime.meetsConstraint(i, v, NM);
            }

            public boolean meetsConstraint(int i, EdgeI e, NameMapI NM) {
                return B.meetsConstraint(i, e, NM) && Bprime.meetsConstraint(i, e, NM);
            }

            public boolean meetsConstraint(Object a, Object v, NameMapI NM) {
                return B.meetsConstraint(a, v, NM) && Bprime.meetsConstraint(a, v, NM);
            }

            public boolean meetsConstraint(Object a, EdgeI e, NameMapI NM) {
                return B.meetsConstraint(a, e, NM) && Bprime.meetsConstraint(a, e, NM);
            }
        });
        this.strategyGraph = this.strategy.getStrategyGraph();
        this.copies = this.strategyGraph.numEdges();
        this.addSourceAndTargetEdges();
        this.markForward();
        this.markBackward();
        this.makeStartSet();
        if (this.getStartNodeSets().isEmpty()) {
            throw new TraversalGraphException("No paths found matching strategy " + this.strategy);
        }
    }

    void addSourceAndTargetEdges() throws TraversalGraphException {
        this.markEndpointNodes(this.sourceNodeSets, true);
        this.markEndpointNodes(this.targetNodeSets, false);
    }

    void markEndpointNodes(Map nodeSets, boolean source) throws TraversalGraphException {
        Collection sgNodeList = source ? this.strategy.getSources() : this.strategy.getTargets();
        Iterator sgNodes = sgNodeList.iterator();
        while (sgNodes.hasNext()) {
            Object a = sgNodes.next();
            Collection indices = source ? this.strategyGraph.getOutgoingEdges(a) : this.strategyGraph.getIncomingEdges(a);
            Collection cgNodeList = this.mapNode(a);
            if (cgNodeList == null) {
                cgNodeList = this.classGraph.getNodes();
            }
            Iterator cgNodes = cgNodeList.iterator();
            while (cgNodes.hasNext()) {
                Object v = cgNodes.next();
                NodeSet endpoints = (NodeSet)nodeSets.get(v);
                boolean newNodeSet = false;
                if (endpoints == null) {
                    endpoints = new NodeSet(v);
                    newNodeSet = true;
                }
                Iterator it = indices.iterator();
                boolean addedIndices = false;
                while (it.hasNext()) {
                    int i = (Integer)it.next();
                    endpoints.addIndex(i);
                    addedIndices = true;
                    if (!source) continue;
                    this.markEndpointNodes_helper(i, v, endpoints);
                }
                if (!newNodeSet || !addedIndices) continue;
                nodeSets.put(v, endpoints);
            }
        }
        if (this.debug) {
            System.err.println((source ? "Source" : "Target") + " nodes: " + nodeSets.values());
        }
    }

    private void markEndpointNodes_helper(int i, Object v, NodeSet endpoints) {
        Object a = this.strategyGraph.getEdgeTarget(i);
        if (this.constraintMap.meetsConstraint(a, v, this.nameMap)) {
            Iterator it = this.strategyGraph.getOutgoingEdges(a).iterator();
            while (it.hasNext()) {
                int j = (Integer)it.next();
                if (endpoints.hasIndex(j)) continue;
                endpoints.addIndex(j);
                this.markEndpointNodes_helper(j, v, endpoints);
            }
        }
    }

    Collection mapNode(Object v) throws TraversalGraphException {
        Collection names;
        if (this.debug) {
            System.err.print("TraversalGraph.mapNode(" + v + ")");
        }
        if ((names = this.strategy.getNames(v)) == null) {
            if (this.debug) {
                System.err.println(" = *");
            }
            return null;
        }
        HashSet nodes = new HashSet();
        Iterator namesIter = names.iterator();
        while (namesIter.hasNext()) {
            Collection vImage;
            try {
                vImage = this.nameMap.get((String)namesIter.next(), this.classGraph);
            }
            catch (NoSuchClassGraphNodeException e) {
                throw new TraversalGraphException(e.getMessage());
            }
            if (vImage == null) {
                return null;
            }
            nodes.addAll(vImage);
        }
        if (this.debug) {
            System.err.println(" = " + nodes);
        }
        return nodes;
    }

    List getIntercopyIndices(EdgeI e) {
        ArrayList ici = (ArrayList)this.icis.get(e);
        if (ici == null) {
            ici = new ArrayList();
            this.icis.put(e, ici);
            Iterator sgNodes = this.strategyGraph.getNodes().iterator();
            while (sgNodes.hasNext()) {
                Collection O;
                Object a = sgNodes.next();
                Collection I = this.strategyGraph.getIncomingEdges(a);
                List cp = this.crossProduct(I, O = this.strategyGraph.getOutgoingEdges(a));
                if (cp.isEmpty() || !this.constraintMap.meetsConstraint(a, e, this.nameMap) && !this.constraintMap.meetsConstraint(a, e.getTarget(), this.nameMap)) continue;
                if (this.debug) {
                    System.err.println("Adding intercopy edges for " + TraversalGraph.edgeKey(e) + ": " + cp);
                }
                ici.addAll(cp);
            }
            ArrayList<IndexPair> add = new ArrayList<IndexPair>();
            Iterator it1 = ici.iterator();
            while (it1.hasNext()) {
                IndexPair ip1 = (IndexPair)it1.next();
                Iterator it2 = ici.iterator();
                while (it2.hasNext()) {
                    IndexPair ip2 = (IndexPair)it2.next();
                    IndexPair ip3 = null;
                    if (ip1.getTarget() == ip2.getSource()) {
                        ip3 = new IndexPair(ip1.getSource(), ip2.getTarget());
                    } else if (ip2.getTarget() == ip1.getTarget()) {
                        ip3 = new IndexPair(ip2.getSource(), ip1.getTarget());
                    }
                    if (ip3 == null || add.contains(ip3) || ici.contains(ip3)) continue;
                    add.add(ip3);
                }
            }
            if (this.debug) {
                System.err.println("Adding transitive closure intercopy edges for " + TraversalGraph.edgeKey(e) + ": " + add);
            }
            ici.addAll(add);
        }
        return ici;
    }

    List crossProduct(Collection l1, Collection l2) {
        if (this.debug) {
            System.err.println(l1 + " x " + l2);
        }
        ArrayList<IndexPair> prod = new ArrayList<IndexPair>();
        if (l1.isEmpty() || l2.isEmpty()) {
            return prod;
        }
        Iterator i1 = l1.iterator();
        while (i1.hasNext()) {
            int i = (Integer)i1.next();
            Iterator i2 = l2.iterator();
            while (i2.hasNext()) {
                int j = (Integer)i2.next();
                prod.add(new IndexPair(i, j));
            }
        }
        return prod;
    }

    void markForward() throws TraversalGraphException {
        Iterator it = this.sourceNodeSets.values().iterator();
        while (it.hasNext()) {
            this.markReachableFrom((NodeSet)it.next(), true);
        }
    }

    void markBackward() throws TraversalGraphException {
        Iterator it = this.targetNodeSets.values().iterator();
        while (it.hasNext()) {
            this.markReachableFrom((NodeSet)it.next(), false);
        }
    }

    void markReachableFrom(NodeSet nodes, boolean forward) {
        if (this.debug) {
            System.err.println("markReachableFrom(" + nodes + ", " + forward + ")");
        }
        int i = 0;
        while (i < this.copies) {
            if (nodes.hasIndex(i)) {
                this.markReachable(nodes.getNode(), i, forward, null);
            }
            ++i;
        }
    }

    void markReachable(Object v, int i, boolean forward, EdgeI prev) {
        Collection edges;
        if (this.debug) {
            System.err.println("markReachable(" + v + ", " + i + ", " + forward + ", " + TraversalGraph.edgeKey(prev) + ")");
        }
        try {
            edges = forward ? this.classGraph.getOutgoingEdges(v) : this.classGraph.getIncomingEdges(v);
        }
        catch (NoSuchClassGraphNodeException e) {
            return;
        }
        if (!this.constraintMap.meetsConstraint(i, v, this.nameMap)) {
            return;
        }
        this.mark(v, i, forward);
        Iterator it = edges.iterator();
        while (it.hasNext()) {
            EdgeI edge = (EdgeI)it.next();
            this.markReachableThroughEdge(edge, i, i, forward, prev);
            Iterator ici = this.getIntercopyIndices(edge).iterator();
            while (ici.hasNext()) {
                IndexPair ip = (IndexPair)ici.next();
                if (i != (forward ? ip.getSource() : ip.getTarget())) continue;
                this.markReachableThroughEdge(edge, ip.getSource(), ip.getTarget(), forward, prev);
            }
        }
    }

    void markReachableThroughEdge(EdgeI edge, int i, int j, boolean forward, EdgeI prev) {
        if (this.debug) {
            System.err.println("markReachableThroughEdge(" + TraversalGraph.edgeKey(edge) + ", " + i + ", " + j + ", " + forward + ", " + TraversalGraph.edgeKey(prev) + ")");
        }
        if (prev != null) {
            boolean bl = forward ? edge.isAlternationEdge() && prev.isInheritanceEdge() : edge.isInheritanceEdge() && prev.isAlternationEdge();
            if (bl) {
                return;
            }
        }
        if (!this.marked(edge, i, j, forward) && this.constraintMap.meetsConstraint(i, edge, this.nameMap)) {
            this.mark(edge, i, j, forward);
            this.markReachable(forward ? edge.getTarget() : edge.getSource(), forward ? j : i, forward, edge);
        }
    }

    static boolean isEmptyBitSet(BitSet s) {
        return s.equals(empty);
    }

    void mark(Object v, int i, boolean forward) {
        NodeSets sets = (NodeSets)this.nodes.get(v);
        if (sets == null) {
            sets = new NodeSets(v);
            this.nodes.put(v, sets);
        }
        sets.addIndex(i, forward);
        if (!forward && sets.hasIndex(i, true)) {
            sets.addIndex(i);
        }
    }

    boolean marked(Object v, int i, boolean forward) {
        NodeSets sets = (NodeSets)this.nodes.get(v);
        return sets != null && sets.hasIndex(i, forward);
    }

    void mark(EdgeI e, int i, int j, boolean forward) {
        String key = TraversalGraph.edgeKey(e);
        EdgeSets sets = (EdgeSets)this.edges.get(key);
        if (sets == null) {
            sets = new EdgeSets(e);
            this.edges.put(key, sets);
        }
        sets.addIndices(i, j, forward);
        if (!forward && sets.hasIndices(i, j, true)) {
            sets.addIndices(i, j);
        }
    }

    boolean marked(EdgeI e, int i, int j, boolean forward) {
        EdgeSets sets = (EdgeSets)this.edges.get(TraversalGraph.edgeKey(e));
        return sets != null && sets.hasIndices(i, j, forward);
    }

    public static String edgeKey(EdgeI e) {
        return e == null ? "null" : (e.isConstructionEdge() ? TraversalGraph.cedgeKey(e.getSource(), e.getLabel(), e.getTarget()) : (e.isAlternationEdge() ? TraversalGraph.aedgeKey(e.getSource(), e.getTarget()) : (e.isInheritanceEdge() ? TraversalGraph.iedgeKey(e.getSource(), e.getTarget()) : null)));
    }

    static String cedgeKey(Object u, String l, Object v) {
        return "-> " + u + "," + l + "," + v;
    }

    static String aedgeKey(Object u, Object v) {
        return "=> " + u + "," + v;
    }

    static String iedgeKey(Object u, Object v) {
        return ":> " + u + "," + v;
    }

    public List getNodeSets() {
        if (this.nodesList == null) {
            this.nodesList = new ArrayList();
            Iterator i = this.nodes.valuesAsList().iterator();
            while (i.hasNext()) {
                NodeSets sets = (NodeSets)i.next();
                NodeSet set = sets.getNodeSet();
                if (set == null) continue;
                this.nodesList.add(set);
            }
            this.nodesList = Collections.unmodifiableList(this.nodesList);
        }
        return this.nodesList;
    }

    public NodeSet getNodeSet(Object v) {
        NodeSets sets = (NodeSets)this.nodes.get(v);
        return sets == null ? null : sets.getNodeSet();
    }

    public List getEdgeSets() {
        if (this.edgesList == null) {
            this.edgesList = new ArrayList();
            Iterator i = this.edges.valuesAsList().iterator();
            while (i.hasNext()) {
                EdgeSets sets = (EdgeSets)i.next();
                EdgeSet set = sets.getEdgeSet();
                if (set == null) continue;
                this.edgesList.add(set);
            }
            this.edgesList = Collections.unmodifiableList(this.edgesList);
        }
        return this.edgesList;
    }

    public EdgeSet getEdgeSet(String key) {
        EdgeSets sets = (EdgeSets)this.edges.get(key);
        return sets == null ? null : sets.getEdgeSet();
    }

    public EdgeSet getEdgeSet(EdgeI e) {
        return this.getEdgeSet(TraversalGraph.edgeKey(e));
    }

    public EdgeSet getConstructionEdgeSet(Object u, String l, Object v) {
        return this.getEdgeSet(TraversalGraph.cedgeKey(u, l, v));
    }

    public EdgeSet getAlternationEdgeSet(Object u, Object v) {
        return this.getEdgeSet(TraversalGraph.aedgeKey(u, v));
    }

    public EdgeSet getInheritanceEdgeSet(Object u, Object v) {
        return this.getEdgeSet(TraversalGraph.iedgeKey(u, v));
    }

    void makeStartSet() throws TraversalGraphException {
        Iterator it = this.sourceNodeSets.values().iterator();
        while (it.hasNext()) {
            NodeSet set = (NodeSet)it.next();
            Object v = set.getNode();
            NodeSet setInTG = this.getNodeSet(v);
            if (setInTG == null) continue;
            setInTG = setInTG.intersection(set);
            NodeSet startSet = (NodeSet)this.startSets.get(v);
            startSet = startSet == null ? setInTG : startSet.union(setInTG);
            this.startSets.put(v, startSet);
        }
    }

    public List getStartNodeSets() {
        if (this.startSet == null) {
            this.startSet = new ArrayList();
            Iterator i = this.startSets.valuesAsList().iterator();
            while (i.hasNext()) {
                NodeSet set = (NodeSet)i.next();
                if (set.isEmpty()) continue;
                this.startSet.add(set);
            }
            this.startSet = Collections.unmodifiableList(this.startSet);
        }
        return this.startSet;
    }

    public NodeSet getStartSet(Object v) {
        NodeSet set = (NodeSet)this.startSets.get(v);
        return set == null || set.isEmpty() ? null : set;
    }

    public String toString() {
        int i;
        String[][] s = new String[this.copies][this.copies + 1];
        int i2 = 0;
        while (i2 < this.copies) {
            s[i2][0] = "Copy " + i2 + ":\n";
            String[] stringArray = s[i2];
            stringArray[0] = stringArray[0] + " Nodes:\n";
            int j = 0;
            while (j < this.copies) {
                s[i2][j + 1] = "";
                ++j;
            }
            ++i2;
        }
        Iterator nodeSets = this.getNodeSets().iterator();
        while (nodeSets.hasNext()) {
            NodeSet nodeSet = (NodeSet)nodeSets.next();
            int i3 = 0;
            while (i3 < this.copies) {
                if (nodeSet.hasIndex(i3)) {
                    String[] stringArray = s[i3];
                    stringArray[0] = stringArray[0] + " " + nodeSet.getNode() + "\n";
                }
                ++i3;
            }
        }
        int i4 = 0;
        while (i4 < this.copies) {
            String[] stringArray = s[i4];
            stringArray[0] = stringArray[0] + " Edges:\n";
            ++i4;
        }
        Iterator edgeSets = this.getEdgeSets().iterator();
        while (edgeSets.hasNext()) {
            EdgeSet edgeSet = (EdgeSet)edgeSets.next();
            String edge = TraversalGraph.edgeKey(edgeSet.getEdge());
            i = 0;
            while (i < this.copies) {
                if (edgeSet.hasIndices(i, i)) {
                    String[] stringArray = s[i];
                    stringArray[0] = stringArray[0] + " " + edge + "\n";
                }
                ++i;
            }
            Iterator ici = edgeSet.getIntercopyIndices().iterator();
            while (ici.hasNext()) {
                IndexPair ip = (IndexPair)ici.next();
                String[] stringArray = s[ip.getSource()];
                int n = ip.getTarget() + 1;
                stringArray[n] = stringArray[n] + " " + ip.getTarget() + ": " + edge + "\n";
            }
        }
        int i5 = 0;
        while (i5 < this.copies) {
            String[] stringArray = s[i5];
            stringArray[0] = stringArray[0] + " Edges to other copies:\n";
            ++i5;
        }
        String ss = "";
        i = 0;
        while (i < this.copies) {
            int j = 0;
            while (j < this.copies + 1) {
                ss = ss + s[i][j];
                ++j;
            }
            ++i;
        }
        return ss;
    }

    public String toCompactString() {
        String s = "";
        s = s + "Nodes:\n";
        Iterator nodeSets = this.getNodeSets().iterator();
        while (nodeSets.hasNext()) {
            s = s + nodeSets.next() + "\n";
        }
        s = s + "Edges:\n";
        Iterator edgeSets = this.getEdgeSets().iterator();
        while (edgeSets.hasNext()) {
            s = s + edgeSets.next() + "\n";
        }
        return s;
    }

    class EdgeSets {
        EdgeSet forw;
        EdgeSet back;
        EdgeSet both;

        EdgeSets(EdgeI e) {
            this.forw = new EdgeSet(e);
            this.back = new EdgeSet(e);
            this.both = new EdgeSet(e);
        }

        boolean hasIndices(int i, int j, boolean forward) {
            return (forward ? this.forw : this.back).hasIndices(i, j);
        }

        void addIndices(int i, int j, boolean forward) {
            (forward ? this.forw : this.back).addIndices(i, j);
        }

        boolean hasIndices(int i, int j) {
            return this.both.hasIndices(i, j);
        }

        void addIndices(int i, int j) {
            this.both.addIndices(i, j);
        }

        EdgeSet getEdgeSet() {
            return this.both.isEmpty() ? null : this.both;
        }
    }

    class NodeSets {
        NodeSet forw;
        NodeSet back;
        NodeSet both;

        NodeSets(Object v) {
            this.forw = new NodeSet(v);
            this.back = new NodeSet(v);
            this.both = new NodeSet(v);
        }

        boolean hasIndex(int i, boolean forward) {
            return (forward ? this.forw : this.back).hasIndex(i);
        }

        void addIndex(int i, boolean forward) {
            (forward ? this.forw : this.back).addIndex(i);
        }

        boolean hasIndex(int i) {
            return this.both.hasIndex(i);
        }

        void addIndex(int i) {
            this.both.addIndex(i);
        }

        NodeSet getNodeSet() {
            return this.both.isEmpty() ? null : this.both;
        }
    }

    public class IndexPair {
        protected int source;
        protected int target;

        IndexPair(int i, int j) {
            this.source = i;
            this.target = j;
        }

        public int getSource() {
            return this.source;
        }

        public int getTarget() {
            return this.target;
        }

        public boolean equals(Object ip) {
            return ip instanceof IndexPair && ((IndexPair)ip).source == this.source && ((IndexPair)ip).target == this.target;
        }

        public int hashCode() {
            return TraversalGraph.this.copies * this.source + this.target;
        }

        public String toString() {
            return this.source + " -> " + this.target;
        }
    }

    public class EdgeSet {
        EdgeI edge;
        BitSet indices;
        Set indexPairs;

        EdgeSet(EdgeI e) {
            this.edge = e;
            this.indices = new BitSet(TraversalGraph.this.copies);
            this.indexPairs = new HashSet();
        }

        public EdgeI getEdge() {
            return this.edge;
        }

        public Set getIntercopyIndices() {
            return Collections.unmodifiableSet(this.indexPairs);
        }

        public boolean hasIndices(int i, int j) {
            return i == j ? this.indices.get(i) : this.indexPairs.contains(new IndexPair(i, j));
        }

        public List getTargetIndices(int i) {
            return Collections.unmodifiableList(this.getIncidentIndices(i, true));
        }

        public List getSourceIndices(int j) {
            return Collections.unmodifiableList(this.getIncidentIndices(j, false));
        }

        List getIncidentIndices(int i, boolean source) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (this.isEmpty()) {
                return list;
            }
            if (this.indices.get(i)) {
                list.add(new Integer(i));
            }
            Iterator ips = this.indexPairs.iterator();
            while (ips.hasNext()) {
                IndexPair ip = (IndexPair)ips.next();
                if ((source ? ip.getSource() : ip.getTarget()) != i) continue;
                list.add(new Integer(source ? ip.getTarget() : ip.getSource()));
            }
            return list;
        }

        public NodeSet getTargetNodeSet() {
            NodeSet nodes = new NodeSet(this.edge.getTarget());
            int i = 0;
            while (i < TraversalGraph.this.copies) {
                if (this.indices.get(i)) {
                    nodes.addIndex(i);
                }
                ++i;
            }
            Iterator ips = this.indexPairs.iterator();
            while (ips.hasNext()) {
                IndexPair ip = (IndexPair)ips.next();
                nodes.addIndex(ip.getTarget());
            }
            return nodes;
        }

        void addIndices(int i, int j) {
            if (i == j) {
                this.indices.set(i);
            } else {
                this.indexPairs.add(new IndexPair(i, j));
            }
        }

        boolean isEmpty() {
            return TraversalGraph.isEmptyBitSet(this.indices) && this.indexPairs.isEmpty();
        }

        public String toString() {
            return TraversalGraph.edgeKey(this.edge) + ": " + this.indices + (this.indexPairs.isEmpty() ? "" : ", intercopy: " + this.indexPairs);
        }

        public boolean equals(Object o) {
            if (!(o instanceof EdgeSet)) {
                return false;
            }
            EdgeSet set = (EdgeSet)o;
            return this.edge.equals(set.edge) && this.indices.equals(set.indices) && this.indexPairs.equals(set.indexPairs);
        }
    }

    public class NodeSet {
        Object node;
        BitSet indices;

        NodeSet(Object v) {
            this.node = v;
            this.indices = new BitSet(TraversalGraph.this.copies);
        }

        public Object getNode() {
            return this.node;
        }

        public boolean hasIndex(int i) {
            return this.indices.get(i);
        }

        void addIndex(int i) {
            this.indices.set(i);
        }

        boolean isEmpty() {
            return TraversalGraph.isEmptyBitSet(this.indices);
        }

        public String toString() {
            return this.node + ": " + this.indices;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NodeSet)) {
                return false;
            }
            NodeSet set = (NodeSet)o;
            if (this.node == null ? set.node != null : !this.node.equals(set.node)) {
                return false;
            }
            return this.indices.equals(set.indices);
        }

        NodeSet intersection(NodeSet ns) {
            NodeSet ret = new NodeSet(this.node);
            ret.indices = (BitSet)this.indices.clone();
            ret.indices.and(ns.indices);
            return ret;
        }

        NodeSet union(NodeSet ns) {
            NodeSet ret = new NodeSet(this.node);
            ret.indices = (BitSet)this.indices.clone();
            ret.indices.or(ns.indices);
            return ret;
        }

        public List getOutgoingEdgeSets() {
            return Collections.unmodifiableList(this.getIncidentEdgeSets(true));
        }

        public List getIncomingEdgeSets() {
            return Collections.unmodifiableList(this.getIncidentEdgeSets(false));
        }

        /*
         * Unable to fully structure code
         */
        List getIncidentEdgeSets(boolean outgoing) {
            edgeSets = new ArrayList<EdgeSet>();
            if (this.isEmpty()) {
                return edgeSets;
            }
            try {
                edges = (outgoing != false ? TraversalGraph.this.classGraph.getOutgoingEdges(this.node) : TraversalGraph.this.classGraph.getIncomingEdges(this.node)).iterator();
                if (true) ** GOTO lbl28
            }
            catch (NoSuchClassGraphNodeException e) {
                return edgeSets;
            }
            do {
                if ((es = TraversalGraph.this.getEdgeSet(edge = (EdgeI)edges.next())) == null) continue;
                edgeSet = new EdgeSet(edge);
                i = 0;
                while (i < TraversalGraph.this.copies) {
                    if (this.hasIndex(i)) {
                        indices = es.getIncidentIndices(i, outgoing).iterator();
                        while (indices.hasNext()) {
                            j = (Integer)indices.next();
                            if (outgoing) {
                                edgeSet.addIndices(i, j);
                                continue;
                            }
                            edgeSet.addIndices(j, i);
                        }
                    }
                    ++i;
                }
                if (edgeSet.isEmpty()) continue;
                edgeSets.add(edgeSet);
lbl28:
                // 4 sources

            } while (edges.hasNext());
            return edgeSets;
        }
    }
}

