/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib;

import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.ClassGraph;
import edu.neu.ccs.demeter.aplib.sg.Strategy;
import edu.neu.ccs.demeter.aplib.sg.StrategyGraph;
import java.io.FileInputStream;
import java.io.PrintWriter;

public class APLibTest {
    public static void main(String[] args) {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: java edu.neu.ccs.demeter.aplib.APLibTest class-dictionary-file strategy-file [debug]");
            return;
        }
        System.out.println(TraversalGraph.getVersion());
        try {
            FileInputStream cdin = new FileInputStream(args[0]);
            FileInputStream sgin = new FileInputStream(args[1]);
            boolean debug = args.length == 3;
            ClassGraph cg = ClassGraph.readFrom(cdin);
            System.out.println("Expanded class graph:");
            System.out.println(cg);
            StrategyGraph sg = Strategy.readFrom(sgin);
            System.out.println("Expanded strategy graph:");
            System.out.println(sg);
            long start = System.currentTimeMillis();
            TraversalGraph tg = new TraversalGraph(sg, cg, debug);
            long finish = System.currentTimeMillis();
            System.out.println("Traversal graph: (" + (finish - start) + "ms)");
            System.out.println(tg);
            System.out.println("Traversal subgraph:");
            cg.printTraversalEdges(tg, new PrintWriter(System.out, true));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return;
        }
    }
}

