/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class InvertableSet {
    private boolean inverse;
    private Set set;

    public InvertableSet(Set set, boolean inverse) {
        this.set = set;
        this.inverse = inverse;
    }

    public InvertableSet(Set set) {
        this.set = set;
        this.inverse = false;
    }

    public InvertableSet() {
        this.set = new HashSet();
        this.inverse = false;
    }

    public Set getSet() {
        return this.set;
    }

    public boolean isInverse() {
        return this.inverse;
    }

    public void addAll(InvertableSet other) {
        InvertableSet s = this.union(other);
        this.set = s.set;
        this.inverse = s.inverse;
    }

    public boolean contains(Object obj) {
        if (this.inverse) {
            return !this.set.contains(obj);
        }
        return this.set.contains(obj);
    }

    public boolean containsAny(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public InvertableSet intersect(InvertableSet s2) {
        InvertableSet s1 = this;
        if (!s1.inverse && !s2.inverse) {
            s1.set.retainAll(s2.set);
            return s1;
        }
        if (s1.inverse && s2.inverse) {
            s1.set.addAll(s2.set);
            return s1;
        }
        if (s1.inverse) {
            s1 = s2;
            s2 = this;
        }
        s1.set.removeAll(s2.set);
        return s1;
    }

    public InvertableSet invert() {
        this.inverse = !this.inverse;
        return this;
    }

    public InvertableSet union(InvertableSet s2) {
        InvertableSet s0 = this.invert().intersect(s2.invert());
        return s0.invert();
    }
}

