/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ide;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.aspectj.tools.ide.Declaration;
import org.aspectj.tools.ide.SourceLine;
import org.aspectj.tools.ide.SymbolManager;

public class StringBasedSymbolManager {
    public static void main(String[] args) {
        StringBasedSymbolManager.fetchDeclarations(args[0]);
    }

    public static void fetchDeclarations(String filename) {
        try {
            SymbolManager mgr = SymbolManager.getSymbolManager();
            Declaration[] decls = mgr.getDeclarations(filename);
            if (decls == null) {
                throw new Error("Can't find declarations file for " + filename);
            }
            StringBasedSymbolManager.printDecls(decls, true);
        }
        catch (Error e) {
            StringBasedSymbolManager.lose(e);
        }
    }

    public static void fetchSourceLine(String filename, int line) {
        try {
            SymbolManager mgr = SymbolManager.getSymbolManager();
            SourceLine srl = mgr.mapToSourceLine(filename, line);
            if (srl == null) {
                StringBasedSymbolManager.print("nil");
            } else {
                String fn = srl.filename;
                int ln = srl.line;
                StringBasedSymbolManager.print("(\"" + StringBasedSymbolManager.fixFilename(fn) + "\" . " + ln + ")");
            }
        }
        catch (Error e) {
            StringBasedSymbolManager.lose(e);
        }
    }

    static void lose(Error e) {
        try {
            StringBasedSymbolManager.print("(ERROR \"" + e.toString() + "\")");
        }
        catch (Error error) {
            // empty catch block
        }
    }

    static void printDecls(Declaration[] decls, boolean recurse) {
        StringBasedSymbolManager.print("(");
        int i = 0;
        while (i < decls.length) {
            Declaration decl = decls[i];
            if (decl != null) {
                StringBasedSymbolManager.printDecl(decl, recurse);
            }
            ++i;
        }
        StringBasedSymbolManager.print(") ");
    }

    static void printDecl(Declaration decl, boolean recurse) {
        String crosscutDesignator = decl.getCrosscutDesignator();
        String kind = decl.getKind().toLowerCase();
        Declaration mappedDecl = StringBasedSymbolManager.nearestMappedDecl(decl);
        StringBasedSymbolManager.print("(");
        StringBasedSymbolManager.print("(" + mappedDecl.getBeginLine() + " . " + mappedDecl.getBeginColumn() + ") ");
        StringBasedSymbolManager.print("(" + mappedDecl.getEndLine() + " . " + mappedDecl.getEndColumn() + ") ");
        StringBasedSymbolManager.print(kind + " ");
        if (crosscutDesignator == null) {
            StringBasedSymbolManager.print("\"" + decl.getSignature() + "\" ");
        } else if (kind.equals("introduction")) {
            StringBasedSymbolManager.print("\"" + decl.getSignature() + " " + crosscutDesignator + "\" ");
        } else {
            StringBasedSymbolManager.print("\"" + decl.getSignature() + ": " + crosscutDesignator + "\" ");
        }
        StringBasedSymbolManager.print("\"" + StringBasedSymbolManager.fixFilename(decl.getFilename()) + "\"");
        StringBasedSymbolManager.print("\"" + decl.getDeclaringType() + "\" ");
        if (recurse) {
            StringBasedSymbolManager.printDecls(decl.getTargets(), false);
            StringBasedSymbolManager.printDecls(decl.getPointedToBy(), false);
            StringBasedSymbolManager.printDecls(decl.getDeclarations(), true);
        } else {
            StringBasedSymbolManager.print("nil");
            StringBasedSymbolManager.print("nil");
            StringBasedSymbolManager.print("nil");
        }
        StringBasedSymbolManager.print(StringBasedSymbolManager.fixBoolean(decl.isType()));
        StringBasedSymbolManager.print(StringBasedSymbolManager.fixBoolean(decl.isIntroduced()));
        StringBasedSymbolManager.print(StringBasedSymbolManager.fixBoolean(decl.hasBody()));
        StringBasedSymbolManager.print(StringBasedSymbolManager.fixBoolean(decl.hasSignature()));
        StringBasedSymbolManager.print(")");
    }

    static boolean legalLineNumber(int ln) {
        return ln != -1;
    }

    static Declaration nearestMappedDecl(Declaration decl) {
        if (StringBasedSymbolManager.legalLineNumber(decl.getBeginLine())) {
            return decl;
        }
        Declaration parentDecl = decl.getParentDeclaration();
        if (parentDecl != null) {
            return StringBasedSymbolManager.nearestMappedDecl(parentDecl);
        }
        return decl;
    }

    static String fixBoolean(boolean flag) {
        if (flag) {
            return "t ";
        }
        return "nil ";
    }

    static String fixFilename(String filename) {
        return StringBasedSymbolManager.subst("\\\\", "\\", filename);
    }

    static int convertLineToPosition(String filename, int lineNumber) throws FileNotFoundException {
        FileReader freader = new FileReader(filename);
        BufferedReader breader = new BufferedReader(freader);
        int position = 0;
        try {
            int n = 0;
            while (n < lineNumber) {
                String line = breader.readLine();
                position += line.length();
                ++n;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return position;
    }

    static void print(String string) {
        System.out.println(string);
    }

    static String subst(String n, String o, String in) {
        int pos = in.indexOf(o);
        if (pos == -1) {
            return in;
        }
        return in.substring(0, pos) + n + StringBasedSymbolManager.subst(n, o, in.substring(pos + o.length()));
    }
}

