/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.ast.PointcutSO;
import org.aspectj.tools.ajdoc.ErrPrinter;
import org.aspectj.tools.ajdoc.ParamTagImpl;
import org.aspectj.tools.ajdoc.SeeTagImpl;
import org.aspectj.tools.ajdoc.SerialFieldTagImpl;
import org.aspectj.tools.ajdoc.TagImpl;
import org.aspectj.tools.ajdoc.ThrowsTagImpl;

public class Util {
    public static final boolean start(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    public static final boolean ident(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static final boolean space(char c) {
        return Character.isWhitespace(c);
    }

    public static final boolean newline(char c) {
        return c == '\n' || c == '\r';
    }

    public static String[] split(String str) {
        String[] strs = new String[2];
        int i = 0;
        while (i < str.length()) {
            if (Util.space(str.charAt(i))) {
                strs[0] = str.substring(0, i);
                strs[1] = str.substring(i + 1);
                break;
            }
            ++i;
        }
        if (strs[0] == null) {
            strs[0] = str;
            strs[1] = "";
        }
        return strs;
    }

    public static final Tag[] inlineTags(Doc doc, String str, Locale loc, ErrPrinter err) {
        int i;
        if (str == null || str.length() < 1) {
            return new Tag[0];
        }
        int N = str.length();
        ArrayList<TagImpl> list = new ArrayList<TagImpl>();
        int j = i = 0;
        while (i < N) {
            int ileft = str.indexOf("{@", i);
            if (ileft == -1) {
                list.add(new TagImpl(doc, "Text", str.substring(i), loc, err));
                break;
            }
            if (j < ileft) {
                list.add(new TagImpl(doc, "Text", str.substring(j, ileft), loc, err));
            }
            if ((i = ileft) + 7 < N && str.substring(i + 2, i + 7).toLowerCase().equals("link ")) {
                i += 7;
                while (str.charAt(i) != '}') {
                    if (i == N - 1) {
                        err.error("tag_unterminated_link_tag", str.substring(i));
                        break;
                    }
                    ++i;
                }
                list.add(new SeeTagImpl(doc, "@link", str.substring(ileft + 7, i), loc, err));
            } else {
                err.error("tag_invalid_link_tag", str.substring(i));
            }
            j = ++i;
        }
        return list.toArray(new Tag[list.size()]);
    }

    public static final Tag[] firstSentenceTags(Doc doc, String str, Locale loc, ErrPrinter err) {
        return Util.inlineTags(doc, Util.firstSentenceText(str, loc, err), loc, err);
    }

    private static String firstSentenceText(String str, Locale loc, ErrPrinter err) {
        if (str == null || loc == null || !loc.equals(Locale.US)) {
            return "";
        }
        int N = str.length();
        int i = 0;
        while (i < N) {
            if (str.charAt(i) == '.') {
                if (i == N - 1) {
                    return str.substring(0, i + 1);
                }
                if (Util.space(str.charAt(i + 1))) {
                    return str.substring(0, i + 2);
                }
            }
            if (str.charAt(i) == '<') {
                int j = i + 1;
                while (j < N && str.charAt(j) != '>') {
                    ++j;
                }
                if (j == N) {
                    err.error("unterminated_html_tag", str);
                    return str;
                }
                String innards = str.substring(i + 1, j).trim().toLowerCase();
                if (innards.equals("p") || innards.equals("pre") || innards.equals("h1") || innards.equals("h2") || innards.equals("h3") || innards.equals("h4") || innards.equals("h5") || innards.equals("h6") || innards.equals("hr")) {
                    return str.substring(0, i + 1);
                }
            }
            ++i;
        }
        return str;
    }

    public static final List findTags(Doc doc, String str, Locale loc, ErrPrinter err) {
        boolean newline = true;
        ArrayList<Tag> result = new ArrayList<Tag>();
        if (str == null) {
            return result;
        }
        int N = str.length();
        int lastTag = -1;
        int i = 0;
        while (i < N) {
            if (Util.newline(str.charAt(i))) {
                newline = true;
            } else if (!Util.space(str.charAt(i)) || !newline) {
                if (str.charAt(i) == '@' && newline) {
                    if (lastTag != -1) {
                        result.add(Util.parse(doc, str.substring(lastTag, i), loc, err));
                    }
                    lastTag = i;
                } else {
                    newline = false;
                }
            }
            ++i;
        }
        if (lastTag != -1) {
            result.add(Util.parse(doc, str.substring(lastTag), loc, err));
        }
        return result;
    }

    private static final Tag parse(Doc doc, String str, Locale loc, ErrPrinter err) {
        TagImpl result = null;
        String[] split = Util.split(str);
        String name = split[0];
        String rest = split[1];
        result = name.equals("@see") ? new SeeTagImpl(doc, name, rest, loc, err) : (name.equals("@exception") || name.equals("@throws") ? new ThrowsTagImpl(doc, name, rest, loc, err) : (name.equals("@serialField") ? new SerialFieldTagImpl(doc, name, rest, loc, err) : (name.equals("@param") ? new ParamTagImpl(doc, name, rest, loc, err) : new TagImpl(doc, name, rest, loc, err))));
        return result;
    }

    public static final String rawCommentText(String str) {
        if (str == null) {
            return "";
        }
        if (str.length() < 3) {
            return "";
        }
        String withstars = "";
        int islash = str.indexOf(47);
        if (islash == -1 || islash + 2 >= str.length()) {
            return "";
        }
        if (str.charAt(islash + 1) != '*' || str.charAt(islash + 2) != '*') {
            return "";
        }
        int start = islash + 2 + 1;
        while (str.charAt(start) == '*' || Util.space(str.charAt(start))) {
            ++start;
        }
        int end = str.length() - 2;
        while (str.charAt(end) == '*') {
            --end;
        }
        if (start != -1 && end > start) {
            withstars = str.substring(start, end + 1);
        }
        StringBuffer result = new StringBuffer(withstars.length());
        StringTokenizer t = new StringTokenizer(withstars, "\n", true);
        while (t.hasMoreTokens()) {
            String line = t.nextToken();
            if (line == null || line.length() == 0) continue;
            int i = 0;
            while (i < line.length()) {
                if (line.charAt(i) != '*' && line.charAt(i) != ' ') break;
                ++i;
            }
            result.append(line.substring(i));
        }
        return result.toString();
    }

    public static final String commentText(String rawCommentText) {
        if (rawCommentText == null) {
            return "";
        }
        StringBuffer result = new StringBuffer(rawCommentText.length());
        StringTokenizer t = new StringTokenizer(rawCommentText, "\n", true);
        block0: while (t.hasMoreTokens()) {
            String line = t.nextToken();
            if (line == null || line.length() == 0) continue;
            int i = 0;
            while (i < line.length()) {
                char c = line.charAt(i);
                if (c != ' ' && c != '\t') {
                    if (c == '@') break block0;
                    result.append(line);
                    continue block0;
                }
                ++i;
            }
        }
        return result.toString();
    }

    public static final int compareTo(Doc $, Doc _) {
        return $ == null || _ == null ? -1 : $.name().compareTo(_.name());
    }

    public static final String signature(Parameter[] parameters) {
        return Util.signature(parameters, false);
    }

    public static final String flatSignature(Parameter[] parameters) {
        return Util.signature(parameters, true);
    }

    public static final String signature(Parameter[] parameters, boolean flatten) {
        if (parameters == null || parameters.length == 0) {
            return "()";
        }
        StringBuffer str = new StringBuffer((flatten ? 8 : 20) * parameters.length);
        str.append("(");
        int N = parameters.length;
        int i = 0;
        while (i < N) {
            int idot;
            String typeName = parameters[i].typeName();
            if (flatten && (idot = typeName.lastIndexOf(46)) != -1) {
                typeName = typeName.substring(idot + 1);
            }
            str.append(typeName + (i < N - 1 ? "," : ""));
            ++i;
        }
        str.append(")");
        return str.toString();
    }

    public static final boolean isIncluded(MemberDoc doc, long flags) {
        return true;
    }

    public static final boolean isIncluded(TypeDec dec) {
        if (dec == null) {
            return false;
        }
        return !dec.isLocal() || !dec.isAnonymous();
    }

    public static final void dump(Object o, String prefix) {
        System.err.println(">> Dumping:" + o);
        java.lang.reflect.Method[] ms = o.getClass().getMethods();
        ArrayList<java.lang.reflect.Method> list = new ArrayList<java.lang.reflect.Method>();
        int i = 0;
        while (i < ms.length) {
            list.add(ms[i]);
            ++i;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return this.str(o1).compareTo(this.str(o2));
            }

            public boolean equals(Object o1, Object o2) {
                return this.str(o1).equals(this.str(o2));
            }

            private String str(Object _) {
                return _ != null && _ instanceof java.lang.reflect.Method ? ((java.lang.reflect.Method)_).getName() : _ + "";
            }
        });
        Iterator i2 = list.iterator();
        while (i2.hasNext()) {
            java.lang.reflect.Method m = (java.lang.reflect.Method)i2.next();
            if (m.getParameterTypes().length != 0 || !m.getName().startsWith(prefix)) continue;
            try {
                System.err.println("  " + m.getName() + ":" + m.invoke(o, new Object[0]));
            }
            catch (Throwable _) {
                // empty catch block
            }
        }
    }

    public static final void gets(Object o) {
        Util.dump(o, "get");
    }

    public static final void array(Object[] os) {
        Util.array(os, false);
    }

    public static final void array(Object[] os, boolean gets) {
        if (os == null) {
            System.err.println("NULL");
            return;
        }
        System.err.println(os.getClass().getName() + ":" + os.length);
        int i = 0;
        while (i < os.length) {
            System.err.println(" [" + i + "]:" + os[i]);
            if (gets) {
                Util.gets(os[i]);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String documentation(File html, ErrPrinter err) {
        str = "";
        in = null;
        try {
            in = new FileInputStream(html);
        }
        catch (IOException ioe) {
            err.ex(ioe, "ioexception_open", html.getAbsolutePath());
            return "";
        }
        try {
            bytes = new byte[in.available()];
            in.read(bytes, 0, bytes.length);
            in.close();
            str = new String(bytes);
        }
        catch (IOException ioe) {
            err.ex(ioe, "ioexception_reading", html.getAbsolutePath());
        }
        is = new int[]{-10, -1};
        i = 0;
        chars = new char[]{'/', 'B', 'O', 'D', 'Y', '>'};
        j = 1;
        ** GOTO lbl42
        {
            s = i + 1;
            k = j;
            while (s < str.length()) {
                block8: {
                    c = str.charAt(s);
                    if (k != chars.length) break block8;
                    v0 = j;
                    is[v0] = is[v0] + (s + 2);
                    ** GOTO lbl41
                }
                if (c != chars[k] && c != (chars[k] | 0x1000000)) break;
                ++s;
                ++k;
            }
            i = str.indexOf(60, i + 1);
            do {
                if (i != -1) continue block4;
lbl41:
                // 2 sources

                --j;
lbl42:
                // 2 sources

            } while (j >= 0);
        }
        if (is[0] > -1 && is[1] > -1) {
            str = str.substring(is[1], is[0]);
        }
        return str;
    }

    public static Object invoke(Object target, String name, Class[] params, Object[] args) {
        return Util.invoke(target.getClass(), target, name, params, args);
    }

    public static Object invoke(Class type, Object target, String name, Class[] params, Object[] args) {
        try {
            java.lang.reflect.Method method = type.getDeclaredMethod(name, params);
            ((AccessibleObject)method).setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object access(Class type, Object target, String name) {
        try {
            Field field = type.getDeclaredField(name);
            ((AccessibleObject)field).setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final ExecutableMemberDoc executableMemberDoc(ExecutableMemberDoc[] emds, String name, Parameter[] params) {
        ExecutableMemberDoc result = null;
        int i = 0;
        while (i < emds.length) {
            ExecutableMemberDoc emd = emds[i];
            if (emd.name().equals(name) && params.length == emd.parameters().length) {
                int j = 0;
                if (j < params.length) {
                    if (params[j].typeName().equals(emd.parameters()[j].typeName())) {
                        result = emd;
                        break;
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static final PointcutDec pointcutDec(NameType nameType, String id, Formals formals) {
        PointcutDec result = null;
        Iterator i = nameType.getPointcuts().iterator();
        block0: while (i.hasNext()) {
            PointcutDec md = ((PointcutSO)i.next()).getPointcutDec();
            if (md.getFormals().size() != formals.size() || !id.equals(md.getId())) continue;
            int j = 0;
            while (j < formals.size()) {
                if (!md.getFormals().get(j).getType().getString().equals(formals.get(j).getType().getString())) continue block0;
                ++j;
            }
            result = md;
            break;
        }
        return result;
    }

    public static final MethodDec methodDec(NameType nameType, String id, Formals formals) {
        MethodDec result = null;
        Iterator i = nameType.getMethods().iterator();
        block0: while (i.hasNext()) {
            MethodDec md = ((Method)i.next()).getMethodDec();
            if (md.getFormals().size() != formals.size() || !id.equals(md.getId())) continue;
            int j = 0;
            while (j < formals.size()) {
                if (!md.getFormals().get(j).getType().getString().equals(formals.get(j).getType().getString())) continue block0;
                ++j;
            }
            result = md;
            break;
        }
        return result;
    }

    public static PointcutDec getPointcutDec(Type type, String name, TypeDec typeDec, boolean showError) {
        PointcutSO so = ((NameType)type).getPointcut(name, typeDec, showError);
        PointcutDec dec = null;
        if (so != null) {
            dec = (PointcutDec)so.getCorrespondingDec();
        }
        return dec;
    }

    public static FieldDec getFieldDec(Type type, String name, TypeDec typeDec, boolean showError) {
        org.aspectj.compiler.base.ast.Field so = ((NameType)type).getField(name, typeDec, showError);
        FieldDec dec = null;
        if (so != null) {
            dec = (FieldDec)so.getCorrespondingDec();
        }
        return dec;
    }

    public static MethodDec getMethodDec(Type type, String name, TypeDec typeDec, Exprs params, boolean showError) {
        Method so = ((NameType)type).getMethod(name, typeDec, params, showError);
        MethodDec dec = null;
        if (so != null) {
            dec = so.getMethodDec();
        }
        return dec;
    }

    public static ConstructorDec getConstructorDec(Type type, TypeDec typeDec, Exprs params, boolean showError) {
        Constructor so = ((NameType)type).getConstructor(typeDec, params, showError);
        ConstructorDec dec = null;
        if (so != null) {
            dec = (ConstructorDec)so.getCorrespondingDec();
        }
        return dec;
    }
}

