/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Type;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.aspectj.ajdoc.AdviceDoc;
import org.aspectj.ajdoc.AspectDoc;
import org.aspectj.ajdoc.ClassDoc;
import org.aspectj.ajdoc.PointcutDoc;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.tools.ajdoc.AjdocCompiler;
import org.aspectj.tools.ajdoc.ErrPrinter;
import org.aspectj.tools.ajdoc.PackageDocImpl;
import org.aspectj.tools.ajdoc.TagImpl;
import org.aspectj.tools.ajdoc.TypeImpl;

public class SeeTagImpl
extends TagImpl
implements SeeTag {
    private String packageName;
    private String className;
    private String memberName;
    private PackageDoc packageDoc;
    private com.sun.javadoc.ClassDoc classDoc;
    private MemberDoc memberDoc;
    private String label = "";
    private static JavaCompiler ajc = AjdocCompiler.instance();
    private boolean looked = false;

    public SeeTagImpl(Doc doc, String name, String text, Locale loc, ErrPrinter err) {
        super(doc, name, text, loc, err);
        this.resolve();
    }

    public String label() {
        return this.label;
    }

    public String referencedPackageName() {
        return this.packageName;
    }

    public PackageDoc referencedPackage() {
        this.look();
        return this.packageDoc;
    }

    public String referencedClassName() {
        return this.className;
    }

    public com.sun.javadoc.ClassDoc referencedClass() {
        this.look();
        return this.classDoc;
    }

    public String referencedMemberName() {
        return this.memberName;
    }

    public MemberDoc referencedMember() {
        this.look();
        return this.memberDoc;
    }

    public String kind() {
        return "@see";
    }

    protected JavaCompiler ajc() {
        if (ajc != null) {
            return ajc;
        }
        if (this.doc() instanceof ASTObject) {
            ajc = ((ASTObject)this.doc()).getCompiler();
            return ajc;
        }
        if (this.doc() instanceof PackageDocImpl) {
            ajc = ((PackageDocImpl)this.doc()).ajc();
            return ajc;
        }
        return null;
    }

    void debugState(String m, PrintStream err) {
        if (System.getProperty("seetag.debug") != null) {
            if (null == err) {
                err = System.err;
            }
            err.println("\t______________________ " + m + "\n\tpackageName: " + this.packageName + "\n\t packageDoc: " + this.packageDoc + "\n\t  className: " + this.className + "\n\t   classDoc: " + this.classDoc + "\n\t memberName: " + this.memberName + "\n\t  memberDoc: " + this.memberDoc + "\n\t      label: " + this.label);
        }
    }

    private void look() {
        if (!this.looked) {
            this.looked = true;
            this.dolook();
        }
        this.debugState("SeeTagImpl.look()", null);
    }

    private void dolook() {
        if (this.className == null || this.className.length() < 1) {
            this.classDoc = this.classDoc(this.doc());
        } else {
            com.sun.javadoc.ClassDoc container = this.classDoc(this.doc());
            if (container != null) {
                String fullName = this.packageName == null || this.packageName.length() < 1 ? this.className : this.packageName + '.' + this.className;
                if (this.memberName != null && this.memberName.indexOf(40) == -1) {
                    this.classDoc = container.findClass(fullName + '.' + this.memberName);
                    if (this.classDoc != null) {
                        this.memberName = null;
                    }
                }
                if (this.classDoc == null) {
                    this.classDoc = container.findClass(fullName);
                }
            }
        }
        if (this.classDoc != null) {
            this.packageDoc = this.classDoc.containingPackage();
        } else if (this.packageName == null) {
            if (this.classDoc == null && this.className != null && this.className.indexOf(46) == -1) {
                this.packageDoc = PackageDocImpl.getPackageDoc(this.className);
            } else if (this.classDoc != null) {
                this.packageDoc = this.classDoc.containingPackage();
            } else if (this.doc() instanceof PackageDoc) {
                this.packageDoc = (PackageDoc)this.doc();
            }
        } else {
            this.packageDoc = PackageDocImpl.getPackageDoc(this.packageName != null ? this.packageName : "");
        }
        if (this.memberName != null) {
            this.lookForMember(this.memberName, (ClassDoc)this.classDoc);
        }
    }

    private void lookForMember(String spec, ClassDoc container) {
        int irparen;
        String paramsString;
        String[] paramNames;
        String name;
        int ilparen = spec.indexOf(40);
        if (ilparen == -1) {
            name = spec;
            this.memberDoc = this.fieldDoc(name, container);
            if (this.memberDoc != null) {
                return;
            }
            this.memberDoc = this.methodDoc(name, container, null);
            if (this.memberDoc != null) {
                return;
            }
            this.memberDoc = this.pointcutDoc(name, container, null);
            if (this.memberDoc != null) {
                return;
            }
        } else {
            name = spec.substring(0, ilparen);
        }
        if ((this.memberDoc = this.methodDoc(name, container, paramNames = this.paramNames(paramsString = (irparen = spec.lastIndexOf(41)) != -1 ? spec.substring(ilparen + 1, irparen) : spec.substring(ilparen + 1, spec.length() - 1)))) != null) {
            return;
        }
        this.memberDoc = this.constructorDoc(container, paramNames);
        if (this.memberDoc != null) {
            return;
        }
        this.memberDoc = this.pointcutDoc(name, container, paramNames);
        if (this.memberDoc != null) {
            return;
        }
        if (container instanceof AspectDoc && (this.memberDoc = this.adviceDoc(name, (AspectDoc)container, paramNames)) != null) {
            return;
        }
    }

    private String[] paramNames(String restNoParens) {
        if (restNoParens == null || restNoParens.length() == 0) {
            return new String[0];
        }
        ArrayList<String> params = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(restNoParens, ",", false);
        while (t.hasMoreTokens()) {
            String spec = t.nextToken().trim();
            int ispace = spec.indexOf(32);
            if (ispace != -1) {
                spec = spec.substring(0, ispace);
            }
            params.add(spec);
        }
        return params.toArray(new String[params.size()]);
    }

    private FieldDoc fieldDoc(String name, com.sun.javadoc.ClassDoc container) {
        com.sun.javadoc.ClassDoc cd = container;
        while (cd != null) {
            FieldDoc[] docs = cd.fields();
            int i = 0;
            int N = docs.length;
            while (i < N) {
                if (docs[i].name().equals(name)) {
                    return docs[i];
                }
                ++i;
            }
            cd = cd.superclass();
        }
        return null;
    }

    private PointcutDoc pointcutDoc(String name, ClassDoc container, String[] paramNames) {
        if (null == name) {
            return null;
        }
        ClassDoc cd = container;
        while (cd != null) {
            PointcutDoc[] docs = cd.pointcuts();
            if (null != docs) {
                int i = 0;
                int N = docs.length;
                while (i < N) {
                    PointcutDoc md = docs[i];
                    if (null != md && name.equals(md.name()) && (null == paramNames || this.parametersMatch(md.parameters(), paramNames, container))) {
                        return md;
                    }
                    ++i;
                }
            }
            cd = (ClassDoc)cd.superclass();
        }
        return null;
    }

    private MethodDoc methodDoc(String name, com.sun.javadoc.ClassDoc container, String[] paramNames) {
        com.sun.javadoc.ClassDoc cd = container;
        while (cd != null) {
            MethodDoc[] docs = cd.methods();
            int i = 0;
            int N = docs.length;
            while (i < N) {
                MethodDoc md = docs[i];
                if (md.name().equals(name)) {
                    if (paramNames == null) {
                        return md;
                    }
                    if (this.parametersMatch(md.parameters(), paramNames, container)) {
                        return md;
                    }
                }
                ++i;
            }
            cd = cd.superclass();
        }
        return null;
    }

    private ConstructorDoc constructorDoc(com.sun.javadoc.ClassDoc container, String[] paramNames) {
        com.sun.javadoc.ClassDoc cd = container;
        while (cd != null) {
            ConstructorDoc[] docs = cd.constructors();
            int i = 0;
            int N = docs.length;
            while (i < N) {
                ConstructorDoc md = docs[i];
                if (paramNames == null) {
                    return md;
                }
                if (this.parametersMatch(md.parameters(), paramNames, container)) {
                    return md;
                }
                ++i;
            }
            cd = cd.superclass();
        }
        return null;
    }

    private AdviceDoc adviceDoc(String name, AspectDoc container, String[] paramNames) {
        AspectDoc cd = container;
        while (cd != null) {
            AdviceDoc[] docs = cd.advice();
            int i = 0;
            int N = docs.length;
            while (i < N) {
                AdviceDoc md = docs[i];
                if (name.equals(md.name())) {
                    if (paramNames == null) {
                        return md;
                    }
                    if (this.parametersMatch(md.parameters(), paramNames, container)) {
                        return md;
                    }
                }
                ++i;
            }
            com.sun.javadoc.ClassDoc o = cd.superclass();
            cd = o instanceof AspectDoc ? (AspectDoc)o : null;
        }
        return null;
    }

    private boolean parametersMatch(Parameter[] params, String[] paramNames, com.sun.javadoc.ClassDoc container) {
        if (null == params || null == paramNames || null == container) {
            return false;
        }
        if (params.length != paramNames.length) {
            return false;
        }
        int i = 0;
        int N = params.length;
        while (i < N) {
            Type type1 = params[i].type();
            Type type2 = TypeImpl.getInstance(paramNames[i], container);
            if (null == type1 || !type1.equals(type2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private com.sun.javadoc.ClassDoc classDoc(Doc d) {
        if (d instanceof com.sun.javadoc.ClassDoc) {
            return (com.sun.javadoc.ClassDoc)d;
        }
        if (d instanceof MemberDoc) {
            return ((MemberDoc)d).containingClass();
        }
        return null;
    }

    private static int findNextChar(String s, int start, char x) {
        if (null != s && start >= 0) {
            boolean escaped = false;
            int i = start;
            while (i < s.length()) {
                char c = s.charAt(i);
                if ('\\' == c && !escaped) {
                    escaped = true;
                } else {
                    if (x == c && !escaped) {
                        return i;
                    }
                    if (escaped) {
                        escaped = false;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private void resolve() {
        String str = this.text();
        if (str == null || str.length() < 1) {
            return;
        }
        str = str.trim();
        int N = str.length();
        char first = str.charAt(0);
        if (first == '<') {
            if (N < 4 || str.charAt(N - 1) != '>') {
                this.err().error("see_tag_unterminated_url", str);
            } else {
                char second = str.charAt(1);
                if (second == 'a' || second == 'A') {
                    this.label = str;
                } else {
                    this.err().error("see_tag_unterminated_url", str);
                }
            }
            return;
        }
        if (first == '\"') {
            if (N == 1) {
                this.err().error("see_tag_unterminated_string", str);
            } else if (str.charAt(N - 1) == '\"') {
                this.label = str;
            } else {
                int loc = SeeTagImpl.findNextChar(str, 1, '\"');
                if (-1 == loc) {
                    this.err().error("see_tag_unterminated_string", str);
                } else {
                    this.label = str.substring(0, loc + 1);
                }
            }
            return;
        }
        char c = '\u0000';
        int state = 0;
        int next = 0;
        boolean finished = false;
        int iclassEnd = -1;
        int isharp = -1;
        int ilastDot = -1;
        int iStartLabel = -1;
        int iEndMemberLabel = -1;
        boolean sharp = false;
        int i = 0;
        while (i < N) {
            c = str.charAt(i);
            switch (state) {
                case 0: {
                    if (TagImpl.ident(c)) {
                        next = 1;
                        break;
                    }
                    if (c == '#') {
                        next = 2;
                        iclassEnd = i - 1;
                        break;
                    }
                    this.err().error("see_tag_dot_sharp_or_id", "\"" + c + "\"@0", str);
                    return;
                }
                case 1: {
                    if (TagImpl.ident(c)) {
                        next = 1;
                        break;
                    }
                    if (c == '#') {
                        next = 2;
                        iclassEnd = i - 1;
                        break;
                    }
                    if (c == '.') {
                        next = 3;
                        ilastDot = i;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        iclassEnd = i - 1;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_invalid_package_or_class", "\"" + c + "\"@1", str);
                    return;
                }
                case 2: {
                    sharp = true;
                    if (TagImpl.ident(c)) {
                        next = 4;
                        isharp = i;
                        break;
                    }
                    this.err().error("see_tag_expecting_field_name", "\"" + c + "\"@2", str);
                    return;
                }
                case 3: {
                    if (TagImpl.ident(c)) {
                        next = 1;
                        break;
                    }
                    this.err().error("see_tag_invalid_id", "\"" + c + "\"@3", str);
                    return;
                }
                case 4: {
                    if (TagImpl.ident(c)) {
                        next = 4;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 13;
                        iEndMemberLabel = i - 1;
                        break;
                    }
                    if (c == '(') {
                        next = 15;
                        break;
                    }
                    this.err().error("see_tag_invalid_param_start", "\"" + c + "\"@4", str);
                    return;
                }
                case 5: {
                    if (TagImpl.ident(c)) {
                        next = 6;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 5;
                        break;
                    }
                    if (c == ')') {
                        next = 13;
                        iEndMemberLabel = i;
                        break;
                    }
                    this.err().error("see_tag_premature_param_end", "\"" + c + "\"@5", str);
                    return;
                }
                case 6: {
                    if (TagImpl.ident(c)) {
                        next = 6;
                        break;
                    }
                    if (c == '.') {
                        next = 7;
                        break;
                    }
                    if (c == '[') {
                        next = 8;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 10;
                        break;
                    }
                    if (c == ',') {
                        next = 12;
                        break;
                    }
                    if (c == ')') {
                        iEndMemberLabel = i;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameter_type", "\"" + c + "\"@6", str);
                    return;
                }
                case 7: {
                    if (TagImpl.ident(c)) {
                        next = 6;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameter_type_ident", "\"" + c + "\"@7", str);
                    return;
                }
                case 8: {
                    if (c == ']') {
                        next = 9;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 8;
                        break;
                    }
                    this.err().error("see_tag_unterminated_array_type", "\"" + c + "\"@8", str);
                    return;
                }
                case 9: {
                    if (c == '[') {
                        next = 8;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 10;
                        break;
                    }
                    if (c == ',') {
                        next = 12;
                        break;
                    }
                    if (c == ')') {
                        iEndMemberLabel = i;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameter_type", "\"" + c + "\"@9", str);
                    return;
                }
                case 10: {
                    if (TagImpl.ident(c)) {
                        next = 11;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 12;
                        break;
                    }
                    if (c == ',') {
                        next = 14;
                        break;
                    }
                    if (c == ')') {
                        iEndMemberLabel = i;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameters", "\"" + c + "\"@10", str);
                    return;
                }
                case 11: {
                    if (TagImpl.ident(c)) {
                        next = 11;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 12;
                        break;
                    }
                    if (c == ',') {
                        next = 14;
                        break;
                    }
                    if (c == ')') {
                        iEndMemberLabel = i;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameters", "\"" + c + "\"@11", str);
                    return;
                }
                case 12: {
                    if (TagImpl.space(c)) {
                        next = 12;
                        break;
                    }
                    if (c == ',') {
                        next = 14;
                        break;
                    }
                    if (TagImpl.ident(c)) {
                        next = 15;
                        break;
                    }
                    if (c == ')') {
                        iEndMemberLabel = i;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameters", "\"" + c + "\"@12", str);
                    return;
                }
                case 13: {
                    if (TagImpl.space(c)) {
                        next = 13;
                        break;
                    }
                    if (c == '(') {
                        next = 5;
                        break;
                    }
                    if (TagImpl.ident(c)) {
                        iStartLabel = i;
                        next = 17;
                        break;
                    }
                    this.err().error("see_tag_invalid_parameters", "\"" + c + "\"@13", str);
                    return;
                }
                case 14: {
                    if (TagImpl.ident(c)) {
                        next = 6;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 14;
                        break;
                    }
                    this.err().error("see_tag_expecting_typename_or_whitespace", "\"" + c + "\"@14", str);
                    return;
                }
                case 15: {
                    if (TagImpl.ident(c)) {
                        next = 6;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 15;
                        break;
                    }
                    if (c == ')') {
                        iEndMemberLabel = i;
                        next = 16;
                        break;
                    }
                    this.err().error("see_tag_premature_param_end", "\"" + c + "\"@15", str);
                    return;
                }
                case 16: {
                    if (TagImpl.ident(c)) {
                        iStartLabel = i;
                        next = 17;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 16;
                        break;
                    }
                    String s = "\"" + c + "\" in \"" + this.text() + "\"";
                    this.err().error("see_tag_premature_param_end", s + "@16", str);
                    return;
                }
                case 17: {
                    if (TagImpl.ident(c)) {
                        next = 17;
                        break;
                    }
                    if (TagImpl.space(c)) {
                        next = 17;
                        break;
                    }
                    this.err().error("see_tag_premature_param_end", "\"" + c + "\"@17", str);
                    return;
                }
            }
            if (i == N - 1) {
                finished = next == -1 || next == 1 || next == 13 || next == 16 || next == 17 || next == 4 || next == 12;
            }
            ++i;
            state = next;
        }
        if (sharp) {
            if (ilastDot != -1) {
                this.packageName = str.substring(0, ilastDot);
            }
        } else if (ilastDot != -1) {
            this.packageName = str.substring(0, ilastDot);
        }
        if (sharp) {
            if (iclassEnd != -1) {
                this.className = ilastDot == -1 ? str.substring(0, iclassEnd + 1) : str.substring(ilastDot + 1, iclassEnd + 1);
            }
        } else {
            this.className = ilastDot == -1 ? (iclassEnd != -1 ? str.substring(0, iclassEnd + 1) : str) : (iclassEnd != -1 ? str.substring(ilastDot + 1, iclassEnd + 1) : str.substring(ilastDot + 1));
        }
        if (sharp) {
            int spaceLoc;
            this.memberName = -1 != iEndMemberLabel ? str.substring(isharp, iEndMemberLabel + 1).trim() : str.substring(isharp).trim();
            int parmLoc = this.memberName.indexOf("(");
            if (-1 != parmLoc && -1 != (spaceLoc = this.memberName.indexOf(" ")) && spaceLoc < parmLoc) {
                this.memberName = this.memberName.substring(0, spaceLoc) + this.memberName.substring(parmLoc).trim();
            }
        }
        if (!finished) {
            this.err().error("see_tag_prematurely_done", str);
        } else if (iStartLabel != -1) {
            this.label = str.substring(iStartLabel).trim();
        } else if (i < N - 1) {
            this.label = str.substring(i).trim();
        }
    }

    String getPackageName() {
        return this.packageName;
    }

    String getClassName() {
        return this.className;
    }

    String getMemberName() {
        return this.memberName;
    }

    String getLabel() {
        return this.label;
    }
}

