/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import org.aspectj.tools.ajdoc.Ajdoc;

public class Main {
    public static final int PLATFORM_ERROR = 3;

    public static void main(String[] args) {
        System.exit(Main.execute(args));
    }

    public static int execute(String[] args) {
        int result = 0;
        String platformError = Main.platformErrorMessage();
        if (null != platformError) {
            result = 3;
            System.err.println(platformError);
        } else {
            Ajdoc me = new Ajdoc();
            result = me.execute(args);
        }
        return result;
    }

    public static String platformErrorMessage() {
        boolean failed = false;
        String[] versions = new String[]{"java.lang.reflect.Proxy"};
        int i = 0;
        while (i < versions.length) {
            try {
                Class.forName(versions[i]);
                failed = i == 1;
            }
            catch (ClassNotFoundException cnfe) {
                failed = i == 0;
            }
            catch (Error err) {
                boolean bl = failed = i == 0;
            }
            if (failed) {
                String version = "(unknown version)";
                try {
                    version = System.getProperty("java.version");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return "Ajdoc requires J2SE 1.3; not java " + version;
            }
            ++i;
        }
        try {
            Class.forName("com.sun.javadoc.RootDoc");
            Class.forName("com.sun.javadoc.Type");
        }
        catch (ClassNotFoundException cnfe) {
            return "Requires tools.jar from J2SE 1.3 (not 1.2 or 1.4) be on the class path";
        }
        catch (Error err) {
            return "Requires tools.jar from J2SE 1.3 (not 1.2 or 1.4) be on the class path";
        }
        return null;
    }
}

