/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ClassDoc;
import java.util.ArrayList;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.tools.ajdoc.AccessChecker;
import org.aspectj.tools.ajdoc.ClassDocImpl;
import org.aspectj.tools.ajdoc.ConstructorDocImpl;
import org.aspectj.tools.ajdoc.FieldDocImpl;
import org.aspectj.tools.ajdoc.MethodDocImpl;
import org.aspectj.tools.ajdoc.PointcutDocImpl;

public class FilteredDecList
extends ArrayList {
    protected final AccessChecker filter;
    protected final ClassDocImpl classDocImpl;
    protected final Type declaringType;

    FilteredDecList(AccessChecker filter, ClassDocImpl classDocImpl) {
        this.filter = null != filter ? filter : AccessChecker.PUBLIC;
        this.classDocImpl = classDocImpl;
        TypeDec td = null == classDocImpl ? null : classDocImpl.typeDec();
        this.declaringType = null == td ? null : td.getType();
    }

    protected final boolean sameType(Dec dec) {
        Type other = null == dec ? null : dec.getDeclaringType();
        boolean result = null != dec && (this.declaringType == null || this.declaringType.equals(other));
        return result;
    }

    protected void checkDec(Dec dec) {
        if (null == dec) {
            throw new IllegalArgumentException("null dec");
        }
    }

    public boolean add(ClassDocImpl outer, TypeDec dec) {
        ClassDocImpl doc;
        this.checkDec(dec);
        if (null == outer) {
            throw new IllegalArgumentException("null outer");
        }
        if (this.filter.canAccess(outer.typeDec()) && this.filter.canAccess(dec) && null != (doc = ClassDocImpl.getInstance(outer, dec))) {
            doc.setIncluded(true);
            return this.add(doc);
        }
        this.denied(outer, dec);
        return false;
    }

    public boolean add(TypeDec dec) {
        ClassDocImpl doc;
        this.checkDec(dec);
        if (this.filter.canAccess(dec) && null != (doc = ClassDocImpl.getInstance(dec))) {
            doc.setIncluded(true);
            return this.add(doc);
        }
        this.denied(dec);
        return false;
    }

    public boolean add(MethodDec dec) {
        this.checkDec(dec);
        if (this.sameType(dec) && this.filter.canAccess(dec)) {
            return this.add(new MethodDocImpl((ClassDoc)this.classDocImpl, dec));
        }
        this.denied(dec);
        return false;
    }

    public boolean add(ConstructorDec dec) {
        this.checkDec(dec);
        if (this.sameType(dec) && this.filter.canAccess(dec)) {
            return this.add(new ConstructorDocImpl((ClassDoc)this.classDocImpl, dec));
        }
        this.denied(dec);
        return false;
    }

    public boolean add(FieldDec dec) {
        this.checkDec(dec);
        if (this.sameType(dec) && this.filter.canAccess(dec)) {
            return this.add(new FieldDocImpl(this.classDocImpl, dec));
        }
        this.denied(dec);
        return false;
    }

    public boolean add(PointcutDec dec) {
        this.checkDec(dec);
        if (this.sameType(dec) && this.filter.canAccess(dec)) {
            return this.add(new PointcutDocImpl(this.classDocImpl, dec));
        }
        this.denied(dec);
        return false;
    }

    protected void denied(ClassDocImpl outer, TypeDec dec) {
    }

    protected void denied(Dec dec) {
    }
}

