/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.DocErrorReporter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.InternalCompilerError;

public class ErrPrinter
extends ErrorHandler
implements DocErrorReporter {
    public static final ErrPrinter instance = new ErrPrinter();
    private String programName;
    private PrintWriter out;
    private PrintWriter err;
    private ResourceBundle bundle;
    private List keys = new ArrayList();
    private List msgs = new ArrayList();
    static int cnt = 0;

    public ErrPrinter(String programName, PrintWriter err, PrintWriter out) {
        super(err);
        this.programName = programName;
        this.err = err;
        this.out = out;
        try {
            this.bundle = ResourceBundle.getBundle("org.aspectj.tools.ajdoc.resources.ajdoc");
        }
        catch (MissingResourceException e) {
            throw new Error("Can't find ajdoc.properties: " + e);
        }
    }

    public ErrPrinter(String programName) {
        this(programName, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
    }

    public ErrPrinter() {
        this("ajdoc");
    }

    public void printError(String error) {
        ++this.errors;
        this.err.println(error);
        this.err.flush();
    }

    public void printWarning(String warning) {
        ++this.warnings;
        this.err.println(warning);
        this.err.flush();
    }

    public void printNotice(String notice) {
        this.out.println(notice);
        this.out.flush();
    }

    public int getNumErrors() {
        return this.errors;
    }

    public int getNumWarnings() {
        return this.warnings;
    }

    public List getKeys() {
        return new ArrayList(this.keys);
    }

    public List getMsgs() {
        return new ArrayList(this.msgs);
    }

    public synchronized Throwable invocationTargetException(InvocationTargetException e, String classname, String methodName) {
        Throwable t = e.getTargetException();
        if (t != null) {
            if (t instanceof OutOfMemoryError) {
                this.error("out_of_memory");
            } else {
                this.error("exception_thrown", "", classname, methodName, t + "");
                t.printStackTrace();
            }
        }
        return t != null ? t : e;
    }

    public synchronized void internalError(String key, Throwable t) {
        this.internalError(key, "", t);
    }

    public synchronized void internalError(String key, String s0, Throwable t) {
        if (t instanceof InternalCompilerError) {
            t = ((InternalCompilerError)t).uncaughtThrowable;
        }
        this.error(key, s0, t != null ? t.getMessage() : "");
        if (t != null) {
            t.printStackTrace();
        }
        this.internalError(t, null);
    }

    public final int error(String key) {
        this.printError(this.text(key));
        return this.errors;
    }

    public final int error(String key, String s0) {
        this.printError(this.text(key, s0));
        return this.errors;
    }

    public final int error(String key, String s0, String s1) {
        this.printError(this.text(key, s0, s1));
        return this.errors;
    }

    public final int error(String key, String s0, String s1, String s2) {
        this.printError(this.text(key, s0, s1, s2));
        return this.errors;
    }

    public final int error(String key, String s0, String s1, String s2, String cookieMonster) {
        this.printError(this.text(key, s0, s1, s2, cookieMonster));
        return this.errors;
    }

    public final int ex(Throwable t, String key) {
        this.error(key);
        if (t != null) {
            t.printStackTrace();
        }
        return this.errors;
    }

    public final int ex(Throwable t, String key, String s0) {
        this.error(key, s0);
        if (t != null) {
            t.printStackTrace();
        }
        return this.errors;
    }

    public final int ex(Throwable t, String key, String s0, String s1) {
        this.error(key, s0, s1);
        if (t != null) {
            t.printStackTrace();
        }
        return this.errors;
    }

    public final int ex(Throwable t, String key, String s0, String s1, String s2) {
        this.error(key, s0, s1, s2);
        if (t != null) {
            t.printStackTrace();
        }
        return this.errors;
    }

    public final int ex(Throwable t, String key, String s0, String s1, String s2, String snuffulufugus) {
        this.error(key, s0, s1, s2, snuffulufugus);
        if (t != null) {
            t.printStackTrace();
        }
        return this.errors;
    }

    public final int warning(String key) {
        this.printWarning(this.text(key));
        return this.warnings;
    }

    public final int warning(String key, String s0) {
        this.printWarning(this.text(key, s0));
        return this.warnings;
    }

    public final int warning(String key, String s0, String s1) {
        this.printWarning(this.text(key, s0, s1));
        return this.warnings;
    }

    public final int warning(String key, String s0, String s1, String s2) {
        this.printWarning(this.text(key, s0, s1, s2));
        return this.warnings;
    }

    public final int warning(String key, String s0, String s1, String s2, String josefStalin) {
        this.printWarning(this.text(key, s0, s1, s2, josefStalin));
        return this.warnings;
    }

    public final void notice(String key) {
        this.printNotice(this.text(key));
    }

    public final void notice(String key, String s0) {
        this.printNotice(this.text(key, s0));
    }

    public final void notice(String key, String s0, String s1) {
        this.printNotice(this.text(key, s0, s1));
    }

    public final void notice(String key, String s0, String s1, String s2) {
        this.printNotice(this.text(key, s0, s1, s2));
    }

    public final void notice(String key, String s0, String s1, String s2, String bigbird) {
        this.printNotice(this.text(key, s0, s1, s2, bigbird));
    }

    protected final String text(String key) {
        return this.text(key, "");
    }

    protected final String text(String key, String s0) {
        return this.text(key, s0, "");
    }

    protected final String text(String key, String s0, String s1) {
        return this.text(key, s0, s1, "");
    }

    protected final String text(String key, String s0, String s1, String s2) {
        return this.text(key, s0, s1, s2, "");
    }

    protected final String text(String key, String s0, String s1, String s2, String oscarTheGrouch) {
        return this.text(key, new String[]{s0, s1, s2, oscarTheGrouch});
    }

    protected final String text(String key, String[] args) {
        String msg = MessageFormat.format(this.string(key), args);
        this.msgs.add(msg);
        return msg;
    }

    protected final String string(String key) {
        this.keys.add(key);
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            throw new Error("Can't find " + key + " in " + this.bundle);
        }
    }

    PrintWriter getErr() {
        return this.err;
    }

    PrintWriter getOut() {
        return this.out;
    }
}

