/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.WatchpointRequest;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.ClassAndFieldNeedingRequestAction;

public abstract class WatchRequest
extends ClassAndFieldNeedingRequestAction {
    public static final int ACCESS = 1;
    public static final int ALL = 16;

    public WatchRequest(Debugger debugger, String className, String fieldName) {
        super(debugger, className, fieldName);
    }

    EventRequest resolve(ReferenceType refType) throws MultipleLocationsException {
        WatchpointRequest request = null;
        try {
            if (refType.name().equals(this.className)) {
                request = this.getType() == 16 ? this.vm().eventRequestManager().createModificationWatchpointRequest(this.getField()) : this.vm().eventRequestManager().createAccessWatchpointRequest(this.getField());
                request.enable();
                request.setSuspendPolicy(2);
            }
        }
        catch (NoVMException e) {
        }
        catch (DebuggerException de) {
            // empty catch block
        }
        return request;
    }

    abstract int getType();
}

