/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Iterator;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.ThreadListener;
import org.aspectj.debugger.request.RequestActionSupport;

public abstract class ThreadRequestAction
extends RequestActionSupport
implements ThreadListener {
    protected String threadName;

    public ThreadRequestAction(Debugger debugger, String threadName) {
        super(debugger);
        this.threadName = threadName;
    }

    void resolveAll() {
        this.resolveAgainstAllThreads();
    }

    protected void addListeners() {
        super.addListeners();
        this.debugger.addThreadListener(this);
    }

    protected void removeListeners() {
        super.removeListeners();
        this.debugger.removeThreadListener(this);
    }

    abstract boolean isEnter();

    protected EventRequest resolve(ThreadReference threadRef) {
        try {
            if (this.isSame(threadRef)) {
                EventRequestManager em = this.vm().eventRequestManager();
                if (this.isEnter()) {
                    MethodEntryRequest entry = em.createMethodEntryRequest();
                    entry.addThreadFilter(threadRef);
                    entry.setSuspendPolicy(0);
                    entry.enable();
                    this.debugger.addExcludesTo(entry);
                    return entry;
                }
                MethodExitRequest exit = em.createMethodExitRequest();
                exit.addThreadFilter(threadRef);
                exit.setSuspendPolicy(0);
                exit.enable();
                this.debugger.addExcludesTo(exit);
                return exit;
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return null;
    }

    protected boolean isSame(ThreadReference threadRef) {
        if (threadRef.name().equals(this.threadName)) {
            return true;
        }
        try {
            long ourID = Long.parseLong(this.threadName);
            long refID = threadRef.uniqueID();
            if (ourID == refID) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    protected boolean resolveAgainstAllThreads() {
        try {
            Iterator<ThreadReference> iter = this.debugger.getVM().allThreads().iterator();
            while (iter.hasNext()) {
                if (this.setRequest(this.resolve(iter.next())) == null) continue;
                return this.success();
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return this.failure(true);
    }

    protected boolean resolveAgainstThread(ThreadReference threadRef) {
        if (this.setRequest(this.resolve(threadRef)) != null) {
            return this.success();
        }
        return this.failure(false);
    }

    public void threadStartEvent(ThreadStartEvent e) {
        if (!this.isSet()) {
            this.resolve(e.thread());
        }
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
    }
}

