/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public class ThreadGroupRequest
extends Request {
    protected String threadGroupName;

    public ThreadGroupRequest(Debugger debugger, String threadGroupName) {
        super(debugger);
        this.threadGroupName = threadGroupName;
    }

    public Object go() throws NoVMException, DebuggerException {
        Iterator<ThreadReference> iter = this.vm().allThreads().iterator();
        while (iter.hasNext()) {
            ThreadGroupReference threadGroupRef = iter.next().threadGroup();
            if (threadGroupRef.name().equals(this.threadGroupName)) {
                return threadGroupRef;
            }
            try {
                long ourID = Long.parseLong(this.threadGroupName);
                long refID = threadGroupRef.uniqueID();
                if (ourID != refID) continue;
                return threadGroupRef;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ThreadGroupNotFoundException(this.threadGroupName);
    }

    class ThreadGroupNotFoundException
    extends DebuggerException {
        public ThreadGroupNotFoundException(String threadGroupName) {
            super("thread group '" + threadGroupName + "' was not found.");
        }
    }
}

