/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.StackFrame;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.request.Request;
import org.aspectj.tools.ide.SourceLine;

public class ListRequest
extends Request {
    private String sourceName = null;
    private int startLineNumber = -1;
    private int endLineNumber = -1;

    public ListRequest(Debugger debugger) {
        this(debugger, null, -1, -1);
    }

    public ListRequest(Debugger debugger, String sourceName) {
        this(debugger, sourceName, -1, -1);
    }

    public ListRequest(Debugger debugger, String sourceName, int startLineNumber) {
        this(debugger, sourceName, startLineNumber, -1);
    }

    public ListRequest(Debugger debugger, String sourceName, int startLineNumber, int endLineNumber) {
        super(debugger);
        this.sourceName = sourceName;
        this.startLineNumber = startLineNumber;
        this.endLineNumber = endLineNumber;
    }

    private SourceAndLines empty(String sourceName) {
        Vector<SourceLine> v = new Vector<SourceLine>();
        v.add(this.ajdbg().emptySourceLine());
        return new SourceAndLines(sourceName, v);
    }

    public Object go() throws NoVMException, DebuggerException {
        SourceManager sm = this.debugger.getSourceManager();
        if (this.sourceName == null) {
            try {
                int line;
                StackFrame frame = this.dbg().getDefaultFrame();
                if (frame == null) {
                    return this.empty(this.sn());
                }
                int start = line = this.ajdbg().lineNumber(frame.location());
                int end = line;
                if (line > 0) {
                    int i = 0;
                    while (i < 4) {
                        ++end;
                        if (start > 1) {
                            --start;
                        }
                        ++i;
                    }
                    this.sourceName = this.ajdbg().sourceName(frame.location());
                    if (this.sourceName == null) {
                        return this.empty(this.sn());
                    }
                }
                this.startLineNumber = start;
                this.endLineNumber = end + 2;
            }
            catch (AbsentInformationException aie) {
                return this.empty(this.sn());
            }
        }
        if (this.startLineNumber == -1) {
            return this.sal(sm.getSourceLines(this.sourceName));
        }
        if (this.endLineNumber == -1) {
            return this.sal(sm.getSourceLine(this.sourceName, this.startLineNumber - 1));
        }
        return this.sal(sm.getSourceLines(this.sourceName, this.startLineNumber - 1, this.endLineNumber));
    }

    private String sn() {
        return this.sourceName == null ? "<not found>" : this.sourceName;
    }

    private SourceAndLines sal(SourceManager.SourceLine line) {
        Vector<SourceManager.SourceLine> lines = new Vector<SourceManager.SourceLine>();
        lines.add(line);
        return this.sal(lines);
    }

    private SourceAndLines sal(List lines) {
        return new SourceAndLines(this.sourceName, lines);
    }

    public static class SourceAndLines {
        private String sourceName;
        private List lines;

        public String getSourceName() {
            return this.sourceName;
        }

        public List getLines() {
            return this.lines;
        }

        public SourceAndLines(String sourceName, List lines) {
            this.sourceName = sourceName;
            this.lines = lines;
        }

        public String toString() {
            return this.sourceName + ":" + this.lines;
        }
    }
}

