/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public class ContRequest
extends Request {
    boolean printThreads = false;

    public ContRequest(Debugger debugger) {
        super(debugger);
    }

    public Object go() throws NoVMException, DebuggerException {
        this.dbg().setStatus("Continuing...");
        this.printThreads(true);
        this.dbg().resumeUntilZero();
        this.printThreads(false);
        return null;
    }

    void printThreads(boolean before) {
        try {
            if (!this.printThreads) {
                return;
            }
            Iterator<ThreadReference> threadIter = this.debugger.getVM().allThreads().iterator();
            System.out.print((before ? "BEFORE" : "AFTER") + ": ");
            while (threadIter.hasNext()) {
                ThreadReference threadRef = threadIter.next();
                System.out.print("(" + threadRef.uniqueID() + "):" + threadRef.suspendCount() + ", ");
            }
            System.out.println();
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }
}

