/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.InvalidClassException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public abstract class ClassesNeedingRequest
extends Request {
    private List classNames;

    public ClassesNeedingRequest(Debugger debugger, List classNames) {
        super(debugger);
        this.classNames = classNames;
    }

    public List getReferenceTypes() throws NoVMException, DebuggerException {
        Vector<ReferenceType> classes = new Vector<ReferenceType>();
        if (this.classNames == null || this.classNames.size() == 0) {
            return classes;
        }
        Iterator iter = this.classNames.iterator();
        while (iter.hasNext()) {
            String className = iter.next() + "";
            List<ReferenceType> refTypes = this.vm().classesByName(className);
            if (refTypes.size() == 0) {
                throw new InvalidClassException(className);
            }
            classes.addAll(refTypes);
        }
        return classes;
    }
}

