/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.Location;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.request.BreakpointRequest;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.gui.AJStackFrameFormatter;
import org.aspectj.debugger.ide.IDEInterface;
import org.aspectj.debugger.request.RequestAction;
import org.aspectj.tools.ide.SourceLine;

public abstract class BreakpointRequestAction
extends RequestAction
implements IDEInterface.SourceLineBreakable {
    private Location location;

    public BreakpointRequestAction(Debugger debugger) {
        super(debugger);
        if (!this.isSetting()) {
            debugger.removeStopListener(this);
        }
    }

    public boolean isBreakpoint() {
        return true;
    }

    public abstract int getLine();

    public abstract String getSourceName();

    public abstract String getProto();

    public int getRealLine() {
        return this.getLine();
    }

    public String getRealSourceName() {
        return this.getSourceName();
    }

    protected void setLocation(Location location) {
        this.location = location;
    }

    protected BreakpointRequest request(Location location) throws NoVMException {
        this.setLocation(location);
        BreakpointRequest req = (BreakpointRequest)this.getRequest();
        if (this.isSetting()) {
            req = this.vm().eventRequestManager().createBreakpointRequest(this.getLocation());
            req.setSuspendPolicy(2);
            req.enable();
        } else if (req != null) {
            this.vm().eventRequestManager().deleteEventRequest(req);
        }
        return req;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "breakpoint " + this.getProto();
    }

    public SourceLine sourceLine() {
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof AJStackFrameFormatter.MethodAndSource) {
            AJStackFrameFormatter.MethodAndSource ms = (AJStackFrameFormatter.MethodAndSource)o;
            return ms != null && this.getProto().equals(ms.getProto());
        }
        if (o instanceof BreakpointRequestAction) {
            BreakpointRequestAction bra = (BreakpointRequestAction)o;
            return this.getRealSourceName().equals(bra.getRealSourceName()) && this.getRealLine() == bra.getRealLine();
        }
        return super.equals(o);
    }

    public void breakpointEvent(BreakpointEvent e) {
        this.print(e);
    }
}

