/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.ide;

import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.ide.SourceShower;
import org.aspectj.debugger.request.BreakpointRequestAction;

public class SourcePane
extends AbstractSourcePane {
    private SourceShower shower;
    private ComponentDirector director;

    public SourcePane(GUIDebugger guid, SourceShower shower) {
        super(guid);
        this.shower = shower;
        this.director = guid.getGui();
    }

    public boolean showSource(String relativePath) {
        return this.shower.showSource(relativePath);
    }

    public void showLineForCurrentModel(int line, boolean isAtBreakpoint) {
        this.shower.showLineForCurrentModel(line, isAtBreakpoint);
    }

    public String getSourceName() {
        return this.shower.getSourceName();
    }

    public void requestSet(String filename, int line, BreakpointRequestAction ba) {
        this.showSourceForFileAndLine(filename, line);
    }

    public void requestClear(String filename, int line, BreakpointRequestAction ba) {
        this.showSourceForFileAndLine(filename, line);
    }

    public void requestDeferred(String filename, int line, BreakpointRequestAction ba) {
        this.showSourceForFileAndLine(filename, line);
    }
}

