/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.ide;

import org.aspectj.debugger.ide.FullPathSourceShower;
import org.aspectj.debugger.ide.IDEDebugger;
import org.aspectj.debugger.ide.IDEInterface;
import org.aspectj.debugger.ide.SourceShower;

public class Main {
    String mainClass;
    String classPath;
    String sourcePath;
    String mode;
    String shower;
    String ide;
    boolean verbose = false;

    SourceShower getShower() {
        if (this.shower != null) {
            try {
                return (SourceShower)Class.forName(this.shower).newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return FullPathSourceShower.proto;
    }

    /*
     * WARNING - void declaration
     */
    IDEInterface getIDE() {
        if (this.ide != null) {
            try {
                void t;
                IDEInterface i = (IDEInterface)Class.forName(this.ide).newInstance();
                System.out.println("i:" + i);
                return t;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        new Main().realMain(args);
    }

    public void realMain(String[] args) {
        this.parseArgs(args);
        IDEDebugger.launch(this.mainClass, this.sourcePath, this.classPath, this.mode, new String[0], this.getShower(), this.getIDE());
    }

    void parseArgs(String[] args) {
        String arg = "";
        String val = "";
        int i = 0;
        while (i < args.length) {
            arg = args[i];
            if (arg.equals("-mainclass")) {
                if (this.check("mainclass", args, i)) {
                    this.mainClass = args[++i];
                }
            } else if (arg.equals("-classpath")) {
                if (this.check("classpath", args, i)) {
                    this.classPath = args[++i];
                }
            } else if (arg.equals("-sourcepath")) {
                if (this.check("sourcepath", args, i)) {
                    this.sourcePath = args[++i];
                }
            } else if (arg.equals("-mode")) {
                if (this.check("mode", args, i)) {
                    this.mode = args[++i];
                }
            } else if (arg.equals("-shower")) {
                if (this.check("shower", args, i)) {
                    this.shower = args[++i];
                }
            } else if (arg.equals("-ide")) {
                if (this.check("ide", args, i)) {
                    this.ide = args[++i];
                }
            } else if (arg.equals("-verbose")) {
                this.verbose = true;
            }
            ++i;
        }
    }

    boolean check(String arg, String[] args, int i) {
        if (args == null || args.length < i || args[i + 1] == null) {
            this.exit("bad argument to " + arg + " i=" + i + " length=" + args.length);
            return false;
        }
        return true;
    }

    void exit(String msg) {
        System.err.println(msg);
        System.exit(1);
    }
}

