/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.ide;

import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.ErrorLogger;
import org.aspectj.debugger.base.Options;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.ide.IDEComponentDirector;
import org.aspectj.debugger.ide.IDEInterface;
import org.aspectj.debugger.ide.IDEInterfaceImpl;
import org.aspectj.debugger.ide.SourceShower;

public class IDEDebugger {
    public static ComponentDirector director;
    private String mainClass;
    private String sourcePath;
    private String classPath;
    private String workingdir;
    private String mode;
    private String[] args;

    public static void launch(String mainClass, String sourcePath, String classPath, String workingdir, String mode, String[] args, SourceShower shower, IDEInterface ide) {
        new IDEDebugger(mainClass, sourcePath, classPath, workingdir, mode, args, shower, ide).go();
    }

    public static void launch(String mainClass, String sourcePath, String classPath, String mode, String[] args, SourceShower shower, IDEInterface ide) {
        new IDEDebugger(mainClass, sourcePath, classPath, null, mode, args, shower, ide).go();
    }

    private IDEDebugger(String mainClass, String sourcePath, String classPath, String workingdir, String mode, String[] args, SourceShower sourceShower, IDEInterface ide) {
        this.mainClass = mainClass;
        this.sourcePath = sourcePath;
        this.classPath = classPath;
        this.workingdir = workingdir;
        this.mode = mode;
        this.args = args;
        if (ide == null) {
            ide = new IDEInterfaceImpl();
        }
    }

    private void go() {
        director.go();
        AJDebugger debugger = director.getGUIDebugger().getDebugger();
        Options options = debugger.getOptions();
        if (this.check(this.classPath)) {
            options.setClassPath(this.classPath);
        }
        if (this.check(this.sourcePath)) {
            options.setSourcePath(this.sourcePath);
        }
        if (this.check(this.mainClass)) {
            options.setMainClass(this.mainClass);
        }
        ((Debugger)debugger).setOptions(options);
        debugger.execute("use " + debugger.getSourcePath());
        if (this.check(this.workingdir)) {
            debugger.execute("workingdir " + this.workingdir);
        }
        if (director instanceof IDEComponentDirector) {
            ((IDEComponentDirector)director).finishUp();
        }
        try {
            if (this.check(this.mainClass)) {
                debugger.run(this.mainClass, this.args);
            }
        }
        catch (Throwable t) {
            ErrorLogger.error(t);
        }
    }

    private boolean check(String str) {
        return str != null && str.length() > 0;
    }
}

