/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.ide;

import java.util.Iterator;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.ide.IDEInterface;
import org.aspectj.debugger.ide.IDEInterfaceHelper;
import org.aspectj.debugger.ide.IDEInterfaceImpl;

public class IDEComponentDirector
extends ComponentDirector {
    public static IDEComponentDirector proto;
    protected IDEInterface ide;

    public IDEComponentDirector(String title, String mode, IDEInterface ide) {
        super(title, mode);
        if (ide == null) {
            ide = new IDEInterfaceImpl();
        }
        this.ide = ide;
    }

    public void go() {
        if (proto != null) {
            AJUtil.info("Only one debugger may run at once");
            this.getGUIDebugger().exit();
            return;
        }
        proto = this;
        super.go();
    }

    public void showBreakpointDialog() {
    }

    public void finishUp() {
        this.setBreakpoints();
    }

    public void title(String msg) {
    }

    public final void title() {
        this.title("");
    }

    public IDEInterface getIde() {
        return this.ide;
    }

    protected void setBreakpoints() {
        ((IDEInterfaceHelper)this.getIde()).settingBreakpointsFromIDE();
        try {
            try {
                this.setBreakpoints_();
            }
            catch (Exception t) {
                this.getGUIDebugger().getDebugger().handle(t);
                Object var3_2 = null;
                ((IDEInterfaceHelper)this.getIde()).doneSettingBreakpointsFromIDE();
            }
            Object var3_1 = null;
            ((IDEInterfaceHelper)this.getIde()).doneSettingBreakpointsFromIDE();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ((IDEInterfaceHelper)this.getIde()).doneSettingBreakpointsFromIDE();
            throw throwable;
        }
    }

    protected void setBreakpoints_() {
        Iterator iter = this.ide.getInitialBreakpoints().iterator();
        while (iter.hasNext()) {
            IDEInterface.SourceLineBreakable request = (IDEInterface.SourceLineBreakable)iter.next();
            try {
                String source = request.getSourceName();
                int line = request.getLine();
                this.getDebugger().stopOnCommand(source, line);
            }
            catch (DebuggerException de) {
                this.getGUIDebugger().handleDebuggerException(de);
            }
        }
    }

    public void shutDown() {
        proto = null;
        super.shutDown();
    }
}

