/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Iterator;
import java.util.List;
import org.aspectj.debugger.gui.MethodHelper;
import org.aspectj.debugger.gui.MethodNode;
import org.aspectj.debugger.gui.SourceNameFactory;

public class NonAJCMethodHelper
implements MethodHelper {
    private Method method;

    public NonAJCMethodHelper(Method method) {
        this.method = method;
    }

    public String getRealName() {
        return this.method.name();
    }

    public String getDisplayName() {
        return this.getRealName() + this.args();
    }

    public String getToolTipText() {
        return this.longName();
    }

    public String getClassName() {
        return this.method.declaringType().name();
    }

    private String longName() {
        return this.accessString() + " " + this.modsString() + " " + this.method.returnTypeName() + " " + this.method.name() + this.args();
    }

    private String modsString() {
        return (this.method.isAbstract() ? " abstract" : "") + (this.method.isFinal() ? " final" : "") + (this.method.isNative() ? " native" : "") + (this.method.isSynchronized() ? " synchronized" : "");
    }

    private String accessString() {
        if (this.method.isPublic()) {
            return "public";
        }
        if (this.method.isProtected()) {
            return "protected";
        }
        if (this.method.isPrivate()) {
            return "private";
        }
        return "";
    }

    private String args() {
        String str = "(";
        List<String> names = this.method.argumentTypeNames();
        if (names != null && names.size() > 0) {
            Iterator<String> iter = names.iterator();
            while (iter.hasNext()) {
                str = str + iter.next() + (iter.hasNext() ? "," : "");
            }
        }
        str = str + ")";
        return str;
    }

    public String getRelativePath() {
        return SourceNameFactory.sourceName(this.method.declaringType());
    }

    public int getLine() {
        Location loc = this.method.location();
        return loc != null ? loc.lineNumber() : -1;
    }

    public String getBreakpoint() {
        return this.method.declaringType().name() + "." + this.method.name() + this.args();
    }

    public int getType() {
        return MethodNode.getType(this.method.isConstructor(), this.method.isStatic(), this.method.isPublic(), this.method.isPrivate(), this.method.isProtected());
    }
}

