/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class FileModel
implements TreeModel {
    private Vector listeners = new Vector();
    private String root = null;

    public FileModel() {
        this(System.getProperty("user.home"));
    }

    public FileModel(String root) {
        if (root == null) {
            root = System.getProperty("user.home");
        }
        this.root = root;
    }

    public Object getChild(Object parent, int index) {
        File dir = (File)parent;
        String[] names = dir.list();
        return new File(dir, names[index]);
    }

    public int getChildCount(Object parent) {
        File pops = (File)parent;
        if (pops.isDirectory()) {
            return pops.list().length;
        }
        return 0;
    }

    public int getIndexOfChild(Object parent, Object child) {
        File dir = (File)parent;
        File file = (File)child;
        if (!dir.isDirectory()) {
            return 0;
        }
        String[] names = dir.list();
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(file.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object getRoot() {
        return new File(this.root);
    }

    public boolean isLeaf(Object node) {
        return !((File)node).isDirectory();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void addTreeModelListener(TreeModelListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        if (listener != null) {
            this.listeners.removeElement(listener);
        }
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        this.traverse(e, new TreeModelListenerDoer(){

            public void doit(TreeModelListener listener, TreeModelEvent _e) {
                listener.treeNodesChanged(_e);
            }
        });
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        this.traverse(e, new TreeModelListenerDoer(){

            public void doit(TreeModelListener listener, TreeModelEvent _e) {
                listener.treeNodesInserted(_e);
            }
        });
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        this.traverse(e, new TreeModelListenerDoer(){

            public void doit(TreeModelListener listener, TreeModelEvent _e) {
                listener.treeNodesRemoved(_e);
            }
        });
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        this.traverse(e, new TreeModelListenerDoer(){

            public void doit(TreeModelListener listener, TreeModelEvent _e) {
                listener.treeStructureChanged(_e);
            }
        });
    }

    private void traverse(TreeModelEvent e, TreeModelListenerDoer doer) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            doer.doit((TreeModelListener)enumeration.nextElement(), e);
        }
    }

    static interface TreeModelListenerDoer {
        public void doit(TreeModelListener var1, TreeModelEvent var2);
    }
}

