/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.aspectj.debugger.base.Debug;
import org.aspectj.debugger.base.Util;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.util.gui.CenteredJDialog;

public class ConnectFrame
extends CenteredJDialog {
    final boolean ALLOW_CONNECT_OPTIONS;
    private GUIDebugger guid;
    private static Connector current = null;
    private VirtualMachine vm;
    private static int ARG_TEXT_WIDTH = 40;

    public ConnectFrame(GUIDebugger guid) {
        super((Frame)null, "Please select a connector", true);
        this.guid = guid;
        this.ALLOW_CONNECT_OPTIONS = guid.getDebugger().getOptions().isSet("allowconnections");
    }

    public void setVm(VirtualMachine vm) {
        this.vm = vm;
    }

    public VirtualMachine getVm() {
        return this.vm;
    }

    public VirtualMachine select(String vmArgs, String className, String commandLine) {
        return this.ALLOW_CONNECT_OPTIONS ? this.connectorOptions(vmArgs, className, commandLine) : this.launchingConnector(vmArgs, className, commandLine);
    }

    private VirtualMachine launchingConnector(String vmArgs, String className, String commandLine) {
        Iterator<Connector> iter = Bootstrap.virtualMachineManager().allConnectors().iterator();
        while (iter.hasNext()) {
            Connector con = iter.next();
            if (!(con instanceof LaunchingConnector)) continue;
            current = con;
            this.setVm(new LaunchFrame(current).select(vmArgs, className, commandLine));
            return this.getVm();
        }
        return this.connectorOptions(vmArgs, className, commandLine);
    }

    private VirtualMachine connectorOptions(final String vmArgs, final String className, final String commandLine) {
        Container c = this.getContentPane();
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 1));
        Iterator<Connector> iter = Bootstrap.virtualMachineManager().allConnectors().iterator();
        ButtonGroup group = new ButtonGroup();
        boolean first = true;
        OKCancel okCancel = new OKCancel(this){

            public void ok() {
                ConnectFrame.this.setVm(new LaunchFrame(current).select(vmArgs, className, commandLine));
            }
        };
        while (iter.hasNext()) {
            final Connector con = iter.next();
            JRadioButton rb = new JRadioButton(new AbstractAction(con.description()){

                public void actionPerformed(ActionEvent e) {
                    current = con;
                }
            });
            if (first) {
                rb.setSelected(true);
                current = con;
            }
            first = false;
            group.add(rb);
            buttons.add(rb);
        }
        c.add((Component)buttons, "Center");
        c.add((Component)okCancel, "South");
        this.show();
        Debug.debug("vm=" + this.vm);
        return this.vm;
    }

    public static VirtualMachine vm(GUIDebugger guid, String vmArgs, String className, String commandLine) {
        return new ConnectFrame(guid).select(vmArgs, className, commandLine);
    }

    public static void main(String[] args) {
        System.out.println("my vm=" + new ConnectFrame(null).select(null, null, null));
    }

    static /* synthetic */ int access$500() {
        return ARG_TEXT_WIDTH;
    }

    private class LaunchFrame
    extends CenteredJDialog {
        Connector con;
        VirtualMachine vm = null;
        private OKCancel okCancel = null;

        LaunchFrame(Connector con) {
            super((Frame)null, "Please select launch parameters for " + con.name(), true);
            this.con = con;
        }

        VirtualMachine select(String vmArgs, String className, String commandLine) {
            Debug.debug("vmArgs:" + vmArgs + " className:" + className + " commandLine:" + commandLine);
            Map<String, Connector.Argument> args = this.con.defaultArguments();
            Vector<ArgPanel> options = new Vector<ArgPanel>();
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            this.okCancel = new OKCancel(this, options, args, this){
                private final /* synthetic */ List val$options;
                private final /* synthetic */ Map val$args;
                private final /* synthetic */ LaunchFrame this$1;
                {
                    this.this$1 = this$1;
                    this.val$options = val$options;
                    this.val$args = val$args;
                }

                public void ok() {
                    Iterator<E> opts = this.val$options.iterator();
                    while (opts.hasNext()) {
                        ArgPanel ap = (ArgPanel)opts.next();
                        Connector.Argument arg = ap.arg;
                        arg.setValue(ap.text.getText().trim());
                        Debug.debug(arg.name() + " --> " + arg.value());
                    }
                    if (this.this$1.con instanceof AttachingConnector) {
                        try {
                            this.this$1.vm = ((AttachingConnector)this.this$1.con).attach(this.val$args);
                        }
                        catch (IOException ioe) {
                        }
                        catch (IllegalConnectorArgumentsException iae) {}
                    } else if (this.this$1.con instanceof LaunchingConnector) {
                        try {
                            this.this$1.vm = ((LaunchingConnector)this.this$1.con).launch(this.val$args);
                        }
                        catch (IOException ioe) {
                        }
                        catch (IllegalConnectorArgumentsException iae) {
                        }
                        catch (VMStartException vmse) {}
                    } else if (this.this$1.con instanceof ListeningConnector) {
                        try {
                            this.this$1.vm = ((ListeningConnector)this.this$1.con).accept(this.val$args);
                        }
                        catch (IOException ioe) {
                        }
                        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                            // empty catch block
                        }
                    }
                }
            };
            Iterator<String> iter = args.keySet().iterator();
            while (iter.hasNext()) {
                String name = iter.next() + "";
                Connector.Argument arg = args.get(name);
                if ("main".equalsIgnoreCase(name)) {
                    String newMain;
                    String string = newMain = !Util.empty(className) ? className : ConnectFrame.this.guid.getClassNameToRun();
                    if (newMain != null) {
                        arg.setValue(newMain);
                    }
                }
                if ("options".equalsIgnoreCase(name)) {
                    String optionsStr = "";
                    if (!Util.empty(commandLine)) {
                        optionsStr = optionsStr + " " + commandLine;
                    }
                    String vmParameters = !Util.empty(vmArgs) ? vmArgs : ConnectFrame.this.guid.getVMParameters();
                    boolean alreadyHasClasspath = false;
                    if (!Util.empty(vmParameters)) {
                        alreadyHasClasspath = vmParameters.indexOf("-classpath") != -1;
                        optionsStr = optionsStr + " " + vmParameters;
                    }
                    String classpath = ConnectFrame.this.guid.getClasspath();
                    if (!alreadyHasClasspath && !Util.empty(classpath)) {
                        optionsStr = optionsStr + " -classpath \"" + classpath + "\"";
                    }
                    optionsStr = optionsStr.trim();
                    arg.setValue(optionsStr);
                }
                ArgPanel argp = new ArgPanel(arg);
                options.add(argp);
                p.add(argp);
            }
            this.getContentPane().add((Component)p, "Center");
            this.getContentPane().add((Component)this.okCancel, "South");
            this.show();
            return this.vm;
        }

        static /* synthetic */ ConnectFrame access$300(LaunchFrame x0) {
            return x0.ConnectFrame.this;
        }

        private class ArgPanel
        extends JPanel {
            Connector.Argument arg;
            JTextField text = new JTextField(ConnectFrame.access$500());

            ArgPanel(Connector.Argument arg) {
                this.arg = arg;
                this.setBorder(BorderFactory.createTitledBorder(arg.description()));
                this.add(new JLabel(arg.name() + ":"));
                String value = arg.value();
                this.text.setText(value);
                this.text.addActionListener(LaunchFrame.this.okCancel);
                this.add(this.text);
            }
        }
    }

    private class OKCancel
    extends JPanel
    implements ActionListener {
        JDialog frame;

        OKCancel(JDialog frame) {
            this.frame = frame;
            this.setLayout(new FlowLayout(1));
            JButton ok = new JButton(new AbstractAction(this, "OK"){
                private final /* synthetic */ OKCancel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    OKCancel.access$100(this.this$1);
                }
            });
            JButton cancel = new JButton(new AbstractAction(this, "Cancel"){
                private final /* synthetic */ OKCancel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    OKCancel.access$200(this.this$1);
                }
            });
            this.add(ok);
            this.add(cancel);
        }

        public void ok() {
        }

        public void cancel() {
        }

        private void realOk() {
            this.ok();
            this.frame.dispose();
            ((Component)this.frame).setVisible(false);
        }

        private void realCancel() {
            this.cancel();
            this.frame.dispose();
            ((Component)this.frame).setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.realOk();
        }

        static /* synthetic */ void access$100(OKCancel x0) {
            x0.realOk();
        }

        static /* synthetic */ void access$200(OKCancel x0) {
            x0.realCancel();
        }
    }
}

