/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.Modes;
import org.aspectj.debugger.gui.AJCenteredJFrame;
import org.aspectj.debugger.gui.AJMenuBar;
import org.aspectj.debugger.gui.AJThreadGroupTreePane;
import org.aspectj.debugger.gui.AJToolBar;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.AbstractTextArea;
import org.aspectj.debugger.gui.BreakpointTreePane;
import org.aspectj.debugger.gui.CommandLinePanel;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.EnvTextArea;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.OutputTextArea;
import org.aspectj.debugger.gui.StackTablePane;
import org.aspectj.debugger.gui.VariablesTreePane;
import org.aspectj.debugger.request.QuitRequest;

public class ComponentDirector
extends AJCenteredJFrame {
    PrintStream out = System.out;
    static final int THREAD_GROUP_TREE_PANE_HEIGHT = 550;
    static final int STACK_TABLE_PANE_HEIGHT = 150;
    static final int RIGHT_UPPER_HEIGHT = 380;
    static final int OUTPUT_TEXT_AREA_HEIGHT = 150;
    static final int ENV_TEXT_AREA_HEIGHT = 150;
    static final int COMMAND_LINE_HEIGHT = 20;
    static final int RIGHT_LOWER_HEIGHT = 320;
    static final int SOURCE_TREE_PANE_WIDTH = 200;
    static final int TREE_TABBED_PANE_WIDTH = 200;
    static final int SOURCE_PANE_WIDTH = 400;
    static final int LEFT_PANEL_WIDTH = 400;
    static final int RIGHT_PANEL_WIDTH = 600;
    static final int COMMAND_LINE_WIDTH = 600;
    static final int DIVIDER_SIZE = 5;
    static final Dimension THREAD_GROUP_TREE_PANE_DIM = new Dimension(400, 550);
    static final Dimension STACK_TABLE_PANE_DIM = new Dimension(400, 150);
    static final Dimension SOURCE_TREE_PANE_DIM = new Dimension(200, 380);
    static final Dimension TREE_TABBED_PANE_DIM = new Dimension(200, 380);
    static final Dimension SOURCE_PANE_DIM = new Dimension(400, 380);
    static final Dimension OUTPUT_TEXT_AREA_DIM = new Dimension(600, 150);
    static final Dimension ENV_TEXT_AREA_DIM = new Dimension(600, 150);
    static final Dimension COMMAND_LINE_DIM = new Dimension(600, 20);
    static final Dimension COMMAND_OUTPUT_PANEL_DIM = new Dimension(600, 320);
    protected OutputTextArea outputTextArea = null;
    protected EnvTextArea envTextArea = null;

    protected ComponentDirector() {
    }

    protected ComponentDirector(String title, String mode) {
        super(title);
        Modes.setMode(mode);
    }

    public ComponentDirector(String[] args) {
        this(args, null);
    }

    public AbstractTextArea getOutputTextArea() {
        return this.outputTextArea;
    }

    public AbstractTextArea getEnvTextArea() {
        return this.envTextArea;
    }

    public ComponentDirector(String[] args, WindowListener windowListener) {
        super("AspectJ Debugger");
        Modes.setMode("gui");
        ComponentRepository.init(this, args);
        AJMenuBar menuBar = ComponentRepository.getMenuBar();
        this.setJMenuBar(menuBar);
        StackTablePane stackTablePane = ComponentRepository.getStackTablePane();
        stackTablePane.setPreferredSize(STACK_TABLE_PANE_DIM);
        CommandLinePanel commandLine = new CommandLinePanel(true);
        commandLine.setPreferredSize(COMMAND_LINE_DIM);
        OutputTextArea outputTextArea = ComponentRepository.getOutputTextArea();
        outputTextArea.setPreferredSize(OUTPUT_TEXT_AREA_DIM);
        EnvTextArea envTextArea = ComponentRepository.getEnvTextArea();
        envTextArea.setPreferredSize(ENV_TEXT_AREA_DIM);
        BreakpointTreePane breakpointTreePane = ComponentRepository.getBreakpointTreePane();
        VariablesTreePane variablesTreePane = ComponentRepository.getVariablesTreePane();
        JTabbedPane treeTabbedPane = new JTabbedPane(3);
        treeTabbedPane.addTab("Breaks", null, breakpointTreePane);
        treeTabbedPane.addTab("Variables", null, variablesTreePane);
        treeTabbedPane.setPreferredSize(TREE_TABBED_PANE_DIM);
        AbstractSourcePane sourcePane = ComponentRepository.getSourcePane();
        sourcePane.setPreferredSize(SOURCE_PANE_DIM);
        AJThreadGroupTreePane threadGroupTreePane = ComponentRepository.getThreadGroupTreePane();
        threadGroupTreePane.setPreferredSize(THREAD_GROUP_TREE_PANE_DIM);
        AJToolBar toolbar = ComponentRepository.getToolBar();
        JSplitPane splitMain = null;
        JSplitPane splitLeft = null;
        JSplitPane splitRight = null;
        JSplitPane splitUpperRight = null;
        Object splitLowerRight = null;
        JPanel commandOutputPanel = null;
        splitUpperRight = this.makeSplit(1, treeTabbedPane, sourcePane);
        commandOutputPanel = new JPanel();
        commandOutputPanel.setLayout(new BorderLayout());
        commandOutputPanel.add((Component)envTextArea, "Center");
        commandOutputPanel.add((Component)commandLine, "South");
        commandOutputPanel.setPreferredSize(COMMAND_OUTPUT_PANEL_DIM);
        splitRight = this.makeSplit(0, splitUpperRight, commandOutputPanel);
        splitLeft = this.makeSplit(0, threadGroupTreePane, stackTablePane);
        splitMain = this.makeSplit(1, splitLeft, splitRight);
        this.getContentPane().add((Component)splitMain, "Center");
        JPanel bottomFiller = new JPanel();
        bottomFiller.setLayout(new BoxLayout(bottomFiller, 0));
        bottomFiller.add(Box.createHorizontalGlue());
        bottomFiller.add(toolbar);
        this.getContentPane().add((Component)toolbar, "South");
        if (windowListener != null) {
            this.addWindowListener(windowListener);
        } else {
            this.addWindowListener(this.getDefaultWindowListener());
        }
        this.pack();
        ((Component)this).setVisible(this.wantsToBeVisible());
    }

    protected WindowListener getDefaultWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    new QuitRequest(ComponentDirector.this.getDebugger()).go();
                }
                catch (Throwable t) {
                    ComponentDirector.this.getDebugger().quit();
                }
                System.exit(0);
            }
        };
    }

    protected boolean wantsToBeVisible() {
        return true;
    }

    private JSplitPane makeSplit(int placement, Component one, Component two) {
        JSplitPane sp = new JSplitPane(placement, one, two);
        sp.setDividerSize(5);
        return sp;
    }

    public GUIDebugger getGUIDebugger() {
        return ComponentRepository.getGUIDebugger();
    }

    public Debugger getDebugger() {
        return this.getGUIDebugger().getDebugger();
    }

    public void go() {
        this.getGUIDebugger().go();
    }

    public void setPrintStream(PrintStream out) {
        this.out = out;
    }

    public void restoreStreams() {
        if (this.outputTextArea != null) {
            this.outputTextArea.shutDown();
        }
        if (this.envTextArea != null) {
            this.envTextArea.shutDown();
        }
    }

    public void shutDown() {
        this.restoreStreams();
    }

    public PrintStream getPrintStream() {
        return this.out;
    }

    public String toString() {
        return ComponentDirector.d();
    }

    public static String d() {
        return "Component Director";
    }

    public void showThreadPane() {
    }

    public void makeTopLevel() {
        this.requestFocus();
    }
}

