/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.aspectj.debugger.gui.ComponentRepository;

public class ClassMethodBreakpointDialog
extends JDialog {
    static final int TEXT_COLS = 20;
    static final int METHOD_COLS = 20;
    static final int PARAMS_COLS = 42;
    private String mainMsg = "Create a class-line breakpoint";
    private JTextField classText = new JTextField(20);
    private JTextField methodText = new JTextField(20);
    private JTextField paramsText = new JTextField(42);

    public ClassMethodBreakpointDialog(Frame frame) {
        super(frame, "Set a Breakpoint", true);
        KeyAdapter george = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClassMethodBreakpointDialog.this.setBreakpoint();
                }
            }
        };
        this.classText.addKeyListener(george);
        this.methodText.addKeyListener(george);
        this.paramsText.addKeyListener(george);
        JPanel classTextPanel = new JPanel();
        classTextPanel.add(this.classText);
        classTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Class"));
        JPanel methodTextPanel = new JPanel();
        methodTextPanel.add(this.methodText);
        methodTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Method"));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(classTextPanel);
        topPanel.add(methodTextPanel);
        JPanel paramsTextPanel = new JPanel();
        paramsTextPanel.add(this.paramsText);
        paramsTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Parameters"));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(paramsTextPanel);
        Object[] components = new Object[]{this.mainMsg, topPanel, bottomPanel};
        JButton setButton = new JButton("Set");
        setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassMethodBreakpointDialog.this.setBreakpoint();
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassMethodBreakpointDialog.this.clear();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassMethodBreakpointDialog.this.cancel();
            }
        });
        Object[] buttons = new Object[]{setButton, clearButton, cancelButton};
        JOptionPane optionPane = new JOptionPane(components, 3, 0, null, buttons, buttons[0]);
        this.setContentPane(optionPane);
        this.setDefaultCloseOperation(2);
    }

    public ClassMethodBreakpointDialog() {
        this((Frame)null);
    }

    public void show() {
        this.pack();
        super.show();
        this.classText.requestFocus();
    }

    private void setBreakpoint() {
        String cmd = "stop in ";
        String className = this.classText.getText();
        String method = this.methodText.getText();
        String params = "";
        StringTokenizer tok = new StringTokenizer(this.paramsText.getText(), " ;,");
        if (tok.hasMoreTokens()) {
            params = params + "(";
        }
        while (tok.hasMoreTokens()) {
            params = params + tok.nextToken();
            params = params + (tok.hasMoreTokens() ? "," : ")");
        }
        cmd = cmd + className + "." + method + params;
        ComponentRepository.getCommandLine().executeCommand(cmd);
        this.clear();
        this.hide();
    }

    private void clear() {
        this.classText.setText("");
        this.methodText.setText("");
        this.paramsText.setText("");
    }

    private void cancel() {
        this.hide();
    }
}

