/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.ComponentRepository;

public class ClassLineBreakpointDialog
extends JDialog {
    static final int TEXT_COLS = 20;
    static final int LINE_COLS = 5;
    private String mainMsg = "Create a class-line breakpoint";
    private JTextField classText = new JTextField(20);
    private JTextField lineText = new JTextField(5);

    public ClassLineBreakpointDialog(Frame frame) {
        super(frame, "Set a Breakpoint", true);
        this.classText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClassLineBreakpointDialog.this.setBreakpoint();
                }
            }
        });
        this.lineText.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClassLineBreakpointDialog.this.setBreakpoint();
                }
            }
        });
        JPanel classTextPanel = new JPanel();
        classTextPanel.add(this.classText);
        classTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Class"));
        JPanel lineTextPanel = new JPanel();
        lineTextPanel.add(this.lineText);
        lineTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Line"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(classTextPanel);
        mainPanel.add(lineTextPanel);
        Object[] components = new Object[]{this.mainMsg, mainPanel};
        JButton setButton = new JButton("Set");
        setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLineBreakpointDialog.this.setBreakpoint();
            }
        });
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLineBreakpointDialog.this.clear();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassLineBreakpointDialog.this.cancel();
            }
        });
        Object[] buttons = new Object[]{setButton, clearButton, cancelButton};
        JOptionPane optionPane = new JOptionPane(components, 3, 0, null, buttons, buttons[0]);
        this.setContentPane(optionPane);
        this.setDefaultCloseOperation(2);
    }

    public ClassLineBreakpointDialog() {
        this((Frame)null);
    }

    public void show() {
        this.pack();
        super.show();
        this.classText.requestFocus();
    }

    private void setBreakpoint() {
        String className = this.classText.getText();
        int line = -1;
        try {
            line = Integer.parseInt(this.lineText.getText());
        }
        catch (NumberFormatException e) {
            AJUtil.warn("The line field must contain a number");
            return;
        }
        String cmd = "stop at " + className + ":" + line;
        ComponentRepository.getCommandLine().executeCommand(cmd);
        this.clear();
        this.hide();
    }

    private void clear() {
        this.classText.setText("");
        this.lineText.setText("");
    }

    private void cancel() {
        this.hide();
    }
}

