/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreePath;
import org.aspectj.debugger.gui.BreakpointTreeCellRenderer;
import org.aspectj.debugger.gui.BreakpointTreeModel;
import org.aspectj.debugger.gui.BreakpointTreeNode;
import org.aspectj.debugger.gui.NoCollapsingRootExpansionListener;

class BreakpointTree
extends JTree {
    private Frame frame = null;

    public BreakpointTree(Frame frame) {
        super(new BreakpointTreeModel());
        this.frame = frame;
        this.setCellRenderer(new BreakpointTreeCellRenderer());
        this.addMouseListener(new BreakpointMouseListener());
        this.addTreeSelectionListener(new BreakpointTreeSelectionListener());
        this.addTreeWillExpandListener(new NoCollapsingRootExpansionListener(this));
    }

    public BreakpointTree() {
        this((Frame)null);
    }

    public Frame getFrame() {
        return this.frame;
    }

    void remove(Object o) {
        ((BreakpointTreeModel)this.getModel()).remove(o);
        this.modernize();
    }

    void modernize() {
        TreeUI newUI = (TreeUI)UIManager.getUI(this);
        if (this.ui != null) {
            try {
                this.ui.uninstallUI(this);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        ComponentUI oldUI = this.ui;
        this.ui = newUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", oldUI, newUI);
        this.revalidate();
        this.repaint();
    }

    private class BreakpointTreeSelectionListener
    implements TreeSelectionListener {
        private BreakpointTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getPath();
            BreakpointTreeNode node = (BreakpointTreeNode)path.getLastPathComponent();
            node.selection(BreakpointTree.this);
        }
    }

    private class BreakpointMouseListener
    extends MouseAdapter {
        private BreakpointMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int row = BreakpointTree.this.getRowForLocation(e.getX(), e.getY());
            if (row != -1 && e.getClickCount() == 1) {
                TreePath[] paths = BreakpointTree.this.getSelectionPaths();
                if (paths == null) {
                    paths = new TreePath[]{};
                    paths[0] = BreakpointTree.this.getPathForLocation(e.getX(), e.getY());
                }
                int i = 0;
                while (i < paths.length) {
                    BreakpointTreeNode node = (BreakpointTreeNode)paths[i].getLastPathComponent();
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        node.leftMouseButton(BreakpointTree.this, e);
                    } else if (SwingUtilities.isMiddleMouseButton(e)) {
                        node.middleMouseButton(BreakpointTree.this, e);
                    } else if (SwingUtilities.isRightMouseButton(e)) {
                        node.rightMouseButton(BreakpointTree.this, e);
                    }
                    ++i;
                }
            }
        }
    }
}

