/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.Serializable;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.gui.AJDataFlavor;
import org.aspectj.debugger.gui.ComponentRepository;

public class AJValueWrapper
implements Transferable,
Serializable {
    Object value = null;

    public AJValueWrapper(Value value) {
        this.value = this.wrap(value);
    }

    public Value unwrap() {
        Value result = null;
        try {
            VirtualMachine vm = ComponentRepository.vm();
            if (this.value instanceof Byte) {
                result = vm.mirrorOf((Byte)this.value);
            } else if (this.value instanceof Character) {
                result = vm.mirrorOf(((Character)this.value).charValue());
            } else if (this.value instanceof Double) {
                result = vm.mirrorOf((Double)this.value);
            } else if (this.value instanceof Float) {
                result = vm.mirrorOf(((Float)this.value).floatValue());
            } else if (this.value instanceof Integer) {
                result = vm.mirrorOf((Integer)this.value);
            } else if (this.value instanceof Long) {
                result = vm.mirrorOf((Long)this.value);
            } else if (this.value instanceof Short) {
                result = vm.mirrorOf((Short)this.value);
            } else if (this.value instanceof String) {
                result = vm.mirrorOf(((String)this.value).toString());
            }
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
        return result;
    }

    private Object wrap(Value value) {
        Object result = null;
        if (value instanceof ByteValue) {
            result = new Byte(((ByteValue)value).byteValue());
        } else if (value instanceof CharValue) {
            result = new Character(((CharValue)value).charValue());
        } else if (value instanceof DoubleValue) {
            result = new Double(((DoubleValue)value).doubleValue());
        } else if (value instanceof FloatValue) {
            result = new Float(((FloatValue)value).floatValue());
        } else if (value instanceof IntegerValue) {
            result = new Integer(((IntegerValue)value).intValue());
        } else if (value instanceof LongValue) {
            result = new Long(((LongValue)value).longValue());
        } else if (value instanceof ShortValue) {
            result = new Short(((ShortValue)value).shortValue());
        } else if (value instanceof StringReference) {
            result = new String(((StringReference)value).toString());
        }
        return result;
    }

    public Object getTransferData(DataFlavor flavor) {
        return this;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return AJDataFlavor.FLAVORS;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean ok = false;
        if (flavor.getHumanPresentableName().equals("AJValueWrapper")) {
            ok = true;
        }
        return ok;
    }
}

