/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.VirtualMachine;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.gui.AJTreeNodeMenu;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.HexableAJValueNode;

public class AJValueNodeMenu
extends AJTreeNodeMenu {
    private AJValueNode valueNode;
    private JMenuItem menuItemChange = new JMenuItem("Change value");
    private JMenuItem menuItemWatch = new JMenuItem("Set watchpoint");
    private JMenuItem menuItemHex = new JMenuItem();

    public AJValueNodeMenu() {
        this((AJValueNode)null);
    }

    public AJValueNodeMenu(AJValueNode valueNode) {
        this.setValueNode(valueNode);
        this.add(this.menuItemWatch());
        this.add(this.menuItemChange());
        if (valueNode instanceof HexableAJValueNode) {
            this.add(this.menuItemHex());
        }
    }

    public void setValueNode(AJValueNode valueNode) {
        this.valueNode = valueNode;
        if (valueNode == null) {
            this.menuItemWatch.setEnabled(false);
            this.menuItemChange.setEnabled(false);
        } else if (!valueNode.canSetWatchPoint()) {
            this.menuItemWatch.setEnabled(false);
            this.menuItemChange.setEnabled(true);
        } else {
            boolean canSetWatchPoint = true;
            try {
                VirtualMachine vm = ComponentRepository.vm();
                canSetWatchPoint = vm.canWatchFieldAccess() && vm.canWatchFieldModification();
            }
            catch (NoVMException noVMException) {
                // empty catch block
            }
            this.menuItemWatch.setEnabled(canSetWatchPoint);
            this.menuItemChange.setEnabled(true);
        }
    }

    private JMenuItem menuItemChange() {
        this.menuItemChange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AJValueNodeMenu.this.setValue();
            }
        });
        return this.menuItemChange;
    }

    private JMenuItem menuItemWatch() {
        this.menuItemWatch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AJValueNodeMenu.this.setWatchPoint();
            }
        });
        return this.menuItemWatch;
    }

    private JMenuItem menuItemHex() {
        this.menuItemHex.setText("To " + (((HexableAJValueNode)this.valueNode).isHex() ? "decimal" : "hex"));
        this.menuItemHex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AJValueNodeMenu.this.toHex();
            }
        });
        return this.menuItemHex;
    }

    private void setWatchPoint() {
        if (this.valueNode == null) {
            return;
        }
        if (!this.valueNode.canSetWatchPoint()) {
            return;
        }
        this.valueNode.setWatchPoint();
    }

    private void setValue() {
        if (this.valueNode == null) {
            return;
        }
        this.valueNode.setValue();
    }

    private void toHex() {
        if (this.valueNode == null) {
            return;
        }
        if (!(this.valueNode instanceof HexableAJValueNode)) {
            return;
        }
        ((HexableAJValueNode)this.valueNode).toggle();
    }
}

