/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import org.aspectj.debugger.gui.AJArrayMemberValueGetter;
import org.aspectj.debugger.gui.AJArrayValueNode;
import org.aspectj.debugger.gui.AJBooleanValueNode;
import org.aspectj.debugger.gui.AJByteValueNode;
import org.aspectj.debugger.gui.AJCharValueNode;
import org.aspectj.debugger.gui.AJDoubleValueNode;
import org.aspectj.debugger.gui.AJFloatValueNode;
import org.aspectj.debugger.gui.AJIntegerValueNode;
import org.aspectj.debugger.gui.AJLocalVariableValueGetter;
import org.aspectj.debugger.gui.AJLongValueNode;
import org.aspectj.debugger.gui.AJMemberValueGetter;
import org.aspectj.debugger.gui.AJObjectReferenceValueGetter;
import org.aspectj.debugger.gui.AJObjectValueNode;
import org.aspectj.debugger.gui.AJReferenceTypeMemberValueGetter;
import org.aspectj.debugger.gui.AJShortValueNode;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.AJValueNode;

public class AJValueNodeFactory {
    public static AJValueNode make(LocalVariable local, StackFrame frame) {
        return AJValueNodeFactory.make(new AJLocalVariableValueGetter(local, frame), local.signature());
    }

    public static AJValueNode make(ReferenceType refType, Field field) {
        return AJValueNodeFactory.make(new AJReferenceTypeMemberValueGetter(refType, field), field.signature());
    }

    public static AJValueNode make(ObjectReference object, String name) {
        return AJValueNodeFactory.make(new AJObjectReferenceValueGetter(object, name), object.referenceType().signature());
    }

    public static AJValueNode make(ObjectReference parent, Field field) {
        return AJValueNodeFactory.make(new AJMemberValueGetter(parent, field), field.signature());
    }

    public static AJValueNode make(ArrayReference arrayParent, int index) {
        return AJValueNodeFactory.make(new AJArrayMemberValueGetter(arrayParent, index), arrayParent.getValue(0).type().signature());
    }

    private static AJValueNode make(AJValueGetter g, String sig) {
        if (sig.equals("Z")) {
            return new AJBooleanValueNode(g);
        }
        if (sig.equals("B")) {
            return new AJByteValueNode(g);
        }
        if (sig.equals("C")) {
            return new AJCharValueNode(g);
        }
        if (sig.equals("D")) {
            return new AJDoubleValueNode(g);
        }
        if (sig.equals("F")) {
            return new AJFloatValueNode(g);
        }
        if (sig.equals("I")) {
            return new AJIntegerValueNode(g);
        }
        if (sig.equals("J")) {
            return new AJLongValueNode(g);
        }
        if (sig.startsWith("S")) {
            return new AJShortValueNode(g);
        }
        if (sig.startsWith("L")) {
            return new AJObjectValueNode(g);
        }
        if (sig.startsWith("[")) {
            return new AJArrayValueNode(g);
        }
        return new AJValueNode(g);
    }
}

