/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.Modes;
import org.aspectj.debugger.base.ThreadListener;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.gui.AJActionsConsts;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AbstractActionStruct;
import org.aspectj.debugger.gui.BreakpointAction;
import org.aspectj.debugger.gui.CatchAction;
import org.aspectj.debugger.gui.ClearAction;
import org.aspectj.debugger.gui.CommandLine;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.ContAction;
import org.aspectj.debugger.gui.DisconnectAction;
import org.aspectj.debugger.gui.DumpAction;
import org.aspectj.debugger.gui.EvalAction;
import org.aspectj.debugger.gui.FieldsAction;
import org.aspectj.debugger.gui.ForteResumeAction;
import org.aspectj.debugger.gui.ForteRunAction;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.IDELineBreakpointAction;
import org.aspectj.debugger.gui.LocalsAction;
import org.aspectj.debugger.gui.NextAction;
import org.aspectj.debugger.gui.PrintAction;
import org.aspectj.debugger.gui.QuitAction;
import org.aspectj.debugger.gui.ResumeAction;
import org.aspectj.debugger.gui.RunAction;
import org.aspectj.debugger.gui.StepAction;
import org.aspectj.debugger.gui.StepIAction;
import org.aspectj.debugger.gui.StepUpAction;
import org.aspectj.debugger.gui.SuspendAction;
import org.aspectj.debugger.gui.ThreadGetter;
import org.aspectj.debugger.gui.UseAction;
import org.aspectj.debugger.gui.WatchAction;
import org.aspectj.debugger.gui.WhereAction;

public class AJToolBar
extends JToolBar
implements AJActionsConsts,
ThreadListener,
VMListener {
    JComboBox comboBox = this.comboBox();
    JToolBar toolBar = new JToolBar();
    static final String ALL_THREADS = "All threads";
    static final int FONT_SIZE = 10;
    static final int SC_FONT_SIZE = 8;
    static final double WIDTH_FACTOR = 0.7;
    static final double HEIGHT_FACTOR = 0.4;
    private AJDebugger debugger;

    public AJToolBar(GUIDebugger guid) {
        this.debugger = guid.getDebugger();
        this.debugger.addThreadListener(this);
        this.debugger.addVMListener(this);
        String mode = Modes.getMode();
        if (mode.equals("gui")) {
            this.createGuiToolbar(guid);
        } else {
            this.createForteToolbar(guid);
        }
    }

    private void createForteToolbar(GUIDebugger guid) {
        this.badd(new ForteRunAction(guid));
        this.badd(new ContAction(guid));
        this.badd(new QuitAction(guid));
        this.badd(new SuspendAction(guid, this.threadGetter()));
        this.badd(new ForteResumeAction(guid, this.threadGetter()));
        this.badd(new StepAction(guid));
        this.badd(new StepIAction(guid));
        this.badd(new NextAction(guid));
        this.badd(new StepUpAction(guid));
        this.badd(new IDELineBreakpointAction(guid), "Add Breakpoint");
        this.badd(new WatchAction(guid));
    }

    private void jbSeparator() {
        this.addSeparator();
    }

    private void createGuiToolbar(GUIDebugger guid) {
        this.badd(new QuitAction(guid));
        this.badd(new UseAction(guid));
        this.badd(new DisconnectAction(guid));
        this.badd(new RunAction(guid));
        this.addSeparator();
        this.badd(new BreakpointAction(guid));
        this.badd(new CatchAction(guid));
        this.badd(new ClearAction(guid));
        this.badd(new ContAction(guid));
        this.badd(new NextAction(guid));
        this.badd(new StepAction(guid));
        this.badd(new StepUpAction(guid));
        this.badd(new StepIAction(guid));
        this.addSeparator();
        this.badd(new SuspendAction(guid, this.threadGetter()));
        this.badd(new ResumeAction(guid, this.threadGetter()));
        this.badd(new WhereAction(guid, this.threadGetter()));
        this.comboBox = this.comboBox();
        this.add(this.comboBox);
        this.addSeparator();
        this.badd(new DumpAction(guid));
        this.badd(new EvalAction(guid));
        this.badd(new FieldsAction(guid));
        this.badd(new LocalsAction(guid));
        this.badd(new PrintAction(guid));
        this.add(Box.createHorizontalGlue());
    }

    public AJDebugger getDebugger() {
        return this.debugger;
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
        this.removeThread(e.thread());
    }

    public void threadStartEvent(ThreadStartEvent e) {
        this.addThread(e.thread());
    }

    public void vmDeathEvent(VMDeathEvent e) {
        this.clearThreads();
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        this.clearThreads();
    }

    public void vmStartEvent(VMStartEvent e) {
        this.clearThreads();
        try {
            Iterator<ThreadReference> iter = this.getDebugger().vm().allThreads().iterator();
            while (iter.hasNext()) {
                this.addThread(iter.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JComboBox comboBox() {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox();
        }
        this.comboBox.addItem(new ThreadPair(ALL_THREADS, -1L));
        this.comboBox.setPreferredSize(new Dimension(100, 30));
        return this.comboBox;
    }

    ThreadGetter threadGetter() {
        return new ThreadGetter(){

            public String getThread() {
                ThreadPair pair = (ThreadPair)AJToolBar.this.comboBox.getSelectedItem();
                if (pair.id != -1L) {
                    return pair.id + "";
                }
                return "";
            }
        };
    }

    private void addToT(JComponent c) {
        this.toolBar.add(c);
    }

    private void addT(String title) {
        this.toolBar.setToolTipText(title);
        this.toolBar.setName(title);
        this.add(this.toolBar);
        this.toolBar = new JToolBar();
    }

    private void badd(AbstractActionStruct a) {
        this.badd(a, null);
    }

    private void badd(AbstractActionStruct a, String toolTipText) {
        this.badd(a, toolTipText, null, null);
    }

    private void badd(AbstractActionStruct a, String toolTipText, final String toolTipText2, final GUIDebugger guid) {
        Icon icon = (Icon)a.getValue("icon");
        JButton b = guid == null ? new JButton(icon) : new JButton(icon){

            public String getToolTipText() {
                return guid.getDebugger().isRunning() ? toolTipText2 : super.getToolTipText();
            }
        };
        String name = (String)a.getValue("label");
        JLabel label = new JLabel(name);
        String shortCutStr = KeyEvent.getKeyModifiersText(a.mask()) + "-" + KeyEvent.getKeyText(a.key());
        JLabel shortCutLabel = new JLabel(shortCutStr);
        Font f = label.getFont();
        label.setFont(new Font(f.getName(), f.getStyle(), 8));
        shortCutLabel.setFont(new Font(f.getName(), f.getStyle(), 10));
        b.addActionListener(a);
        if (toolTipText == null) {
            b.setToolTipText(name + " [" + shortCutStr + "]");
        } else {
            b.setToolTipText(toolTipText);
        }
        this.forward(b);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)b, "Center");
        this.forward(p);
        this.changeDim(p);
        this.add(p);
    }

    void forward(JComponent c) {
        c.setNextFocusableComponent(ComponentRepository.getCommandLine());
    }

    void changeDim(JComponent b) {
        Dimension d = b.getPreferredSize();
        double w = d.getWidth();
        double h = d.getHeight();
        double wp = 0.7 * w;
        double hp = 0.4 * h;
        Dimension newD = new Dimension((int)wp, (int)h);
        b.setMaximumSize(newD);
        b.setMinimumSize(newD);
        b.setPreferredSize(newD);
    }

    private Action action(final String str, int icon) {
        return new AbstractAction(str, AJIcons.getIcon(icon)){

            public void actionPerformed(ActionEvent e) {
                AJToolBar.this.execute(str);
            }
        };
    }

    void execute(String str) {
        CommandLine cl = ComponentRepository.getCommandLine();
        if (cl != null) {
            cl.executeCommand(str);
        }
    }

    void clearThreads() {
        if (this.comboBox != null) {
            this.comboBox.removeAllItems();
        }
        this.comboBox = this.comboBox();
    }

    void addThread(ThreadReference threadRef) {
        this.addThread(threadRef.name(), threadRef.uniqueID());
    }

    void addThread(String name, long id) {
        if (this.comboBox == null) {
            return;
        }
        ThreadPair newPair = new ThreadPair(name, id);
        int i = 1;
        int size = this.comboBox.getModel().getSize();
        long pid = -1L;
        Object pair = null;
        while (i < size && (pid = ((ThreadPair)this.comboBox.getModel().getElementAt((int)i)).id) < id) {
            ++i;
        }
        if (pid != id) {
            this.comboBox.insertItemAt(newPair, i);
        }
    }

    void removeThread(ThreadReference threadRef) {
        this.removeThread(threadRef.name(), threadRef.uniqueID());
    }

    void removeThread(String name, long id) {
        if (this.comboBox == null) {
            return;
        }
        int i = 0;
        while (i < this.comboBox.getModel().getSize()) {
            ThreadPair pair = (ThreadPair)this.comboBox.getModel().getElementAt(i);
            if (pair.name.equals(name) && pair.id == id) {
                this.comboBox.removeItemAt(i);
            }
            ++i;
        }
    }

    public static String d() {
        return "Toolbar";
    }

    public String toString() {
        return AJToolBar.d();
    }

    static class ThreadPair {
        String name;
        long id;

        ThreadPair(String name, long id) {
            this.name = name;
            this.id = id;
        }

        public String toString() {
            return this.name + (this.id == -1L ? "" : " (" + this.id + ")");
        }

        public boolean equals(Object o) {
            if (!(o instanceof ThreadPair)) {
                return super.equals(o);
            }
            return ((ThreadPair)o).name.equals(this.name) && ((ThreadPair)o).id == this.id;
        }
    }
}

