/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJStackFrameFormatter;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.AJValueNodeFactory;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.request.BreakpointRequestAction;

public class AJStackFrameNode
extends AJTreeNode {
    protected StackFrame frame = null;
    protected Location originalLocation = null;
    protected AJStackFrameFormatter.MethodAndSource ms = null;
    private String str = "<unititialized frame>";
    ThreadReference thread = null;
    boolean sdb = false;

    public AJStackFrameNode(StackFrame frame) {
        super(AJIcons.STACKFRAME_ICON);
        this.setUserObject(frame);
        this.frame = frame;
        this.originalLocation = frame.location();
        this.ms = AJStackFrameFormatter.format(this.getStackFrame());
        this.str = this.ms + "";
        this.thread = frame.thread();
    }

    public int index() {
        int index = -1;
        try {
            index = ComponentRepository.getAJDebugger().frames(this.frame.thread()).indexOf(this.frame);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public void rightMouseButton(MouseEvent e) {
        JPopupMenu menu = null;
        menu = this.ms.isValid() ? new ShowMenu() : new NoShowMenu();
        menu.show(ComponentRepository.getThreadGroupTreePane().getTree(), e.getX(), e.getY());
    }

    public Value getValue(LocalVariable variable) {
        return this.frame.getValue(variable);
    }

    public Map getValues(List variables) {
        return this.frame.getValues(variables);
    }

    public Location location() {
        return this.frame.location();
    }

    public ObjectReference thisObject() {
        return this.frame.thisObject();
    }

    public ThreadReference thread() {
        return this.frame.thread();
    }

    public LocalVariable visibleVariableByName(String name) throws AbsentInformationException {
        return this.frame.visibleVariableByName(name);
    }

    public List visibleVariables() throws AbsentInformationException {
        return this.frame.visibleVariables();
    }

    public StackFrame getStackFrame() {
        return this.frame;
    }

    public int lineNumber() {
        return this.location().lineNumber();
    }

    public String sourceName() throws AbsentInformationException {
        return this.location().sourceName();
    }

    public Method method() {
        return this.location().method();
    }

    public boolean isStackFrame() {
        return true;
    }

    public boolean isValid() {
        try {
            this.frame.location();
        }
        catch (InvalidStackFrameException ie) {
            return false;
        }
        return true;
    }

    public void showKids() {
        try {
            this.removeAllChildren();
            this.showThisObject();
            this.showLocalVariables();
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
    }

    public void hideKids() {
        this.removeAllChildren();
    }

    private void showLocalVariables() {
        try {
            Iterator iter = this.visibleVariables().iterator();
            while (iter.hasNext()) {
                LocalVariable local = (LocalVariable)iter.next();
                StackFrame frame = this.getStackFrame();
                AJValueNode valueNode = AJValueNodeFactory.make(local, frame);
                this.add(valueNode);
            }
        }
        catch (AbsentInformationException aie) {
        }
        catch (NativeMethodException nativeMethodException) {
            // empty catch block
        }
    }

    private void showThisObject() {
        ObjectReference object = this.frame.thisObject();
        if (object == null) {
            return;
        }
        AJValueNode valueNode = AJValueNodeFactory.make(object, "this");
        this.add(valueNode);
    }

    public String toString() {
        String t = "thread=";
        try {
            t = t + System.identityHashCode(this.frame.thread()) + "";
        }
        catch (Exception e) {
            t = t + "***" + System.identityHashCode(this.thread);
        }
        t = t + ": ";
        return (this.sdb ? this.dd() + t : "") + this.str;
    }

    public int getType() {
        if (this.isValid()) {
            return super.getType();
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getParent();
        if (parent != null) {
            parent.removeAllChildren();
        }
        return AJIcons.INVALID_ICON;
    }

    public Location getOriginalLocation() {
        return this.originalLocation;
    }

    public void setFrame(StackFrame frame) {
        this.frame = frame;
        this.setUserObject(frame);
        this.originalLocation = frame.location();
        this.ms = AJStackFrameFormatter.format(this.getStackFrame());
        this.str = this.ms + "";
        this.thread = frame.thread();
        this.showKids();
    }

    static class NoShowMenu
    extends JPopupMenu {
        NoShowMenu() {
            this.add(new JMenuItem("Source is unavailable"));
        }
    }

    class ShowMenu
    extends JPopupMenu {
        ShowMenu() {
            String s = AJStackFrameNode.this.ms.getFullPath() + ":" + AJStackFrameNode.this.ms.lineNumber;
            JMenuItem item = new JMenuItem("goto " + s);
            item.addActionListener(new ActionListener(this){
                private final /* synthetic */ ShowMenu this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ComponentRepository.getSourcePane().showSourceForFileAndLine(ShowMenu.access$000((ShowMenu)this.this$1).ms.getFullPath(), ShowMenu.access$000((ShowMenu)this.this$1).ms.lineNumber);
                }
            });
            this.add(item);
            Iterator iter = ComponentRepository.getAJDebugger().getBreakpointRequests().iterator();
            String cmd = " " + AJStackFrameNode.this.ms.getProto();
            boolean found = false;
            while (iter.hasNext()) {
                BreakpointRequestAction req = (BreakpointRequestAction)iter.next();
                if (!req.equals(AJStackFrameNode.this.ms)) continue;
                found = true;
                break;
            }
            String msg = (found ? "clear" : "stop on") + cmd;
            item = new JMenuItem(msg);
            item.addActionListener(new ActionListener(this, msg){
                private final /* synthetic */ String val$msg;
                private final /* synthetic */ ShowMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$msg = val$msg;
                }

                public void actionPerformed(ActionEvent e) {
                    ComponentRepository.execute(this.val$msg);
                }
            });
            this.add(item);
        }

        static /* synthetic */ AJStackFrameNode access$000(ShowMenu x0) {
            return x0.AJStackFrameNode.this;
        }
    }
}

