/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import java.io.File;
import org.aspectj.debugger.gui.AJDecParser;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AJStackFrameNode;
import org.aspectj.debugger.gui.AJTranslator;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.tools.ide.Declaration;

public class AJStackFrameFormatter {
    public static final String INVALID = "Invalid Frame";
    public static final String reception = "$reception";
    public static final String execution = "$execution";
    public static final String around = "$around";

    public static MethodAndSource format(StackFrame frame) {
        String path;
        int lineNumber;
        String sourceStr;
        String methodStr;
        block10: {
            methodStr = "";
            sourceStr = "";
            lineNumber = -1;
            path = "";
            try {
                int locLine;
                if (frame == null) {
                    return new MethodAndSource("<BAD FRAME>", "<unknown>", -1, path);
                }
                Location loc = frame.location();
                Method meth = loc.method();
                String decName = meth.declaringType().name();
                String methName = ComponentRepository.getAJDebugger().method(loc);
                int idot = decName.lastIndexOf(46);
                path = idot != -1 ? decName.substring(0, idot).replace('.', File.separatorChar) : "";
                methodStr = decName + "." + methName;
                sourceStr = "";
                lineNumber = locLine = ComponentRepository.getAJDebugger().lineNumber(loc);
                if (meth instanceof Method && meth.isNative()) {
                    sourceStr = sourceStr + "native method";
                    break block10;
                }
                if (locLine == -2) {
                    try {
                        sourceStr = ComponentRepository.getAJDebugger().sourceName(loc);
                    }
                    catch (AbsentInformationException e) {
                        sourceStr = sourceStr + "<unknown>";
                    }
                    break block10;
                }
                if (locLine != -1) {
                    try {
                        sourceStr = ComponentRepository.getAJDebugger().sourceName(loc);
                    }
                    catch (AbsentInformationException e) {
                        sourceStr = sourceStr + "<unknown>";
                    }
                    lineNumber = ComponentRepository.getAJDebugger().lineNumber(loc);
                    break block10;
                }
                sourceStr = sourceStr + "<unknown>";
            }
            catch (InvalidStackFrameException e) {
                methodStr = "<THREAD RESUMED>";
                sourceStr = "<unknown>";
            }
        }
        return new MethodAndSource(methodStr, sourceStr, lineNumber, path);
    }

    static String formatMethod(Method method) {
        String decName = method.declaringType().name();
        String methName = method.name();
        String methString = method + "";
        String ajFile = AJLineMapper.getSourceFilePathFromAJCClass(decName);
        if (ajFile == null) {
            return methName;
        }
        String classMethodString = methString;
        int i2dot = methString.indexOf("(");
        int numDots = 0;
        while (i2dot > -1) {
            if (methString.charAt(i2dot) == '.' && ++numDots == 2) break;
            --i2dot;
        }
        if (i2dot != -1) {
            classMethodString = methString.substring(i2dot + 1);
        }
        int line = AJDecParser.getMethodLineNumber(ajFile, classMethodString);
        int iDollarOne = methName.indexOf("$");
        String baseName = null;
        baseName = iDollarOne != -1 ? methName.substring(0, iDollarOne) : methName;
        String ext = "";
        String name = baseName;
        Declaration dec = AJLineMapper.sm().getDeclarationAtLine(ajFile, line);
        name = AJTranslator.isAdvice(methName) ? AJTranslator.translateWorkingDirMethodName(methName) : (AJTranslator.isReception(methName) ? name + " [reception]" : (dec != null && dec.getKind().equals("method") ? name + " [call]" : (!AJTranslator.isNonMappingMethod(method) ? name + " [body]" : name + " [intermediate call]")));
        return name;
    }

    public static String format(StackFrame frame, int index, boolean showPC) {
        return AJStackFrameFormatter.format(frame, index, showPC, null);
    }

    public static String format(AJStackFrameNode node, boolean showPC) {
        return AJStackFrameFormatter.format(node.getStackFrame(), node.index() + 1, showPC, node.getOriginalLocation());
    }

    private static String format(StackFrame frame, int index, boolean showPC, Location originalLocation) {
        long pc;
        String frameString = "";
        Location loc = null;
        int lineNum = -1;
        String sourceName = "<not available>";
        try {
            loc = frame.location();
            lineNum = loc.lineNumber();
            sourceName = loc.sourceName();
        }
        catch (InvalidStackFrameException e) {
            return "Invalid Frame: " + e.getMessage();
        }
        catch (AbsentInformationException e) {
            // empty catch block
        }
        Method meth = loc.method();
        frameString = frameString + "  [" + index + "] ";
        frameString = frameString + meth;
        frameString = frameString + " (";
        if (meth instanceof Method && meth.isNative()) {
            frameString = frameString + "native method";
        } else {
            frameString = lineNum == 2 ? frameString + "receiving" : frameString + new File(sourceName).getName();
            if (lineNum != -1) {
                frameString = frameString + ':';
                frameString = frameString + lineNum;
            }
        }
        frameString = frameString + ')';
        if (showPC && (pc = loc.codeIndex()) != -1L) {
            frameString = frameString + ", pc = " + pc;
        }
        return frameString;
    }

    public static class MethodAndSource {
        String method;
        String sourceName;
        int lineNumber = -1;
        String path;
        String shortSourceName;

        MethodAndSource(String method, String sourceName, int lineNumber, String path) {
            this.method = method;
            this.sourceName = sourceName;
            this.shortSourceName = this.shortSourceName(sourceName);
            this.lineNumber = lineNumber;
            this.path = path;
        }

        public String getProto() {
            return this.getSourceName() + ":" + this.getLineNumber();
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public boolean isValid() {
            return this.lineNumber > -1;
        }

        public String getFullPath() {
            String pfx = "";
            if (!this.path.equals("") && !this.sourceName.startsWith(this.path)) {
                pfx = this.path + File.separatorChar;
            }
            return pfx + this.sourceName;
        }

        public String toString() {
            return this.method + " (" + this.shortSourceName + (this.isValid() ? ":" + this.lineNumber : "") + ")";
        }

        private String shortSourceName(String sourceName) {
            int ilastSlash = sourceName.lastIndexOf(92);
            int ilastBackSlash = sourceName.lastIndexOf(47);
            int ilastFileSeparator = sourceName.lastIndexOf(File.separatorChar);
            int ilastSep = ilastSlash;
            if (ilastBackSlash > ilastSep) {
                ilastSep = ilastBackSlash;
            }
            if (ilastFileSeparator > ilastSep) {
                ilastSep = ilastFileSeparator;
            }
            if (ilastSep != -1) {
                return sourceName.substring(ilastSep + 1);
            }
            return sourceName;
        }
    }
}

