/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.aspectj.debugger.gui.AJDecParser;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.tools.ide.SourceLine;
import org.aspectj.tools.ide.SymbolManager;

public class AJLineMapper {
    private static HashMap noAJCHash = new HashMap();
    public static final String NO_SOURCE_STRING = "<not-available>";
    public static final String NON_MAPPING_SOURCE_STRING = "<non-mapping-source>";
    public static final String UNKNOWN_SOURCE_STRING = "<unknown>";
    public static final int NO_SOURCE_LINE = -1;
    public static final int NON_MAPPING_SOURCE_LINE = -2;
    public static SymbolManager symbolManager = new SymbolManager();

    public boolean hasBody() {
        return true;
    }

    public static SymbolManager sm() {
        return symbolManager;
    }

    public static int getCorrespondingOutputLineNo(String classID, int line) {
        return AJLineMapper.getCorrespondingOutputLine((String)classID, (int)line).line;
    }

    public static SourceLine getCorrespondingOutputLine(String classID, int line) {
        String filePath = AJLineMapper.getSourceFilePathFromAJCClass(classID);
        return AJLineMapper.getCorrespondingOutputLineFromFullSource(filePath, line);
    }

    public static SourceLine getCorrespondingOutputLineFromSource(String source, int line) {
        String filePath = AJLineMapper.getFullFileNameFromFile(source, false);
        return AJLineMapper.getCorrespondingOutputLineFromFullSource(filePath, line);
    }

    static SourceLine getCorrespondingOutputLineFromFullSource(String filePath, int line) {
        if (filePath == null) {
            return AJLineMapper.unknownFileSourceLine(line);
        }
        int lineNo = -1;
        String newFile = UNKNOWN_SOURCE_STRING;
        SourceLine sl = null;
        ++line;
        while (--line >= 0 && lineNo == -1) {
            sl = symbolManager.mapToOutputLine(filePath, line);
            if (sl == null) continue;
            lineNo = sl.line;
            newFile = sl.filename;
        }
        if (lineNo == -1) {
            return AJLineMapper.nonMappingSourceLine();
        }
        return new SourceLine(newFile, lineNo + 1);
    }

    public static String translateGeneratedMethodName(String methodName) {
        String sigToken = "$signature";
        String memberToken = "$member";
        String staticMemberToken = "$static$member";
        String adviceToken = "$reception";
        String aroundToken = "$around$reception";
        int sigTokenStart = methodName.indexOf(sigToken);
        int memberTokenStart = methodName.indexOf(memberToken);
        int staticMemberTokenStart = methodName.indexOf(staticMemberToken);
        int adviceTokenStart = methodName.indexOf(adviceToken);
        int aroundTokenStart = methodName.indexOf(aroundToken);
        int indexNameStart = methodName.lastIndexOf("$");
        if (sigTokenStart > -1 && indexNameStart > -1) {
            return methodName.substring(methodName.indexOf("$") + 1, sigTokenStart);
        }
        if (staticMemberTokenStart > -1 && indexNameStart > -1) {
            return methodName.substring(methodName.indexOf("$") + 1, staticMemberTokenStart);
        }
        if (memberTokenStart > -1 && indexNameStart > -1) {
            return methodName.substring(methodName.indexOf("$") + 1, memberTokenStart);
        }
        if (adviceTokenStart > -1 && indexNameStart > -1) {
            String adviceNumber = methodName.substring(adviceTokenStart + adviceToken.length());
            return "<advice #" + adviceNumber + ">";
        }
        if (aroundTokenStart > -1 && indexNameStart > -1) {
            String adviceNumber = methodName.substring(aroundTokenStart + aroundToken.length());
            return "<advice #" + adviceNumber + ">";
        }
        return methodName;
    }

    public static String getCorrespondingFile(Location loc) {
        String filename = "";
        String qualifiedName = null;
        try {
            String locName = loc.declaringType().name();
            String sourceName = loc.declaringType().sourceName();
            String strippedSourceName = sourceName.substring(0, sourceName.indexOf(".java"));
            String packageName = locName.substring(0, locName.indexOf(strippedSourceName));
            qualifiedName = packageName + strippedSourceName;
            filename = AJLineMapper.getFileNameFromQualified(qualifiedName, true);
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return filename;
    }

    public static String getSourceFilePathFromAJCClass(String classID) {
        if (noAJCHash.get(classID) != null) {
            return null;
        }
        String ajFile = AJLineMapper.getFileNameFromQualified(classID, true);
        SourceLine sourceLine = null;
        String filePath = null;
        if (new File(ajFile).exists()) {
            int i = 0;
            while (i < 1000 && sourceLine == null) {
                sourceLine = symbolManager.mapToSourceLine(ajFile, i);
                if (sourceLine != null) {
                    filePath = sourceLine.filename;
                }
                ++i;
            }
        } else {
            noAJCHash.put(classID, classID);
            return null;
        }
        return filePath;
    }

    public static SourceLine getCorrespondingLine(Location loc) {
        SourceLine ajline = null;
        String qualifiedName = null;
        try {
            qualifiedName = AJLineMapper.getQualifiedNameForSource(loc);
            int locLineNumber = loc.lineNumber();
            ajline = AJLineMapper.getCorrespondingLine(qualifiedName, locLineNumber);
            if (ajline != null && ajline.line == -2) {
                String ajFile;
                String classMethodString = loc.method() + "";
                classMethodString = classMethodString.substring(0, classMethodString.indexOf(")") + 1);
                int i2dot = classMethodString.indexOf("(");
                int numDots = 0;
                while (i2dot > -1) {
                    if (classMethodString.charAt(i2dot) == '.' && ++numDots == 2) break;
                    --i2dot;
                }
                if (i2dot != -1) {
                    classMethodString = classMethodString.substring(i2dot + 1);
                }
                if ((ajFile = AJLineMapper.getSourceFilePathFromAJCClass(loc.declaringType().name())) != null) {
                    int line = AJDecParser.getMethodLineNumber(ajFile, classMethodString);
                    ajline = new SourceLine(ajFile, line);
                } else {
                    ajline = new SourceLine(loc.sourceName(), loc.lineNumber());
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return ajline == null ? AJLineMapper.emptySourceLine() : ajline;
    }

    public static boolean isUnknownSource(String source) {
        return source.equals(UNKNOWN_SOURCE_STRING);
    }

    static String getQualifiedNameForSource(Location loc) throws AbsentInformationException {
        ReferenceType refType = loc.declaringType();
        if (refType == null) {
            throw new AbsentInformationException();
        }
        String locName = refType.name();
        String sourceName = loc.sourceName();
        String strippedSourceName = sourceName.substring(0, sourceName.indexOf(".java"));
        int lastDot = locName.lastIndexOf(46);
        String packageName = "";
        if (lastDot != -1) {
            packageName = locName.substring(0, lastDot + 1);
        }
        String qualifiedName = packageName + strippedSourceName;
        return qualifiedName;
    }

    private static SourceLine emptySourceLine() {
        return new SourceLine(NO_SOURCE_STRING, -1);
    }

    private static SourceLine nonMappingSourceLine() {
        return new SourceLine(NON_MAPPING_SOURCE_STRING, -2);
    }

    private static SourceLine unknownFileSourceLine(int line) {
        return new SourceLine(UNKNOWN_SOURCE_STRING, line);
    }

    public static SourceLine getCorrespondLineFromFullSource(String filePath, int line) {
        SourceLine newLine = null;
        if (new File(filePath).exists()) {
            int offsetLine = -1;
            try {
                offsetLine = line - 1;
                newLine = symbolManager.mapToSourceLine(new File(filePath).getCanonicalPath(), offsetLine);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (newLine == null) {
                return AJLineMapper.nonMappingSourceLine();
            }
            return newLine;
        }
        return new SourceLine(UNKNOWN_SOURCE_STRING, line);
    }

    public static SourceLine getCorrespondingLine(String qualifiedName, int line) {
        String filePath = AJLineMapper.getFileNameFromQualified(qualifiedName, true);
        return AJLineMapper.getCorrespondLineFromFullSource(filePath, line);
    }

    public static SourceLine getCorrespondingLineFromSource(String sourceName, int line) {
        String filePath = AJLineMapper.insertWorkingDir(sourceName);
        return AJLineMapper.getCorrespondLineFromFullSource(filePath, line);
    }

    static String getFileNameFromQualified(String qualifiedName, boolean inAJWorkingDir) {
        String qualifiedNameNoDollars = AJLineMapper.stripDollarsFrom(qualifiedName);
        String offset = ComponentRepository.getSourcePane().getSourcePath() + "";
        if (inAJWorkingDir) {
            offset = offset + "/ajworkingdir";
        }
        String sourcePath = new File(offset).getAbsolutePath();
        String filename = qualifiedNameNoDollars.replace('.', File.separatorChar) + ".java";
        return sourcePath + File.separator + filename;
    }

    static String getFullFileNameFromFile(String fullName, boolean inAJWorkingDir) {
        String offset = ComponentRepository.getSourcePane().getSourcePath() + "";
        if (inAJWorkingDir) {
            offset = offset + "/ajworkingdir";
        }
        String sourcePath = new File(offset).getAbsolutePath();
        if (fullName.indexOf(offset) == -1) {
            return new File(sourcePath + File.separator + fullName).getAbsolutePath();
        }
        return new File(fullName).getAbsolutePath();
    }

    static String getFullFileNameFromLocation(Location loc, boolean inAJWorkingDir) throws AbsentInformationException {
        String offset = ComponentRepository.getSourcePane().getSourcePath() + "";
        if (inAJWorkingDir) {
            offset = offset + "/ajworkingdir";
        }
        String fullName = loc.declaringType().name();
        String srcName = loc.sourceName();
        String pkg = "";
        int iDot = fullName.lastIndexOf(".");
        if (iDot != -1) {
            pkg = fullName.substring(0, iDot);
            pkg = pkg.replace('.', File.separatorChar);
        }
        String srcPath = pkg + File.separator + srcName;
        String sourcePath = new File(offset).getAbsolutePath();
        if (srcPath.indexOf(offset) == -1) {
            return new File(sourcePath + File.separator + srcPath).getAbsolutePath();
        }
        return new File(srcPath).getAbsolutePath();
    }

    static String removeRootAndAJWorkingDir(String fullPath) {
        String offset = ComponentRepository.getSourcePane().getSourcePath() + File.separator + "ajworkingdir" + File.separator;
        int index = offset.length();
        if (!fullPath.startsWith(offset)) {
            return fullPath;
        }
        String returnString = fullPath.substring(index);
        return returnString;
    }

    static String removeRoot(String fullPath) {
        String offset = "";
        String path = ComponentRepository.getSourcePane().getSourcePath() + "";
        File file = new File(path = path + File.separator + "ajworkingdir" + File.separator);
        offset = file.getAbsolutePath();
        if (fullPath.startsWith(offset)) {
            int index = offset.length();
            return fullPath.substring(index + 1);
        }
        offset = "";
        file = new File(ComponentRepository.getSourcePane().getSourcePath() + "");
        offset = file.getAbsolutePath();
        if (fullPath.startsWith(offset)) {
            int index = offset.length();
            return fullPath.substring(index + 1);
        }
        return fullPath;
    }

    static String stripDollarsFrom(String str) {
        int index = str.indexOf("$");
        if (index != -1) {
            return str.substring(0, index);
        }
        return str;
    }

    static String insertWorkingDir(String fullPath) {
        String path = ComponentRepository.getSourcePane().getSourcePath() + "";
        if (fullPath.indexOf("ajworkingdir") != -1) {
            return fullPath;
        }
        int ipath = fullPath.indexOf(path);
        if (ipath == -1) {
            return AJLineMapper.getFullFileNameFromFile(fullPath, true);
        }
        String rest = fullPath.substring(ipath + path.length() + 1);
        return path + File.separator + "ajworkingdir" + File.separator + rest;
    }
}

