/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.net.URL;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.aspectj.debugger.base.ErrorLogger;
import org.aspectj.debugger.base.Modes;
import org.aspectj.debugger.gui.ABOUT_ICON;
import org.aspectj.debugger.gui.ADVICE_ICON;
import org.aspectj.debugger.gui.AJIconsTest;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.ARRAY_ICON;
import org.aspectj.debugger.gui.ASPECT_ICON;
import org.aspectj.debugger.gui.BAD_ICON;
import org.aspectj.debugger.gui.BLANK_ICON;
import org.aspectj.debugger.gui.BOOLEAN_ICON;
import org.aspectj.debugger.gui.BYTE_ICON;
import org.aspectj.debugger.gui.CATCH_ICON;
import org.aspectj.debugger.gui.CHAR_ICON;
import org.aspectj.debugger.gui.CLASS_ICON;
import org.aspectj.debugger.gui.CLEAR_ICON;
import org.aspectj.debugger.gui.CONT_ICON;
import org.aspectj.debugger.gui.DEFAULT_ICON;
import org.aspectj.debugger.gui.DISCONNECT_ICON;
import org.aspectj.debugger.gui.DOCUMENT_ICON;
import org.aspectj.debugger.gui.DOUBLE_ICON;
import org.aspectj.debugger.gui.DUMP_ICON;
import org.aspectj.debugger.gui.EVALUATE_ICON;
import org.aspectj.debugger.gui.EXECUTABLE_ICON;
import org.aspectj.debugger.gui.FIELDS_ICON;
import org.aspectj.debugger.gui.FLOAT_ICON;
import org.aspectj.debugger.gui.FOLDER_ICON;
import org.aspectj.debugger.gui.HELP_ICON;
import org.aspectj.debugger.gui.INTEGER_ICON;
import org.aspectj.debugger.gui.INTERFACE_ICON;
import org.aspectj.debugger.gui.INVALID_ICON;
import org.aspectj.debugger.gui.LOCALS_ICON;
import org.aspectj.debugger.gui.LOCAL_VARIABLE_ICON;
import org.aspectj.debugger.gui.LONG_ICON;
import org.aspectj.debugger.gui.METHOD_ICON;
import org.aspectj.debugger.gui.NEXT_ICON;
import org.aspectj.debugger.gui.NULL_OBJECT_ICON;
import org.aspectj.debugger.gui.OBJECT_ICON;
import org.aspectj.debugger.gui.PACKAGE_ICON;
import org.aspectj.debugger.gui.PRINT_ICON;
import org.aspectj.debugger.gui.QUIT_ICON;
import org.aspectj.debugger.gui.RESUME_ICON;
import org.aspectj.debugger.gui.ROOT_ICON;
import org.aspectj.debugger.gui.RUN_ICON;
import org.aspectj.debugger.gui.SHORT_ICON;
import org.aspectj.debugger.gui.STACKFRAME_ICON;
import org.aspectj.debugger.gui.STEPI_ICON;
import org.aspectj.debugger.gui.STEPUP_ICON;
import org.aspectj.debugger.gui.STEP_ICON;
import org.aspectj.debugger.gui.STOP_ICON;
import org.aspectj.debugger.gui.SUSPEND_ICON;
import org.aspectj.debugger.gui.THREADGROUP_ICON;
import org.aspectj.debugger.gui.THREAD_BREAKPOINT_ICON;
import org.aspectj.debugger.gui.THREAD_ICON;
import org.aspectj.debugger.gui.THREAD_RUNNING_ICON;
import org.aspectj.debugger.gui.THREAD_SUSPENDED_ICON;
import org.aspectj.debugger.gui.UNVERIFIED_BREAKPOINT_ICON;
import org.aspectj.debugger.gui.USE_ICON;
import org.aspectj.debugger.gui.VERIFIED_BREAKPOINT_ICON;
import org.aspectj.debugger.gui.WHERE_ICON;

public class AJIcons {
    private static int count = 0;
    public static final int BAD_ICON = count++;
    public static final int DEFAULT_ICON = count++;
    public static final int THREAD_ICON = count++;
    public static final int THREADGROUP_ICON = count++;
    public static final int ROOT_ICON = count++;
    public static final int STACKFRAME_ICON = count++;
    public static final int THREAD_BREAKPOINT_ICON = count++;
    public static final int THREAD_SUSPENDED_ICON = count++;
    public static final int THREAD_RUNNING_ICON = count++;
    public static final int INVALID_ICON = count++;
    public static final int LOCAL_VARIABLE_ICON = count++;
    public static final int BOOLEAN_ICON = count++;
    public static final int BYTE_ICON = count++;
    public static final int CHAR_ICON = count++;
    public static final int DOUBLE_ICON = count++;
    public static final int FLOAT_ICON = count++;
    public static final int INTEGER_ICON = count++;
    public static final int LONG_ICON = count++;
    public static final int OBJECT_ICON = count++;
    public static final int SHORT_ICON = count++;
    public static final int ARRAY_ICON = count++;
    public static final int EXECUTABLE_ICON = count++;
    public static final int VERIFIED_BREAKPOINT_ICON = count++;
    public static final int UNVERIFIED_BREAKPOINT_ICON = count++;
    public static final int NULL_OBJECT_ICON = count++;
    public static final int DOCUMENT_ICON = count++;
    public static final int FOLDER_ICON = count++;
    public static final int STOP_ICON = count++;
    public static final int CONT_ICON = count++;
    public static final int SUSPEND_ICON = count++;
    public static final int RESUME_ICON = count++;
    public static final int NEXT_ICON = count++;
    public static final int STEPI_ICON = count++;
    public static final int STEPUP_ICON = count++;
    public static final int STEP_ICON = count++;
    public static final int QUIT_ICON = count++;
    public static final int RUN_ICON = count++;
    public static final int PACKAGE_ICON = count++;
    public static final int BLANK_ICON = count++;
    public static final int ADVICE_ICON = count++;
    public static final int ASPECT_ICON = count++;
    public static final int WHERE_ICON = count++;
    public static final int HELP_ICON = count++;
    public static final int ABOUT_ICON = count++;
    public static final int PRINT_ICON = count++;
    public static final int FIELDS_ICON = count++;
    public static final int DUMP_ICON = count++;
    public static final int EVALUATE_ICON = count++;
    public static final int LOCALS_ICON = count++;
    public static final int USE_ICON = count++;
    public static final int CLEAR_ICON = count++;
    public static final int DISCONNECT_ICON = count++;
    public static final int METHOD_ICON = count++;
    public static final int METHOD_PUBLIC_ICON = count++;
    public static final int METHOD_PACKAGE_ICON = count++;
    public static final int METHOD_PROTECTED_ICON = count++;
    public static final int METHOD_PRIVATE_ICON = count++;
    public static final int METHOD_STATIC_PUBLIC_ICON = count++;
    public static final int METHOD_STATIC_PACKAGE_ICON = count++;
    public static final int METHOD_STATIC_PROTECTED_ICON = count++;
    public static final int METHOD_STATIC_PRIVATE_ICON = count++;
    public static final int INTERFACE_ICON = count++;
    public static final int INTERFACE_PUBLIC_ICON = count++;
    public static final int INTERFACE_PACKAGE_ICON = count++;
    public static final int INTERFACE_PROTECTED_ICON = count++;
    public static final int INTERFACE_PRIVATE_ICON = count++;
    public static final int INTERFACE_STATIC_PUBLIC_ICON = count++;
    public static final int INTERFACE_STATIC_PACKAGE_ICON = count++;
    public static final int INTERFACE_STATIC_PROTECTED_ICON = count++;
    public static final int INTERFACE_STATIC_PRIVATE_ICON = count++;
    public static final int CLASS_ICON = count++;
    public static final int CLASS_PUBLIC_ICON = count++;
    public static final int CLASS_PACKAGE_ICON = count++;
    public static final int CLASS_PROTECTED_ICON = count++;
    public static final int CLASS_PRIVATE_ICON = count++;
    public static final int CLASS_STATIC_PUBLIC_ICON = count++;
    public static final int CLASS_STATIC_PACKAGE_ICON = count++;
    public static final int CLASS_STATIC_PROTECTED_ICON = count++;
    public static final int CLASS_STATIC_PRIVATE_ICON = count++;
    public static final int FIELD_ICON = count++;
    public static final int FIELD_PUBLIC_ICON = count++;
    public static final int FIELD_PACKAGE_ICON = count++;
    public static final int FIELD_PROTECTED_ICON = count++;
    public static final int FIELD_PRIVATE_ICON = count++;
    public static final int FIELD_STATIC_PUBLIC_ICON = count++;
    public static final int FIELD_STATIC_PACKAGE_ICON = count++;
    public static final int FIELD_STATIC_PROTECTED_ICON = count++;
    public static final int FIELD_STATIC_PRIVATE_ICON = count++;
    public static final int CTR_ICON = count++;
    public static final int CTR_PUBLIC_ICON = count++;
    public static final int CTR_PACKAGE_ICON = count++;
    public static final int CTR_PROTECTED_ICON = count++;
    public static final int CTR_PRIVATE_ICON = count++;
    public static final int CTR_STATIC_PUBLIC_ICON = count++;
    public static final int CTR_STATIC_PACKAGE_ICON = count++;
    public static final int CTR_STATIC_PROTECTED_ICON = count++;
    public static final int CTR_STATIC_PRIVATE_ICON = count++;
    public static final int BREAKPOINTS_ICON = count++;
    public static final int MAIN_ICON = count++;
    public static final int THREADS_ICON = count++;
    public static final int WATCHES_ICON = count++;
    public static final int WATCH_ICON = count++;
    public static final int CATCH_ICON = count++;
    public static final int WATCHVAR_ICON = count++;
    public static final int INITIALIZER_ICON = count++;
    public static final int VARIABLES_ICON = count++;
    public static final int CLASSES_ICON = count++;
    public static final int OUTPUT_ICON = count++;
    public static final int NUM_ICONS = count;
    private static String mode = "unset";
    private static Icon[] icons = null;
    public static final String FORTE_CLASS = "src/class.gif";
    public static final String FORTE_INTERFACE = "src/interface.gif";
    public static final String FORTE_VARIABLE_PUBLIC = "src/variablePublic.gif";
    public static final String FORTE_VARIABLE_PRIVATE = "src/variablePrivate.gif";
    public static final String FORTE_VARIABLE_PACKAGE = "src/variablePackage.gif";
    public static final String FORTE_VARIABLE_PROTECTED = "src/variableProtected.gif";
    public static final String FORTE_METHOD_PRIVATE = "src/methodPrivate.gif";
    public static final String FORTE_METHOD_PACKAGE = "src/methodPackage.gif";
    public static final String FORTE_METHOD_PROTECTED = "src/methodProtected.gif";
    public static final String FORTE_METHOD_PUBLIC = "src/methodPublic.gif";
    public static final String FORTE_ERROR = "src/error.gif";
    public static final String FORTE_HISTORY = "html/history.gif";
    public static final String FORTE_TRACE_INFO = "actions/traceInto.gif";
    public static final String FORTE_REFRESH = "html/refresh.gif";
    public static final String FORTE_JAR_FS = "jarFS.gif";
    public static final String FORTE_DEFAULT_NODE = "defaultNode.gif";
    public static final String FORTE_DEFAULT_FOLDER = "defaultFolder.gif";
    public static final String FORTE_LOCALS_FS = "localFS.gif";
    public static final String FORTE_FOLDER = "defaultFolder.gif";
    public static final String FORTE_STOP = "actions/addBreakpoint.gif";
    public static final String FORTE_RUN = "actions/startDebugger.gif";
    public static final String FORTE_QUIT = "actions/finishDebugger.gif";
    public static final String FORTE_HELP = "actions/showHelp.gif";
    public static final String FORTE_TOGGLE_BREAKPOINT = "actions/toggleBreakpoint.gif";
    public static final String FORTE_STEPOUT = "actions/stepOut.gif";
    public static final String FORTE_STEP = "actions/traceInto.gif";
    public static final String FORTE_NEXT = "actions/traceOver.gif";
    public static final String FORTE_INITIALIZER = "src/initializer.gif";
    public static final String FORTE_CTR_PRIVATE = "src/constructorPrivate.gif";
    public static final String FORTE_CTR_PACKAGE = "src/constructorPackage.gif";
    public static final String FORTE_CTR_PROTECTED = "src/constructorProtected.gif";
    public static final String FORTE_CTR_PUBLIC = "src/constructorPublic.gif";
    public static final String FORTE_CTRS = "src/constructors.gif";
    public static final String FORTE_METHODS = "src/methods.gif";
    public static final String FORTE_VARIABLES = "src/variables.gif";
    public static final String FORTE_WHERE = "actions/goToCursor.gif";
    public static final String FORTE_CLEAR = "actions/cut.gif";
    public static final String FORTE_RESUME = "resume.gif";
    public static final String FORTE_DISCONNECT = "actions/delete.gif";
    public static final String FORTE_STEPI = "actions/goToCursor.gif";
    public static final String FORTE_CONT = "actions/go.gif";
    public static final String FORTE_FIELDS = "src/variables.gif";
    public static final String FORTE_BAD = "src/error.gif";
    public static final String FORTE_USE = "actions/undock.gif";
    public static final String FORTE_PRINT = "actions/print.gif";
    public static final String FORTE_DUMP = "actions/find.gif";
    public static final String FORTE_DEFAULT = "actions/empty.gif";
    public static final String FORTE_PACKAGE = "defaultFolderOpen.gif";
    public static final String FORTE_ADDWATCH = "actions/addWatch.gif";
    public static final String FORTE_BREAKPOINTS = "breakpoints.gif";
    public static final String FORTE_BREAKPOINT = "breakpoint.gif";
    public static final String FORTE_MAIN = "actions/debuggerView.gif";
    public static final String FORTE_THREADS = "threads.gif";
    public static final String FORTE_THREADGROUP = "threadGroup.gif";
    public static final String FORTE_THREADGROUP_CURRENT = "threadGroupCurrent.gif";
    public static final String FORTE_THREAD_SUSPENDED = "threadSuspended.gif";
    public static final String FORTE_THREAD_CURRENT = "threadCurrent.gif";
    public static final String FORTE_THREAD_RUNNING = "threadRunning.gif";
    public static final String FORTE_VARIABLE = "variable.gif";
    public static final String FORTE_WATCHES = "watches.gif";
    public static final String FORTE_CALLSTACK = "callstack.gif";
    public static final String FORTE_WATCH = "watch.gif";
    public static final String FORTE_SUSPEND = "actions/suspend.gif";
    public static final String FORTE_OUTPUT = "frames/output.gif";
    public static final String FORTE_CONFIG = "org/openide/resources/";
    public static final String FORTE_CORE = "org/netbeans/core/resources/";
    public static final String FORTE_DEBUGGER = "org/netbeans/modules/debugger/resources/";
    static final String JAVA_STRUCTURE_ICONS = "com.borland.jbuilder.node.java.JavaStructureIcons";
    static final String JB_ICONS_INTERFACE = "ICONS_INTERFACE";
    static final String JB_ICONS_CLASS = "ICONS_CLASS";
    static final String JB_ICONS_CTR = "ICONS_CONSTRUCTOR";
    static final String JB_ICONS_FIELD = "ICONS_FIELD";
    static final String JB_ICONS_METHOD = "ICONS_METHOD";
    static final String JB_PRIVATE = "PRIVATE";
    static final String JB_PACKAGE = "PACKAGE";
    static final String JB_PROTECTED = "PROTECTED";
    static final String JB_PUBLIC = "PUBLIC";
    static final String JB_STATIC = "STATIC";
    public static final String JB_CONFIG = "com/borland/jbuilder/";
    public static final String JB_BROWSER_ICONS = "com.borland.primetime.ide.BrowserIcons";
    static final String JB_THREADUSERSUSPENDED = "THREADUSERSUSPENDED";
    static final String JB_THREADBREAKUSERSUSPENDED = "THREADBREAKUSERSUSPENDED";
    static final String JB_THREADBREAKBLOCKED = "THREADBREAKBLOCKED";
    static final String JB_CLASS = "CLASS";
    static final String JB_ERROR = "ERROR";
    static final String JB_SHOWFRAME = "SHOWFRAME";
    static final String JB_BREAKPOINTDISABLED = "BREAKPOINTDISABLED";
    static final String JB_BREAKPOINTINVALID = "BREAKPOINTINVALID";
    static final String JB_BREAKPOINTVERIFIED = "BREAKPOINTVERIFIED";
    static final String JB_BREAKPOINT = "BREAKPOINT";
    static final String JB_THREADBREAK = "THREADBREAK";
    static final String JB_WARNING = "WARNING";
    static final String JB_THREADDEAD = "THREADDEAD";
    static final String JB_THREADBLOCKED = "THREADBLOCKED";
    static final String JB_THREADSUSPENDED = "THREADSUSPENDED";
    static final String JB_CONSOLE = "CONSOLE";
    static final String JB_PRIMITIVE = "PRIMITIVE";
    static final String JB_THREADGROUP = "THREADGROUP";
    static final String JB_NULL = "NULL";
    static final String JB_VIEWLOADEDCLASSES = "VIEWLOADEDCLASSES";
    static final String JB_VIEWBREAKPOINTS = "VIEWBREAKPOINTS";
    static final String JB_ADDBREAKPOINT = "ADDBREAKPOINT";
    static final String JB_THREAD = "THREAD";
    static final String JB_WATCH = "WATCH";
    static final String JB_ARRAY = "ARRAY";
    static final String JB_ADDWATCH = "ADDWATCH";
    static final String JB_ADDBREAK = "ADDBREAK";
    static final String JB_STEPOUT = "STEPOUT";
    static final String JB_STEPOVER = "STEPOVER";
    static final String JB_STEPINTO = "STEPINTO";
    static final String JB_PROGRAMPAUSE = "PROGRAMPAUSE";
    static final String JB_PROGRAMRUN = "PROGRAMRUN";
    static final String JB_PROGRAMSTOP = "PROGRAMSTOP";
    static final String JB_PROGRAMRESUME = "PROGRAMRESUME";
    static final String JB_SHOWEXECPOINT = "SHOWEXECPOINT";
    public static Icon NO_ICON;

    public static void init() {
        AJIcons.init(Modes.getMode());
    }

    private static void init(String _mode) {
        mode = _mode;
        if (icons != null) {
            return;
        }
        icons = new Icon[NUM_ICONS];
        try {
            if (mode.equals("gui")) {
                AJIcons.createStandAloneIcons();
                AJIcons.validateIcons();
                return;
            }
            if (mode.equals("jbuilder3")) {
                AJIcons.createJBuilder3Icons();
                AJIcons.validateIcons();
                return;
            }
            if (mode.equals("jbuilder4")) {
                AJIcons.createJBuilder4Icons();
                AJIcons.validateIcons();
                return;
            }
            if (mode.equals("forte")) {
                AJIcons.createForteIcons();
                AJIcons.validateIcons();
                return;
            }
        }
        catch (Exception e) {
            AJIcons.error(e);
            return;
        }
        throw new RuntimeException("Invalid icon mode: " + mode);
    }

    private static void error(Throwable t) {
        new ErrorLogger().log(t);
        t.printStackTrace();
    }

    private static boolean validateIcons() throws Exception {
        if (icons == null) {
            throw new RuntimeException("icons are null");
        }
        if (icons.length != NUM_ICONS) {
            throw new RuntimeException("icons.length != NUM_ICONS");
        }
        Vector<Integer> nulls = new Vector<Integer>();
        int i = 0;
        while (i < icons.length) {
            if (AJIcons.getIcon(i) == null) {
                nulls.add(new Integer(i));
            }
            ++i;
        }
        if (nulls.size() > 1) {
            throw new RuntimeException("These icons are null: " + nulls + " of " + NUM_ICONS + " icons.");
        }
        return true;
    }

    private static Icon getIcon(String prefix, String string, String jar) {
        String iconString = prefix + string;
        URL url = ClassLoader.getSystemResource(iconString);
        if (url == null) {
            AJIcons.error(new RuntimeException("image " + iconString + " usually found in " + jar + " is null!"));
        }
        return new ImageIcon(url);
    }

    private static Icon fi(String s) {
        return AJIcons.getIcon(FORTE_CONFIG, s, "lib/openide.jar");
    }

    private static Icon cfi(String s) {
        return AJIcons.getIcon(FORTE_CORE, s, "lib/developer.jar (for Forte) OR lib/core.jar (for Netbeans)");
    }

    private static Icon dfi(String s) {
        return AJIcons.getIcon_(FORTE_DEBUGGER, s, "modules/debuggerCore.jar");
    }

    private static Icon getIcon_(String prefix, String string, String jar) {
        String iconString = prefix + string;
        URL url = null;
        try {
            Class<?> type = Class.forName("org.openide.TopManager");
            url = ((ClassLoader)type.getMethod("currentClassLoader", new Class[0]).invoke(type.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]), new Object[0])).getResource(iconString);
        }
        catch (Throwable t) {
            AJIcons.error(t);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(iconString);
        }
        if (url == null) {
            AJIcons.error(new RuntimeException("image " + iconString + " usually found in " + jar + " is null!"));
        }
        return new ImageIcon(url);
    }

    private static void createForteIcons() throws Exception {
        AJIcons.createStandAloneIcons();
        try {
            AJIcons.createActualForteIcons();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Please include the Forte jar");
        }
    }

    private static void createActualForteIcons() throws ClassNotFoundException {
        try {
            AJIcons.icons[AJIcons.INTERFACE_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_PUBLIC_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_PACKAGE_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_PROTECTED_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_PRIVATE_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_STATIC_PUBLIC_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_STATIC_PACKAGE_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_STATIC_PROTECTED_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INTERFACE_STATIC_PRIVATE_ICON] = AJIcons.fi(FORTE_INTERFACE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_PUBLIC_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_PACKAGE_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_PROTECTED_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_PRIVATE_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_STATIC_PUBLIC_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_STATIC_PACKAGE_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_STATIC_PROTECTED_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASS_STATIC_PRIVATE_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLASSES_ICON] = AJIcons.fi(FORTE_CLASS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_ICON] = AJIcons.fi(FORTE_METHOD_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_PUBLIC_ICON] = AJIcons.fi(FORTE_METHOD_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_PACKAGE_ICON] = AJIcons.fi(FORTE_METHOD_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_PROTECTED_ICON] = AJIcons.fi(FORTE_METHOD_PROTECTED);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_PRIVATE_ICON] = AJIcons.fi(FORTE_METHOD_PRIVATE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_STATIC_PUBLIC_ICON] = AJIcons.fi(FORTE_METHOD_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_STATIC_PACKAGE_ICON] = AJIcons.fi(FORTE_METHOD_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_STATIC_PROTECTED_ICON] = AJIcons.fi(FORTE_METHOD_PROTECTED);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.METHOD_STATIC_PRIVATE_ICON] = AJIcons.fi(FORTE_METHOD_PRIVATE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_ICON] = AJIcons.fi(FORTE_VARIABLE_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_PUBLIC_ICON] = AJIcons.fi(FORTE_VARIABLE_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_PACKAGE_ICON] = AJIcons.fi(FORTE_VARIABLE_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_PROTECTED_ICON] = AJIcons.fi(FORTE_VARIABLE_PROTECTED);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_PRIVATE_ICON] = AJIcons.fi(FORTE_VARIABLE_PRIVATE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_STATIC_PUBLIC_ICON] = AJIcons.fi(FORTE_VARIABLE_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_STATIC_PACKAGE_ICON] = AJIcons.fi(FORTE_VARIABLE_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_STATIC_PROTECTED_ICON] = AJIcons.fi(FORTE_VARIABLE_PROTECTED);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_STATIC_PRIVATE_ICON] = AJIcons.fi(FORTE_VARIABLE_PRIVATE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_ICON] = AJIcons.fi(FORTE_CTR_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_PUBLIC_ICON] = AJIcons.fi(FORTE_CTR_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_PACKAGE_ICON] = AJIcons.fi(FORTE_CTR_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_PROTECTED_ICON] = AJIcons.fi(FORTE_CTR_PROTECTED);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_PRIVATE_ICON] = AJIcons.fi(FORTE_CTR_PRIVATE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_STATIC_PUBLIC_ICON] = AJIcons.fi(FORTE_CTR_PUBLIC);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_STATIC_PACKAGE_ICON] = AJIcons.fi(FORTE_CTR_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_STATIC_PROTECTED_ICON] = AJIcons.fi(FORTE_CTR_PROTECTED);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CTR_STATIC_PRIVATE_ICON] = AJIcons.fi(FORTE_CTR_PRIVATE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FOLDER_ICON] = AJIcons.fi("defaultFolder.gif");
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.STOP_ICON] = AJIcons.fi(FORTE_STOP);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.RUN_ICON] = AJIcons.fi(FORTE_RUN);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.QUIT_ICON] = AJIcons.fi(FORTE_QUIT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.HELP_ICON] = AJIcons.fi(FORTE_HELP);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.STEPUP_ICON] = AJIcons.fi(FORTE_STEPOUT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.SUSPEND_ICON] = AJIcons.fi(FORTE_SUSPEND);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.STEP_ICON] = AJIcons.fi("actions/traceInto.gif");
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.NEXT_ICON] = AJIcons.fi(FORTE_NEXT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.INITIALIZER_ICON] = AJIcons.fi(FORTE_INITIALIZER);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.WHERE_ICON] = AJIcons.fi("actions/goToCursor.gif");
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CLEAR_ICON] = AJIcons.fi(FORTE_CLEAR);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.RESUME_ICON] = AJIcons.dfi(FORTE_RESUME);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.DISCONNECT_ICON] = AJIcons.fi(FORTE_DISCONNECT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.STEPI_ICON] = AJIcons.fi("actions/goToCursor.gif");
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.CONT_ICON] = AJIcons.fi(FORTE_CONT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELDS_ICON] = AJIcons.fi("src/variables.gif");
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.BAD_ICON] = AJIcons.fi("src/error.gif");
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.USE_ICON] = AJIcons.fi(FORTE_USE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.PRINT_ICON] = AJIcons.fi(FORTE_PRINT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.DUMP_ICON] = AJIcons.fi(FORTE_DUMP);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.DEFAULT_ICON] = AJIcons.fi(FORTE_DEFAULT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.PACKAGE_ICON] = AJIcons.fi(FORTE_PACKAGE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.WATCH_ICON] = AJIcons.fi(FORTE_ADDWATCH);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.BREAKPOINTS_ICON] = AJIcons.cfi(FORTE_BREAKPOINTS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.VERIFIED_BREAKPOINT_ICON] = AJIcons.cfi(FORTE_BREAKPOINT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.UNVERIFIED_BREAKPOINT_ICON] = AJIcons.cfi(FORTE_BREAKPOINT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.MAIN_ICON] = AJIcons.cfi(FORTE_MAIN);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREADS_ICON] = AJIcons.cfi(FORTE_THREADS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREAD_ICON] = AJIcons.cfi(FORTE_THREAD_CURRENT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREAD_SUSPENDED_ICON] = AJIcons.cfi(FORTE_THREAD_CURRENT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREAD_BREAKPOINT_ICON] = AJIcons.cfi(FORTE_THREAD_CURRENT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREAD_RUNNING_ICON] = AJIcons.cfi(FORTE_THREAD_RUNNING);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREADGROUP_ICON] = AJIcons.dfi(FORTE_THREADGROUP_CURRENT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.FIELD_ICON] = AJIcons.cfi(FORTE_VARIABLE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.WATCHES_ICON] = AJIcons.cfi(FORTE_WATCHES);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.VARIABLES_ICON] = AJIcons.cfi(FORTE_VARIABLE);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.STACKFRAME_ICON] = AJIcons.cfi(FORTE_CALLSTACK);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.WATCHVAR_ICON] = AJIcons.cfi(FORTE_WATCH);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.THREADGROUP_ICON] = AJIcons.cfi(FORTE_THREADS);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
        try {
            AJIcons.icons[AJIcons.OUTPUT_ICON] = AJIcons.cfi(FORTE_OUTPUT);
        }
        catch (Exception e) {
            AJIcons.error(e);
        }
    }

    private static Icon jbuilderIcon(String arrayName, String access, boolean isStatic) throws Exception {
        Class<?> iconsClass = Class.forName(JAVA_STRUCTURE_ICONS);
        Icon[] icons = (Icon[])iconsClass.getField(arrayName).get(null);
        int index = (Integer)iconsClass.getField(access).get(null);
        if (isStatic) {
            index += ((Integer)iconsClass.getField(JB_STATIC).get(null)).intValue();
        }
        return icons[index];
    }

    private static Icon jbi(String s, String t, boolean b) throws Exception {
        return AJIcons.jbuilderIcon(s, t, b);
    }

    private static Icon getStaticIcon(String className, String fieldName) throws Exception {
        Class<?> browserIcons = Class.forName(className);
        return (Icon)browserIcons.getField(fieldName).get(null);
    }

    private static Icon browserIcon(String fieldName) throws Exception {
        return AJIcons.getJBBrowserIcon("ICON_" + fieldName);
    }

    public static Icon getJBBrowserIcon(String fieldName) {
        try {
            return AJIcons.getStaticIcon(JB_BROWSER_ICONS, fieldName);
        }
        catch (Exception e) {
            AJIcons.error(e);
            return null;
        }
    }

    private static Icon bri(String fieldName) throws Exception {
        return AJIcons.browserIcon(fieldName);
    }

    private static void createJBuilder3Icons() throws Exception {
        AJIcons.createJBuilder4Icons();
    }

    private static void createJBuilder4Icons() throws Exception {
        AJIcons.createStandAloneIcons();
        try {
            AJIcons.createActualJBuilder4Icons();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Please include the JBuilder4 jar");
        }
    }

    private static void createActualJBuilder4Icons() throws Exception {
        AJIcons.icons[AJIcons.INTERFACE_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.INTERFACE_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.INTERFACE_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PACKAGE, false);
        AJIcons.icons[AJIcons.INTERFACE_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PROTECTED, false);
        AJIcons.icons[AJIcons.INTERFACE_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PRIVATE, false);
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PUBLIC, true);
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PACKAGE, true);
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PROTECTED, true);
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_INTERFACE, JB_PRIVATE, true);
        AJIcons.icons[AJIcons.CLASS_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.CLASS_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.CLASS_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PACKAGE, false);
        AJIcons.icons[AJIcons.CLASS_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PROTECTED, false);
        AJIcons.icons[AJIcons.CLASS_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PRIVATE, false);
        AJIcons.icons[AJIcons.CLASS_STATIC_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PUBLIC, true);
        AJIcons.icons[AJIcons.CLASS_STATIC_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PACKAGE, true);
        AJIcons.icons[AJIcons.CLASS_STATIC_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PROTECTED, true);
        AJIcons.icons[AJIcons.CLASS_STATIC_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_CLASS, JB_PRIVATE, true);
        AJIcons.icons[AJIcons.METHOD_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.METHOD_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.METHOD_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PACKAGE, false);
        AJIcons.icons[AJIcons.METHOD_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PROTECTED, false);
        AJIcons.icons[AJIcons.METHOD_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PRIVATE, false);
        AJIcons.icons[AJIcons.METHOD_STATIC_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PUBLIC, true);
        AJIcons.icons[AJIcons.METHOD_STATIC_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PACKAGE, true);
        AJIcons.icons[AJIcons.METHOD_STATIC_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PROTECTED, true);
        AJIcons.icons[AJIcons.METHOD_STATIC_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_METHOD, JB_PRIVATE, true);
        AJIcons.icons[AJIcons.FIELD_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.FIELD_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.FIELD_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PACKAGE, false);
        AJIcons.icons[AJIcons.FIELD_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PROTECTED, false);
        AJIcons.icons[AJIcons.FIELD_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PRIVATE, false);
        AJIcons.icons[AJIcons.FIELD_STATIC_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PUBLIC, true);
        AJIcons.icons[AJIcons.FIELD_STATIC_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PACKAGE, true);
        AJIcons.icons[AJIcons.FIELD_STATIC_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PROTECTED, true);
        AJIcons.icons[AJIcons.FIELD_STATIC_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_FIELD, JB_PRIVATE, true);
        AJIcons.icons[AJIcons.CTR_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.CTR_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PUBLIC, false);
        AJIcons.icons[AJIcons.CTR_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PACKAGE, false);
        AJIcons.icons[AJIcons.CTR_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PROTECTED, false);
        AJIcons.icons[AJIcons.CTR_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PRIVATE, false);
        AJIcons.icons[AJIcons.CTR_STATIC_PUBLIC_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PUBLIC, true);
        AJIcons.icons[AJIcons.CTR_STATIC_PACKAGE_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PACKAGE, true);
        AJIcons.icons[AJIcons.CTR_STATIC_PROTECTED_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PROTECTED, true);
        AJIcons.icons[AJIcons.CTR_STATIC_PRIVATE_ICON] = AJIcons.jbi(JB_ICONS_CTR, JB_PRIVATE, true);
        AJIcons.icons[AJIcons.BAD_ICON] = AJIcons.bri(JB_ERROR);
        AJIcons.icons[AJIcons.WHERE_ICON] = AJIcons.bri(JB_SHOWFRAME);
        AJIcons.icons[AJIcons.UNVERIFIED_BREAKPOINT_ICON] = AJIcons.bri(JB_BREAKPOINTINVALID);
        AJIcons.icons[AJIcons.VERIFIED_BREAKPOINT_ICON] = AJIcons.bri(JB_BREAKPOINTVERIFIED);
        AJIcons.icons[AJIcons.THREAD_BREAKPOINT_ICON] = AJIcons.bri(JB_THREADBREAK);
        AJIcons.icons[AJIcons.THREAD_SUSPENDED_ICON] = AJIcons.bri(JB_THREADSUSPENDED);
        AJIcons.icons[AJIcons.BOOLEAN_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.BYTE_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.CHAR_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.DOUBLE_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.FLOAT_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.INTEGER_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.LONG_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.SHORT_ICON] = AJIcons.bri(JB_PRIMITIVE);
        AJIcons.icons[AJIcons.THREADGROUP_ICON] = AJIcons.bri(JB_THREADGROUP);
        AJIcons.icons[AJIcons.NULL_OBJECT_ICON] = AJIcons.bri(JB_NULL);
        AJIcons.icons[AJIcons.WATCH_ICON] = AJIcons.bri(JB_ADDWATCH);
        AJIcons.icons[AJIcons.STOP_ICON] = AJIcons.bri(JB_ADDBREAKPOINT);
        AJIcons.icons[AJIcons.THREAD_ICON] = AJIcons.bri(JB_THREAD);
        AJIcons.icons[AJIcons.ARRAY_ICON] = AJIcons.bri(JB_ARRAY);
        AJIcons.icons[AJIcons.STEPUP_ICON] = AJIcons.bri(JB_STEPOUT);
        AJIcons.icons[AJIcons.NEXT_ICON] = AJIcons.bri(JB_STEPOVER);
        AJIcons.icons[AJIcons.STEP_ICON] = AJIcons.bri(JB_STEPINTO);
        AJIcons.icons[AJIcons.SUSPEND_ICON] = AJIcons.bri(JB_PROGRAMPAUSE);
        AJIcons.icons[AJIcons.QUIT_ICON] = AJIcons.bri(JB_PROGRAMSTOP);
        AJIcons.icons[AJIcons.RUN_ICON] = AJIcons.bri(JB_PROGRAMRESUME);
        AJIcons.icons[AJIcons.RESUME_ICON] = AJIcons.bri(JB_PROGRAMRESUME);
        AJIcons.icons[AJIcons.THREADS_ICON] = AJIcons.bri(JB_THREADGROUP);
        AJIcons.icons[AJIcons.WATCHES_ICON] = AJIcons.bri(JB_WATCH);
        AJIcons.icons[AJIcons.BREAKPOINTS_ICON] = AJIcons.bri(JB_VIEWBREAKPOINTS);
        AJIcons.icons[AJIcons.CLASSES_ICON] = AJIcons.bri(JB_VIEWLOADEDCLASSES);
        AJIcons.icons[AJIcons.PACKAGE_ICON] = AJIcons.bri(JB_PACKAGE);
        AJIcons.icons[AJIcons.STACKFRAME_ICON] = AJIcons.bri(JB_SHOWEXECPOINT);
        AJIcons.icons[AJIcons.OBJECT_ICON] = AJIcons.bri(JB_CLASS);
        AJIcons.icons[AJIcons.THREAD_RUNNING_ICON] = AJIcons.bri(JB_THREAD);
    }

    private static void createStandAloneIcons() {
        AJIcons.icons[AJIcons.BAD_ICON] = new BAD_ICON();
        AJIcons.icons[AJIcons.DEFAULT_ICON] = new DEFAULT_ICON();
        AJIcons.icons[AJIcons.THREAD_ICON] = new THREAD_ICON();
        AJIcons.icons[AJIcons.THREADGROUP_ICON] = new THREADGROUP_ICON();
        AJIcons.icons[AJIcons.ROOT_ICON] = new ROOT_ICON();
        AJIcons.icons[AJIcons.STACKFRAME_ICON] = new STACKFRAME_ICON();
        AJIcons.icons[AJIcons.THREAD_BREAKPOINT_ICON] = new THREAD_BREAKPOINT_ICON();
        AJIcons.icons[AJIcons.THREAD_SUSPENDED_ICON] = new THREAD_SUSPENDED_ICON();
        AJIcons.icons[AJIcons.THREAD_RUNNING_ICON] = new THREAD_RUNNING_ICON();
        AJIcons.icons[AJIcons.INVALID_ICON] = new INVALID_ICON();
        AJIcons.icons[AJIcons.LOCAL_VARIABLE_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.BOOLEAN_ICON] = new BOOLEAN_ICON();
        AJIcons.icons[AJIcons.BYTE_ICON] = new BYTE_ICON();
        AJIcons.icons[AJIcons.CHAR_ICON] = new CHAR_ICON();
        AJIcons.icons[AJIcons.DOUBLE_ICON] = new DOUBLE_ICON();
        AJIcons.icons[AJIcons.FLOAT_ICON] = new FLOAT_ICON();
        AJIcons.icons[AJIcons.INTEGER_ICON] = new INTEGER_ICON();
        AJIcons.icons[AJIcons.LONG_ICON] = new LONG_ICON();
        AJIcons.icons[AJIcons.OBJECT_ICON] = new OBJECT_ICON();
        AJIcons.icons[AJIcons.SHORT_ICON] = new SHORT_ICON();
        AJIcons.icons[AJIcons.ARRAY_ICON] = new ARRAY_ICON();
        AJIcons.icons[AJIcons.EXECUTABLE_ICON] = new EXECUTABLE_ICON();
        AJIcons.icons[AJIcons.VERIFIED_BREAKPOINT_ICON] = new VERIFIED_BREAKPOINT_ICON();
        AJIcons.icons[AJIcons.UNVERIFIED_BREAKPOINT_ICON] = new UNVERIFIED_BREAKPOINT_ICON();
        AJIcons.icons[AJIcons.NULL_OBJECT_ICON] = new NULL_OBJECT_ICON();
        AJIcons.icons[AJIcons.DOCUMENT_ICON] = new DOCUMENT_ICON();
        AJIcons.icons[AJIcons.FOLDER_ICON] = new FOLDER_ICON();
        AJIcons.icons[AJIcons.STOP_ICON] = new STOP_ICON();
        AJIcons.icons[AJIcons.CONT_ICON] = new CONT_ICON();
        AJIcons.icons[AJIcons.SUSPEND_ICON] = new SUSPEND_ICON();
        AJIcons.icons[AJIcons.RESUME_ICON] = new RESUME_ICON();
        AJIcons.icons[AJIcons.NEXT_ICON] = new NEXT_ICON();
        AJIcons.icons[AJIcons.STEPI_ICON] = new STEPI_ICON();
        AJIcons.icons[AJIcons.STEPUP_ICON] = new STEPUP_ICON();
        AJIcons.icons[AJIcons.STEP_ICON] = new STEP_ICON();
        AJIcons.icons[AJIcons.QUIT_ICON] = new QUIT_ICON();
        AJIcons.icons[AJIcons.RUN_ICON] = new RUN_ICON();
        AJIcons.icons[AJIcons.PACKAGE_ICON] = new PACKAGE_ICON();
        AJIcons.icons[AJIcons.BLANK_ICON] = new BLANK_ICON();
        AJIcons.icons[AJIcons.ADVICE_ICON] = new ADVICE_ICON();
        AJIcons.icons[AJIcons.ASPECT_ICON] = new ASPECT_ICON();
        AJIcons.icons[AJIcons.WHERE_ICON] = new WHERE_ICON();
        AJIcons.icons[AJIcons.HELP_ICON] = new HELP_ICON();
        AJIcons.icons[AJIcons.ABOUT_ICON] = new ABOUT_ICON();
        AJIcons.icons[AJIcons.PRINT_ICON] = new PRINT_ICON();
        AJIcons.icons[AJIcons.FIELDS_ICON] = new FIELDS_ICON();
        AJIcons.icons[AJIcons.DUMP_ICON] = new DUMP_ICON();
        AJIcons.icons[AJIcons.EVALUATE_ICON] = new EVALUATE_ICON();
        AJIcons.icons[AJIcons.LOCALS_ICON] = new LOCALS_ICON();
        AJIcons.icons[AJIcons.USE_ICON] = new USE_ICON();
        AJIcons.icons[AJIcons.CLEAR_ICON] = new CLEAR_ICON();
        AJIcons.icons[AJIcons.DISCONNECT_ICON] = new DISCONNECT_ICON();
        AJIcons.icons[AJIcons.CATCH_ICON] = new CATCH_ICON();
        AJIcons.icons[AJIcons.WATCH_ICON] = new BAD_ICON();
        AJIcons.icons[AJIcons.MAIN_ICON] = new BAD_ICON();
        AJIcons.icons[AJIcons.BREAKPOINTS_ICON] = new ROOT_ICON();
        AJIcons.icons[AJIcons.THREADS_ICON] = new ROOT_ICON();
        AJIcons.icons[AJIcons.WATCHES_ICON] = new ROOT_ICON();
        AJIcons.icons[AJIcons.INITIALIZER_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.VARIABLES_ICON] = new ROOT_ICON();
        AJIcons.icons[AJIcons.WATCHVAR_ICON] = new FIELDS_ICON();
        AJIcons.icons[AJIcons.CLASSES_ICON] = new PACKAGE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_PUBLIC_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_PACKAGE_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_PROTECTED_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_PRIVATE_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PUBLIC_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PACKAGE_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PROTECTED_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.INTERFACE_STATIC_PRIVATE_ICON] = new INTERFACE_ICON();
        AJIcons.icons[AJIcons.CLASS_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_PUBLIC_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_PACKAGE_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_PROTECTED_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_PRIVATE_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_STATIC_PUBLIC_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_STATIC_PACKAGE_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_STATIC_PROTECTED_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.CLASS_STATIC_PRIVATE_ICON] = new CLASS_ICON();
        AJIcons.icons[AJIcons.METHOD_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_PUBLIC_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_PACKAGE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_PROTECTED_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_PRIVATE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_STATIC_PUBLIC_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_STATIC_PACKAGE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_STATIC_PROTECTED_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.METHOD_STATIC_PRIVATE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.FIELD_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_PUBLIC_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_PACKAGE_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_PROTECTED_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_PRIVATE_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_STATIC_PUBLIC_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_STATIC_PACKAGE_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_STATIC_PROTECTED_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.FIELD_STATIC_PRIVATE_ICON] = new LOCAL_VARIABLE_ICON();
        AJIcons.icons[AJIcons.CTR_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_PUBLIC_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_PACKAGE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_PROTECTED_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_PRIVATE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_STATIC_PUBLIC_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_STATIC_PACKAGE_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_STATIC_PROTECTED_ICON] = new METHOD_ICON();
        AJIcons.icons[AJIcons.CTR_STATIC_PRIVATE_ICON] = new METHOD_ICON();
        NO_ICON = icons[DEFAULT_ICON];
    }

    public static String d() {
        return "AspectJ Icons [" + Modes.getMode() + "]";
    }

    public static Icon getIcon(AJTreeNode node) {
        return AJIcons.getIcon(node.getType());
    }

    public static Icon getIcon(int type) {
        if (type < 0) {
            throw new ArrayIndexOutOfBoundsException("icon type out of range: " + type + " < 0");
        }
        if (type >= icons.length) {
            throw new ArrayIndexOutOfBoundsException("icon type out of range: " + type + " > " + (icons.length - 1));
        }
        return icons[type];
    }

    public static void main(String[] args) {
        new AJIconsTest().go(icons);
    }
}

