/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import java.util.List;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.AJValueNodeFactory;

public class AJClassNode
extends AJTreeNode {
    private ReferenceType refType;
    private byte numAddKids = 0;

    public AJClassNode(ReferenceType refType) {
        super(AJIcons.CLASS_ICON);
        this.refType = refType;
        this.setUserObject(refType);
        if (!this.callsAddKids()) {
            this.addKids();
        }
    }

    protected void addKids() {
        byte by = this.numAddKids;
        this.numAddKids = (byte)(by + 1);
        if (by > 1) {
            throw new RuntimeException("Only call addKids() once");
        }
        this.addSuperTypes();
        this.addStaticFields();
        this.addMethods();
    }

    protected boolean callsAddKids() {
        return false;
    }

    private void addSuperTypes() {
        if (this.refType instanceof ClassType) {
            this.addSuperTypes((ClassType)this.refType);
        } else if (this.refType instanceof InterfaceType) {
            this.addSuperTypes((InterfaceType)this.refType);
        } else if (this.refType instanceof ArrayType) {
            this.addSuperTypes((ArrayType)this.refType);
        }
    }

    private void addSuperTypes(ClassType classType) {
        if (classType.name().equals("java.lang.Object")) {
            return;
        }
        ClassType superClass = classType.superclass();
        if (superClass != null) {
            this.add(this.newClassNode(superClass));
        }
        this.addSuperTypes(classType.allInterfaces());
    }

    protected AJClassNode newClassNode(ReferenceType refType) {
        return new AJClassNode(refType);
    }

    private void addSuperTypes(InterfaceType interfaceType) {
        this.addSuperTypes(interfaceType.superinterfaces());
    }

    private void addSuperTypes(List interfaces) {
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            InterfaceType interfaceType = (InterfaceType)iter.next();
            this.add(this.newClassNode(interfaceType));
        }
    }

    private void addSuperTypes(ArrayType arrayType) {
    }

    private void addStaticFields() {
        if (this.refType == null) {
            return;
        }
        Iterator<Field> iter = this.refType.allFields().iterator();
        while (iter.hasNext()) {
            AJValueNode valueNode;
            Field field = iter.next();
            if (!field.isStatic() || !field.declaringType().equals(this.refType) || (valueNode = AJValueNodeFactory.make(this.refType, field)).getName().indexOf("$") != -1) continue;
            this.add(valueNode);
        }
    }

    protected void addMethods() {
    }

    public int getType() {
        if (this.refType != null) {
            if (this.refType instanceof ClassType) {
                ClassType type = (ClassType)this.refType;
                if (type.isStatic()) {
                    if (type.isPublic()) {
                        return AJIcons.CLASS_STATIC_PUBLIC_ICON;
                    }
                    if (type.isPackagePrivate()) {
                        return AJIcons.CLASS_STATIC_PACKAGE_ICON;
                    }
                    if (type.isProtected()) {
                        return AJIcons.CLASS_STATIC_PROTECTED_ICON;
                    }
                    if (type.isPrivate()) {
                        return AJIcons.CLASS_STATIC_PRIVATE_ICON;
                    }
                } else {
                    if (type.isPublic()) {
                        return AJIcons.CLASS_PUBLIC_ICON;
                    }
                    if (type.isPackagePrivate()) {
                        return AJIcons.CLASS_PACKAGE_ICON;
                    }
                    if (type.isProtected()) {
                        return AJIcons.CLASS_PROTECTED_ICON;
                    }
                    if (type.isPrivate()) {
                        return AJIcons.CLASS_PRIVATE_ICON;
                    }
                }
                return AJIcons.CLASS_ICON;
            }
            if (this.refType instanceof InterfaceType) {
                return AJIcons.INTERFACE_ICON;
            }
        }
        return AJIcons.CLASS_ICON;
    }

    public String toString() {
        return ((ReferenceType)this.getUserObject()).name();
    }
}

