/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.AJValueNodeFactory;
import org.aspectj.debugger.gui.Util;

public class AJArrayValueNode
extends AJValueNode {
    public AJArrayValueNode(AJValueGetter getter) {
        super(getter);
        this.setType(AJIcons.ARRAY_ICON);
    }

    public boolean isArray() {
        return true;
    }

    public void showKids() {
        if (this.getChildCount() == 0) {
            this.showMembers();
        }
    }

    public void hideKids() {
    }

    private void showMembers() {
        this.hideMembers();
        try {
            ArrayReference array = (ArrayReference)this.g().getValue();
            int i = 0;
            while (i < array.length()) {
                AJValueNode valueNode = AJValueNodeFactory.make(array, i);
                this.add(valueNode);
                ++i;
            }
        }
        catch (Exception e) {
            Util.ex(e);
        }
    }

    private void hideMembers() {
    }

    private String getArrayString() {
        int i = 0;
        String str = "";
        while (i < this.children.size() - 1) {
            str = str + ((AJValueNode)this.children.get(i++)).getValueString() + ", ";
        }
        if (i >= 0) {
            str = str + ((AJValueNode)this.children.get(i)).getValueString();
        }
        return str;
    }

    public String getValueString() {
        String type = "no class loaded";
        try {
            type = this.g().getTypeName();
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        return type;
    }
}

