/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import java.util.List;
import org.aspectj.debugger.base.Consts;
import org.aspectj.debugger.base.DebuggerException;

public class ThreadLockInformation {
    private ThreadReference threadRef;

    public ThreadLockInformation(ThreadReference threadRef) {
        this.threadRef = threadRef;
    }

    public List getOwnedMonitors() throws DebuggerException {
        try {
            return this.threadRef.ownedMonitors();
        }
        catch (UnsupportedOperationException uoe) {
            throw new DebuggerException(uoe);
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebuggerException(itse);
        }
    }

    public List getWaitingThreads() throws DebuggerException {
        try {
            return this.threadRef.waitingThreads();
        }
        catch (UnsupportedOperationException uoe) {
            throw new DebuggerException(uoe);
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebuggerException(itse);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        try {
            void e;
            String str = "Thread: " + this.threadRef + Consts.newline;
            str = str + "Owned monitors: " + this.getOwnedMonitors() + Consts.newline;
            str = str + "Waiting threads: " + this.getWaitingThreads();
            return e;
        }
        catch (DebuggerException debuggerException) {
            return "Thread thread has resumed.";
        }
    }
}

