/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import java.io.File;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.tools.ide.SourceLine;
import org.aspectj.util.LineNumberTableMapper;

public class SourceLineFinder {
    private String fullSrcPath;
    private Location loc;
    static boolean debug = false;

    static void db(Object o) {
        if (debug) {
            System.out.println(o);
        }
    }

    public SourceLineFinder(String fullSrcPath) {
        this.fullSrcPath = fullSrcPath;
    }

    public SourceLine findMethod(Location loc) {
        try {
            String pkgfullName = loc.declaringType().name();
            int pkgLoc = pkgfullName.lastIndexOf(46);
            String pkg = -1 == pkgLoc ? null : pkgfullName.substring(0, pkgLoc).replace('.', '/');
            String attrib = loc.sourceName();
            String srcPath = AJDebugger.INSTANCE.getSourcePath();
            File srcRoot = new File(srcPath);
            LineNumberTableMapper lntm = new LineNumberTableMapper(attrib, pkg, srcRoot);
            System.err.println(">> lntm: " + lntm.getCorrespondingFile(loc.lineNumber()).getPath() + " : " + lntm.getCorrespondingLineNumber(loc.lineNumber()));
            return new SourceLine(lntm.getCorrespondingFile(loc.lineNumber()).getPath(), lntm.getCorrespondingLineNumber(loc.lineNumber()));
        }
        catch (AbsentInformationException aie) {
            System.err.println("> ERROR: absent information.");
            aie.printStackTrace();
            return null;
        }
    }

    public SourceLine findMethod(String className, String methodName) {
        System.err.println(">> findMethod className: " + className + ", methodName: " + methodName);
        return new SourceLine(className, -1);
    }
}

