/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.math.BigDecimal;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;

public class Evaluator {
    private Debugger debugger;
    public static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "catch", "char", "class", "continue", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "long", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "case", "default", "synchronized", "this", "throw", "throws", "try", "true", "void", "while"};

    public Evaluator(Debugger debugger) {
        this.debugger = debugger;
    }

    private AJDebugger dbg() {
        return (AJDebugger)this.debugger;
    }

    private VirtualMachine vm() throws NoVMException {
        return this.dbg().getVM();
    }

    public Value getValue(Object o, StackFrame frame) throws NoVMException, DebuggerException {
        LocalVariable local;
        String valueString = (o + "").trim();
        if (this.isIdent(valueString) && (local = this.getLocalVariable(o, frame)) != null) {
            return frame.getValue(local);
        }
        return this.getPrimitiveValue(valueString);
    }

    public Value getPrimitiveValue(String valueString) throws NoVMException, DebuggerException {
        if (valueString.startsWith("\"")) {
            if (valueString.length() > 1) {
                String s = valueString.endsWith("\"") ? valueString.substring(1, valueString.length() - 1) : valueString.substring(1);
                return this.vm().mirrorOf(s);
            }
        } else if (valueString.startsWith("'")) {
            if (valueString.length() > 1) {
                char c = valueString.charAt(1);
                return this.vm().mirrorOf(c);
            }
        } else {
            if (valueString.equals("true")) {
                return this.vm().mirrorOf(true);
            }
            if (valueString.equals("false")) {
                return this.vm().mirrorOf(false);
            }
            try {
                return this.vm().mirrorOf(Integer.parseInt(valueString));
            }
            catch (NumberFormatException e) {
                try {
                    return this.vm().mirrorOf(Long.parseLong(valueString));
                }
                catch (NumberFormatException e2) {
                    try {
                        return this.vm().mirrorOf(Float.parseFloat(valueString));
                    }
                    catch (NumberFormatException e3) {
                        try {
                            return this.vm().mirrorOf(Double.parseDouble(valueString));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        throw new UnableToParseException(valueString);
    }

    public LocalVariable getLocalVariable(Object o, StackFrame frame) throws NoVMException, DebuggerException {
        String valueString = o + "";
        if (this.isIdent(valueString)) {
            try {
                LocalVariable local = frame.visibleVariableByName(valueString);
                return local;
            }
            catch (AbsentInformationException aie) {
            }
            catch (InvalidStackFrameException isfe) {
                // empty catch block
            }
        }
        throw new UnableToParseException(valueString);
    }

    private boolean isNumber(String s) {
        try {
            new BigDecimal(s);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isIdent(String s) {
        if (s == null || s.length() == 0 || s.equals("")) {
            return true;
        }
        if (this.isJavaKeyword(s)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < s.length()) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isJavaKeyword(String s) {
        int i = 0;
        while (i < keywords.length) {
            if (s.equals(keywords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    class UnableToParseException
    extends DebuggerException {
        public UnableToParseException(String expr) {
            super("The following expression cannot be currently parsed: " + expr);
        }
    }
}

