/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.debugger.base.AmbiguousClassException;
import org.aspectj.debugger.base.Checker;
import org.aspectj.debugger.base.ClassListener;
import org.aspectj.debugger.base.CommandReceiver;
import org.aspectj.debugger.base.Debug;
import org.aspectj.debugger.base.DebuggerAdapter;
import org.aspectj.debugger.base.DebuggerApp;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.DebuggerListener;
import org.aspectj.debugger.base.ErrorLoggable;
import org.aspectj.debugger.base.Evaluator;
import org.aspectj.debugger.base.EventSpinner;
import org.aspectj.debugger.base.InvalidClassException;
import org.aspectj.debugger.base.LockInformation;
import org.aspectj.debugger.base.MethodListener;
import org.aspectj.debugger.base.Modes;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.Options;
import org.aspectj.debugger.base.ParseException;
import org.aspectj.debugger.base.Parser;
import org.aspectj.debugger.base.ProgressListener;
import org.aspectj.debugger.base.PromptListener;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.base.SourcePathListener;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.base.ThreadListener;
import org.aspectj.debugger.base.ThreadLockInformation;
import org.aspectj.debugger.base.ThreadNotFoundException;
import org.aspectj.debugger.base.Threads;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.request.BangBangRequest;
import org.aspectj.debugger.request.CatchRequest;
import org.aspectj.debugger.request.ClassLineBreakpointRequestAction;
import org.aspectj.debugger.request.ClassRequest;
import org.aspectj.debugger.request.ClassesRequest;
import org.aspectj.debugger.request.ClasspathRequest;
import org.aspectj.debugger.request.ClearAllRequest;
import org.aspectj.debugger.request.ClearAtRequest;
import org.aspectj.debugger.request.ClearInRequest;
import org.aspectj.debugger.request.ClearListRequest;
import org.aspectj.debugger.request.ClearOnRequest;
import org.aspectj.debugger.request.ConnectRequest;
import org.aspectj.debugger.request.ContRequest;
import org.aspectj.debugger.request.DeportRequest;
import org.aspectj.debugger.request.DownRequest;
import org.aspectj.debugger.request.DumpRequest;
import org.aspectj.debugger.request.EvalRequest;
import org.aspectj.debugger.request.ExcludeRequest;
import org.aspectj.debugger.request.FieldsRequest;
import org.aspectj.debugger.request.HelpRequest;
import org.aspectj.debugger.request.IgnoreRequest;
import org.aspectj.debugger.request.ImportRequest;
import org.aspectj.debugger.request.InterruptRequest;
import org.aspectj.debugger.request.KillRequest;
import org.aspectj.debugger.request.ListRequest;
import org.aspectj.debugger.request.LocalsRequest;
import org.aspectj.debugger.request.LockRequest;
import org.aspectj.debugger.request.LsRequest;
import org.aspectj.debugger.request.MethodsRequest;
import org.aspectj.debugger.request.MonitorListRequest;
import org.aspectj.debugger.request.MonitorRequest;
import org.aspectj.debugger.request.NextRequest;
import org.aspectj.debugger.request.PrintRequest;
import org.aspectj.debugger.request.PwdRequest;
import org.aspectj.debugger.request.QuitRequest;
import org.aspectj.debugger.request.ReadRequest;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.RequestAction;
import org.aspectj.debugger.request.RequestEvent;
import org.aspectj.debugger.request.ResumeRequest;
import org.aspectj.debugger.request.SetRequest;
import org.aspectj.debugger.request.SourceLineBreakpointRequestAction;
import org.aspectj.debugger.request.StepIRequest;
import org.aspectj.debugger.request.StepIntoRequest;
import org.aspectj.debugger.request.StepUpRequest;
import org.aspectj.debugger.request.StopAtRequest;
import org.aspectj.debugger.request.StopInRequest;
import org.aspectj.debugger.request.StopListRequest;
import org.aspectj.debugger.request.StopOnRequest;
import org.aspectj.debugger.request.SuspendRequest;
import org.aspectj.debugger.request.ThreadGroupRequest;
import org.aspectj.debugger.request.ThreadGroupsRequest;
import org.aspectj.debugger.request.ThreadLocksRequest;
import org.aspectj.debugger.request.ThreadRequest;
import org.aspectj.debugger.request.ThreadsRequest;
import org.aspectj.debugger.request.TostringRequest;
import org.aspectj.debugger.request.TraceMethodsRequest;
import org.aspectj.debugger.request.UnmonitorRequest;
import org.aspectj.debugger.request.UntraceMethodsRequest;
import org.aspectj.debugger.request.UnwatchAccessRequest;
import org.aspectj.debugger.request.UnwatchAllRequest;
import org.aspectj.debugger.request.UpRequest;
import org.aspectj.debugger.request.UseRequest;
import org.aspectj.debugger.request.VersionRequest;
import org.aspectj.debugger.request.ViewRequest;
import org.aspectj.debugger.request.WatchAccessRequest;
import org.aspectj.debugger.request.WatchAllRequest;
import org.aspectj.debugger.request.WhereRequest;
import org.aspectj.debugger.request.WorkingdirRequest;

public class Debugger
implements CommandReceiver,
ErrorLoggable {
    public static boolean demoMode = true;
    protected String currentStoppedSource = "";
    protected String date = "00/11/14";
    protected String version = "ajdb, version " + this.date;
    protected String prompt = ">";
    protected String runningClass;
    protected String status;
    protected String oldClass = "";
    protected String oldVmArgs = "";
    protected String oldCommandLine = "";
    private List requestActions;
    private List monitorList;
    private List excludes;
    private List importPaths;
    private List filePaths;
    protected Threads threads;
    protected DebuggerApp app;
    private Parser parser;
    private SourceManager sourceManager;
    private Evaluator evaluator;
    private EventSpinner spinner;
    private Options options = new Options();
    private int currentStoppedLine = -1;
    private int monitors = 1;
    private boolean isRunning = false;
    private boolean isStandAlone = true;
    private boolean isStopped = false;
    public static boolean debug = false;
    private static final String NO_ERROR = "default.error";
    private static final String NO_CLASS = "default.class";
    protected VirtualMachine vm;
    protected Vector classListeners = new AppVector();
    protected Vector stopListeners = new AppVector();
    protected Vector methodListeners = new AppVector();
    protected Vector threadListeners = new AppVector();
    protected Vector vmListeners = new AppVector();
    protected Vector debuggerListeners = new AppVector();
    protected Vector promptListeners = new AppVector();
    protected Vector sourcePathListeners = new AppVector();
    protected Vector progressListeners = new AppVector();
    private final boolean shipping = false;

    public static void db(Object o) {
        if (debug) {
            Thread.yield();
            System.err.println("<DEBUGGER>: " + o);
        }
    }

    public Debugger() {
        this(new DebuggerAdapter());
    }

    public Debugger(DebuggerApp app) {
        this.me();
        this.app = app;
        app.outln("Initializing ajdb...");
        new Checker(this).check();
        this.spinner = new EventSpinner(this);
        this.threads = new Threads(this);
        this.parser = new Parser(this);
        this.sourceManager = new SourceManager(this);
        this.evaluator = new Evaluator(this);
        this.requestActions = new Vector();
        this.monitorList = new Vector();
        this.excludes = new Vector();
        this.importPaths = new Vector();
        this.filePaths = new Vector();
        this.addImportPath("");
    }

    private void getVM(String vmArgs, String className, String commandLine) {
        if (this.vm != null) {
            this.vm = null;
        }
        this.vm = Modes.isJBuilder() || Modes.isForte() ? this.safeConnect(vmArgs, className, commandLine) : this.findVM(vmArgs, className, commandLine);
    }

    private VirtualMachine safeConnect(String vmArgs, String className, String commandLine) {
        try {
            return this.connectCommand(vmArgs, className, commandLine);
        }
        catch (DebuggerException de) {
            this.app.handleDebuggerException(de);
        }
        catch (Throwable t) {
            this.app.handleInternalException(t);
        }
        return null;
    }

    private void saveClassName(String oldClassName) {
        this.oldClass = oldClassName;
    }

    private static boolean empty(String str) {
        return str == null || str.length() == 0 || str.trim().equals("");
    }

    protected void go(String className, String vmArgs, String commandLine, boolean isSuspended, int debugTraceMode) {
        this.threads = new Threads(this);
        this.threads.flush();
        if (Debugger.empty(className)) {
            className = this.oldClass;
        }
        if (className != null) {
            this.oldClass = className;
        }
        if (Debugger.empty(vmArgs)) {
            vmArgs = this.oldVmArgs;
        }
        if (vmArgs != null) {
            this.oldVmArgs = vmArgs;
        }
        if (Debugger.empty(commandLine)) {
            commandLine = this.oldCommandLine;
        }
        if (commandLine != null) {
            this.oldCommandLine = commandLine;
        }
        if (Modes.isJBuilder() || Modes.isForte() || className != null && !className.trim().equals("")) {
            this.getVM(vmArgs, className, commandLine);
        }
        String error = "The class '" + className + "', args '" + vmArgs + "'" + "\n, and/or command line '" + commandLine + "' are invalid";
        try {
            this.startUpVM(this.vm, error, className, debugTraceMode, isSuspended);
        }
        catch (ClassNotFoundException cnfe) {
            this.handleClassNotFound(cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.handleClassNotFound(ncdfe);
        }
        this.fireStartEvent();
    }

    private void handleClassNotFound(Throwable cnfe) {
        cnfe.printStackTrace();
    }

    private void startUpVM(VirtualMachine newVm) throws ClassNotFoundException, NoClassDefFoundError {
        this.startUpVM(newVm, NO_ERROR, NO_CLASS, 0, false);
    }

    private void startUpVM(VirtualMachine newVm, String error, String className, int debugTraceMode, boolean isSuspended) throws ClassNotFoundException, NoClassDefFoundError {
        this.vm = newVm;
        if (this.vm == null) {
            if (!Modes.isJBuilder() && !Modes.isForte()) {
                this.error("The VM is null.\n" + error);
            }
            return;
        }
        Process process = this.vm.process();
        this.redirect(process.getErrorStream(), "error-dumper");
        this.redirect(process.getInputStream(), "input-dumper");
        this.vm.setDebugTraceMode(debugTraceMode);
        this.spinner.start();
        this.wakeUpRequests();
        if (isSuspended) {
            try {
                this.stopInCommand(className, "main(java.lang.String[])");
            }
            catch (NoVMException nvme) {
                this.app.handleInternalException(nvme);
                return;
            }
            catch (DebuggerException de) {
                this.app.handleInternalException(de);
                return;
            }
        }
        EventRequestManager em = this.vm.eventRequestManager();
        ClassPrepareRequest cpr = em.createClassPrepareRequest();
        cpr.setSuspendPolicy(2);
        cpr.enable();
        ClassUnloadRequest cur = em.createClassUnloadRequest();
        cur.setSuspendPolicy(2);
        cur.enable();
        ThreadStartRequest tsr = em.createThreadStartRequest();
        tsr.setSuspendPolicy(2);
        tsr.enable();
        ThreadDeathRequest tdr = em.createThreadDeathRequest();
        tdr.setSuspendPolicy(2);
        tdr.enable();
        ExceptionRequest er = em.createExceptionRequest(null, false, true);
        er.setSuspendPolicy(2);
        er.enable();
        this.vm.resume();
    }

    public void setOptions(Options options) {
        this.options = options;
        if (options.isSet("sourcepath")) {
            this.use(options.getOpt("sourcepath"));
        }
    }

    public void log(Object o) {
        if (!this.getOptions().isSet("nologging")) {
            this.app.log(o);
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public void resumeUntilZero() throws DebuggerException {
        this.resumeUntilZero(this.getVM().allThreads(), 1);
        this.getVM().resume();
    }

    public void resume() throws DebuggerException {
        this.resume(this.getVM().allThreads());
    }

    public void resumeUntilZero(List threads) throws DebuggerException {
        this.resumeUntilZero(threads, 0);
    }

    public void resumeUntilZero(List threads, int num) throws DebuggerException {
        Iterator iter = threads.iterator();
        while (iter.hasNext()) {
            ThreadReference threadRef = (ThreadReference)iter.next();
            this.resumeUntilZero(threadRef, num);
        }
    }

    public void resume(List threads) {
        Iterator iter = threads.iterator();
        while (iter.hasNext()) {
            this.resume((ThreadReference)iter.next());
        }
    }

    public void resumeUntilZero(ThreadReference threadRef) {
        this.resumeUntilZero(threadRef, 0);
    }

    public void resumeUntilZero(ThreadReference threadRef, int num) {
        int n = threadRef.suspendCount();
        while (n-- > num) {
            threadRef.resume();
        }
    }

    public void resume(ThreadReference threadRef) {
        threadRef.resume();
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public Value getValue(Object o) throws NoVMException, DebuggerException {
        return this.getValue(o, this.getDefaultFrame());
    }

    public Value getValue(Object o, StackFrame frame) throws NoVMException, DebuggerException {
        return this.getEvaluator().getValue(o, frame);
    }

    public ReferenceType getReferenceTypeFromToken(String className) throws NoVMException {
        ReferenceType refType = null;
        Iterator<ReferenceType> iter = this.getVM().allClasses().iterator();
        while (iter.hasNext()) {
            refType = iter.next();
            if (!refType.name().equals(className)) continue;
            return refType;
        }
        return null;
    }

    public ThreadReference getThread(String threadName) throws DebuggerException {
        if (threadName.equals("")) {
            return this.getDefaultThread();
        }
        Iterator<ThreadReference> iter = this.vm().allThreads().iterator();
        while (iter.hasNext()) {
            ThreadReference threadRef = iter.next();
            if (threadRef.name().equals(threadName)) {
                return threadRef;
            }
            try {
                long ourID = Long.parseLong(threadName);
                long refID = threadRef.uniqueID();
                if (ourID != refID) continue;
                return threadRef;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        throw new ThreadNotFoundException(threadName);
    }

    public void outln(Object o) {
        this.app.outln(o);
    }

    public DebuggerApp app() {
        return this.app;
    }

    public String getRunningClass() {
        return this.runningClass;
    }

    public ReferenceType classByName(String className) throws AmbiguousClassException, InvalidClassException {
        try {
            Iterator iter = this.importPaths.iterator();
            while (iter.hasNext()) {
                String fullName = iter.next() + "";
                if (!fullName.equals("")) {
                    fullName = fullName + ".";
                }
                fullName = fullName + className;
                List<ReferenceType> classes = this.getVM().classesByName(fullName);
                if (classes.size() > 1) {
                    throw new AmbiguousClassException(className, classes);
                }
                if (classes.size() != 1) continue;
                ReferenceType refType = classes.get(0);
                return refType;
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        throw new InvalidClassException(className);
    }

    public void addImportPath(String importPath) {
        this.importPaths.add(importPath);
        this.filePaths.add(this.fileFromPath(importPath));
    }

    private String fileFromPath(String importPath) {
        return importPath.replace('.', File.separatorChar);
    }

    public boolean removeImportPath(String importPath) {
        this.filePaths.remove(this.fileFromPath(importPath));
        return this.importPaths.remove(importPath);
    }

    public boolean addRequest(Request ra) {
        if (!this.requestActions.contains(ra)) {
            this.requestActions.add(ra);
            this.fireRequestSetEvent(new RequestEvent(ra, true));
            return true;
        }
        return false;
    }

    public EventRequest toggleBreakpoint(String source, int line) {
        SourceLineBreakpointRequestAction ba = null;
        try {
            ba = this.createSourceLineEvent(source, line, true);
        }
        catch (DebuggerException de) {
            return null;
        }
        if (ba == null) {
            return null;
        }
        try {
            if (!this.requestActions.contains(ba)) {
                return this.stopOnCommand(source, line);
            }
            return this.clearOnCommand(source, line);
        }
        catch (DebuggerException de) {
            return null;
        }
    }

    public RequestAction removeRequest(Request ra) {
        int i = 0;
        RequestAction req = null;
        while ((i = this.requestActions.indexOf(ra)) > -1) {
            EventRequest er;
            if (i == -1) continue;
            req = (RequestAction)this.requestActions.remove(i);
            SourceManager.SourceLine sl = null;
            if (req != null) {
                req.removeFromDebugger(this);
                sl = req.getSourceLine();
                this.fireRequestClearEvent(new RequestEvent(req, true));
            }
            if (sl != null) {
                sl.clear();
            }
            if ((er = req.getRequest()) == null || this.vm() == null) continue;
            this.vm().eventRequestManager().deleteEventRequest(er);
        }
        return req;
    }

    public List getRequests() {
        return this.requestActions;
    }

    private void wakeUpRequests() {
        Iterator iter = this.getRequests().iterator();
        try {
            while (iter.hasNext()) {
                RequestAction request = (RequestAction)iter.next();
                if (!request.isEnabled()) continue;
                request.go();
            }
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public String help() {
        String s = "** command list **\n";
        s = s + "run [class [args]]        -- start execution of application's main class\n";
        s = s + "\n";
        s = s + "threads [threadgroup]     -- list threads\n";
        s = s + "thread <thread id>        -- set default thread\n";
        s = s + "suspend [thread id(s)]    -- suspend threads (default: all)\n";
        s = s + "resume [thread id(s)]     -- resume threads (default: all)\n";
        s = s + "where [thread id] | all   -- dump a thread's stack\n";
        s = s + "wherei [thread id] | all  -- dump a thread's stack, with pc info\n";
        s = s + "up [n frames]             -- move up a thread's stack\n";
        s = s + "down [n frames]           -- move down a thread's stack\n";
        s = s + "kill <thread> <expr>      -- kill a thread with the given exception object\n";
        s = s + "interrupt <thread>        -- interrupt a thread\n";
        s = s + "\n";
        s = s + "print <expr>              -- print value of expression\n";
        s = s + "dump <expr>               -- print all object information\n";
        s = s + "eval <expr>               -- evaluate expression (same as print)\n";
        s = s + "set <lvalue> = <expr>     -- assign new value to field/variable/array element\n";
        s = s + "locals                    -- print all local variables in current stack frame\n";
        s = s + "\n";
        s = s + "classes                   -- list currently known classes\n";
        s = s + "class <class id>          -- show details of named class\n";
        s = s + "methods <class id>        -- list a class's methods\n";
        s = s + "fields <class id>         -- list a class's fields\n";
        s = s + "\n";
        s = s + "threadgroups              -- list threadgroups\n";
        s = s + "threadgroup <name>        -- set current threadgroup\n";
        s = s + "\n";
        s = s + "stop in <class id>.<method>[(argument_type,...)]\n";
        s = s + "                          -- set a breakpoint in a method\n";
        s = s + "stop at <class id>:<line> -- set a breakpoint at a line\n";
        s = s + "clear   <class id>.<method>[(argument_type,...)]\n";
        s = s + "                          -- clear a breakpoint in a method\n";
        s = s + "clear <class id>:<line>   -- clear a breakpoint at a line\n";
        s = s + "clear                     -- list breakpoints\n";
        s = s + "catch <class id>          -- break when specified exception thrown\n";
        s = s + "ignore <class id>         -- cancel 'catch'  for the specified exception\n";
        s = s + "watch [access|all] <class id>.<field name>\n";
        s = s + "                          -- watch access/modifications to a field\n";
        s = s + "unwatch [access|all] <class id>.<field name>\n";
        s = s + "                          -- discontinue watching access/modifications to a field\n";
        s = s + "trace methods [thread]    -- trace method entry and exit\n";
        s = s + "untrace methods [thread]  -- stop tracing method entry and exit\n";
        s = s + "step                      -- execute current line\n";
        s = s + "step up                   -- execute until the current method returns to its caller\n";
        s = s + "stepi                     -- execute current instruction\n";
        s = s + "next                      -- step one line (step OVER calls)\n";
        s = s + "cont                      -- continue execution from breakpoint\n";
        s = s + "\n";
        s = s + "list [line number|method] -- print source code\n";
        s = s + "use (or sourcepath) [source file path]\n";
        s = s + "                          -- display or change the source path\n";
        s = s + "exclude [class id ... | \"none\"]\n";
        s = s + "                          -- do not report step or method events for specified classes\n";
        s = s + "classpath                 -- print classpath info from target VM\n";
        s = s + "\n";
        s = s + "monitor <command>         -- execute command each time the program stops\n";
        s = s + "monitor                   -- list monitors\n";
        s = s + "unmonitor <monitor#>      -- delete a monitor\n";
        s = s + "read <filename>           -- read and execute a command file\n";
        s = s + "\n";
        s = s + "lock <expr>               -- print lock info for an object\n";
        s = s + "threadlocks [thread id]   -- print lock info for a thread\n";
        s = s + "\n";
        s = s + "disablegc <expr>          -- prevent garbage collection of an object\n";
        s = s + "enablegc <expr>           -- permit garbage collection of an object\n";
        s = s + "\n";
        s = s + "!!                        -- repeat last command\n";
        s = s + "<n> <command>             -- repeat command n times\n";
        s = s + "help (or ?)               -- list commands\n";
        s = s + "version                   -- print version information\n";
        s = s + "exit (or quit)            -- exit debugger\n";
        s = s + "workingdir <dir>          -- set the user's workingdir to <dir>\n";
        s = s + "\n";
        s = s + "<class id>: full class name with package qualifiers or a\n";
        s = s + "pattern with a leading or trailing wildcard ('*').\n";
        s = s + "<thread id>: thread number as reported in the 'threads' command\n";
        s = s + "<expr>: a Java(tm) Programming Language expression.\n";
        s = s + "Most common syntax is supported.\n";
        s = s + "\n";
        s = s + "Startup commands can be placed in either \"ajdb.ini\" or \".ajdbrc\"\n";
        s = s + "in user.home or user.dir\n";
        return s;
    }

    public String sourceName(Location loc) throws AbsentInformationException {
        return loc.sourceName();
    }

    public int lineNumber(Location loc) {
        return loc.lineNumber();
    }

    public long codeIndex(Location loc) {
        return loc.codeIndex();
    }

    public String method(Location loc) {
        return loc.method() + "";
    }

    public String name(Method method) {
        return method.name();
    }

    public void loadMainClass(Options options) {
        this.getVM(options.getJavaArgs(), options.getClassName(), options.getCommandLine());
    }

    public List getRequest(RequestComparator rc) {
        Vector v = new Vector();
        Iterator iter = this.requestActions.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!rc.wantsRequest(o)) continue;
            v.add(o);
        }
        return v;
    }

    public List getBreakpointRequests() {
        return this.getRequest(new RequestComparator(){

            public boolean wantsRequest(Object o) {
                return o instanceof StopOnRequest || o instanceof StopAtRequest || o instanceof StopInRequest;
            }
        });
    }

    public List getAccessWatchpointRequests() {
        return this.getRequest(new RequestComparator(){

            public boolean wantsRequest(Object o) {
                return o instanceof WatchAccessRequest;
            }
        });
    }

    public List getModificationWatchpointRequests() {
        return this.getRequest(new RequestComparator(){

            public boolean wantsRequest(Object o) {
                return o instanceof WatchAllRequest;
            }
        });
    }

    public List getExceptionRequests() {
        return this.getRequest(new RequestComparator(){

            public boolean wantsRequest(Object o) {
                return o instanceof CatchRequest;
            }
        });
    }

    public void addMonitorRequest(MonitorRequest request) {
        if (!this.monitorList.contains(request)) {
            this.monitorList.add(request);
            this.addStopListener(request);
        }
    }

    public boolean removeMonitorRequest(MonitorRequest request) {
        this.removeStopListener(request);
        return this.monitorList.remove(request);
    }

    public MonitorRequest removeMonitorRequest(int number) {
        MonitorRequest request = null;
        Iterator iter = this.monitorList.iterator();
        while (iter.hasNext()) {
            request = (MonitorRequest)iter.next();
            if (request.getNumber() == number) {
                this.monitorList.remove(request);
                break;
            }
            request = null;
        }
        if (request != null) {
            this.removeStopListener(request);
        }
        return request;
    }

    public List getMonitorRequests() {
        return this.monitorList;
    }

    public List getImportPaths() {
        return this.importPaths;
    }

    public List getFilePaths() {
        return this.filePaths;
    }

    public void addExclude(String className) {
        if (!this.excludes.contains(className)) {
            this.excludes.add(className);
        }
    }

    public void addExcludesTo(StepRequest request) {
        Iterator iter = this.excludes.iterator();
        while (iter.hasNext()) {
            request.addClassExclusionFilter(iter.next() + "");
        }
    }

    public void addExcludesTo(MethodEntryRequest request) {
        Iterator iter = this.excludes.iterator();
        while (iter.hasNext()) {
            request.addClassExclusionFilter(iter.next() + "");
        }
    }

    public void addExcludesTo(MethodExitRequest request) {
        Iterator iter = this.excludes.iterator();
        while (iter.hasNext()) {
            request.addClassExclusionFilter(iter.next() + "");
        }
    }

    public void clearExcludes() {
        this.excludes.clear();
    }

    public void shutDown() {
        this.spinner.shutDown();
        try {
            try {
                try {
                    this.getVM().resume();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    this.getVM().exit(0);
                }
                catch (VMDisconnectedException vmde) {
                    // empty catch block
                }
                try {
                    this.getVM().dispose();
                }
                catch (VMDisconnectedException vmde) {
                }
                Object var3_5 = null;
                this.vm = null;
            }
            catch (NoVMException nvme) {
                Object var3_6 = null;
                this.vm = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.vm = null;
            throw throwable;
        }
    }

    public void exit() {
        this.exit(true);
    }

    public void exit(boolean exit) {
        this.shutDown();
        if (exit && this.app.wantsToExit()) {
            System.exit(0);
        }
    }

    public void quit() {
        this.exit();
    }

    public String version() {
        return this.version + (this.vm() != null ? "\n" + this.vm().description() : "");
    }

    public void setStatus(Object o) {
        this.status = o + "";
    }

    public String getStatus() {
        return this.status;
    }

    public ThreadReference getDefaultThread() throws NoVMException {
        return this.threads.getThread();
    }

    public ThreadGroupReference getDefaultThreadGroup() throws NoVMException {
        return this.threads.getThreadGroup();
    }

    public StackFrame getDefaultFrame() throws NoVMException {
        return this.threads.getStackFrame();
    }

    public ObjectReference getDefaultThisObject() throws NoVMException {
        return this.getDefaultFrame().thisObject();
    }

    public int getFrame() {
        return this.threads.getFrame();
    }

    public int getCurrentStoppedLine() {
        return this.currentStoppedLine;
    }

    public String getCurrentStoppedSource() {
        return this.currentStoppedSource;
    }

    public boolean isStopped(SourceManager.SourceLine sl) {
        return sl.getSourceName().equals(this.getCurrentStoppedSource()) && sl.getLineNumber() == this.getCurrentStoppedLine();
    }

    protected boolean isSame(ThreadReference threadRef, String threadName) {
        if (threadRef.name().equals(threadName)) {
            return true;
        }
        try {
            long ourID = Long.parseLong(threadName);
            long refID = threadRef.uniqueID();
            if (ourID == refID) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public ThreadReference getStoppedThread() throws NoVMException {
        return this.threads.getStoppedThread();
    }

    public String getPrompt() {
        return this.prompt;
    }

    private void setPrompt() {
        try {
            this.setPrompt(this.getDefaultThread(), this.getFrame());
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }

    private void setPrompt(ThreadReference threadRef, int frame) {
        this.prompt = threadRef.name() + "[" + (frame + 1) + "]";
        this.fireResetPrompt();
    }

    private void resetPrompt(boolean isRunning) {
        this.isRunning = isRunning;
        this.prompt = ">";
    }

    public boolean isRunning() {
        return this.isRunning && this.vm != null;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public boolean isAtBreakpoint() {
        try {
            return this.getDefaultThread().isAtBreakpoint();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isExtra() {
        return this.getOptions().isSet("extra");
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    private void stop() {
        this.isStopped = true;
    }

    private void unstop() {
        this.isStopped = false;
    }

    public ThreadReference setDefaultThread(ThreadReference threadRef) {
        return this.threads.setThread(threadRef);
    }

    public ThreadGroupReference setDefaultThreadGroup(ThreadGroupReference threadGroupRef) {
        return this.threads.setThreadGroup(threadGroupRef);
    }

    public int setDefaultFrame(int frame) {
        return this.threads.setFrame(frame);
    }

    public int setFrame(int frame) {
        return this.threads.setFrame(frame);
    }

    public StackFrame up(int frames) {
        this.setFrame(this.getFrame() + frames);
        try {
            return this.getDefaultFrame();
        }
        catch (NoVMException noVMException) {
            return null;
        }
    }

    public StackFrame down(int frames) {
        this.setFrame(this.getFrame() - frames);
        try {
            return this.getDefaultFrame();
        }
        catch (NoVMException noVMException) {
            return null;
        }
    }

    public void use(String sourcePath) {
        this.sourceManager.setSourcePath(sourcePath);
        this.fireSourcePathChanged();
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public String getSourcePath() {
        return this.sourceManager.getSourcePath();
    }

    public void resumeAllThreads() throws NoVMException {
        Iterator<ThreadReference> iter = this.getVM().allThreads().iterator();
        while (iter.hasNext()) {
            iter.next().resume();
        }
    }

    private ThreadReference setStoppedThread(ThreadReference threadRef) {
        return this.threads.setStoppedThread(threadRef);
    }

    private void setDefaults(LocatableEvent le) {
        this.stop();
        ThreadReference threadRef = le.thread();
        this.setDefaultThread(threadRef);
        this.setStoppedThread(threadRef);
        this.setDefaultThreadGroup(threadRef.threadGroup());
        this.setDefaultFrame(0);
        this.setStopped(le);
    }

    private void setStopped(LocatableEvent le) {
        this.currentStoppedLine = this.lineNumber(le.location());
        try {
            this.currentStoppedSource = this.sourceName(le.location());
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
    }

    public void fatal(String str) {
        System.err.println("FATAL ERROR:");
        System.err.println(str);
        System.exit(1);
    }

    public void error(String str) {
        System.err.println(str);
    }

    public synchronized VirtualMachine getVM() throws NoVMException {
        if (this.vm == null) {
            throw new NoVMException();
        }
        return this.vm;
    }

    public synchronized VirtualMachine vm() {
        return this.vm;
    }

    private VirtualMachine findVM(Options options) {
        return this.findVM(options.getJavaArgs(), options.getClassName(), options.getCommandLine());
    }

    private VirtualMachine findVM(String vmArgs, String className, String commandLine) {
        return this.findLaunchingVM(vmArgs, className, commandLine);
    }

    private VirtualMachine findLaunchingVM(String vmArgs, String className, String commandLine) {
        return this.findLaunchingVM(vmArgs, className, commandLine, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VirtualMachine findLaunchingVM(String vmArgs, String className, String commandLine, boolean recurse) {
        Map<String, Connector.Argument> args;
        block11: {
            Debug.debug("------------- findLaunchingVM -----------");
            Debug.debug("commandLine=" + commandLine);
            Debug.debug("vmArgs=" + vmArgs);
            if (vmArgs == null) {
                vmArgs = "";
            }
            if (commandLine == null) {
                commandLine = "";
            }
            LaunchingConnector con = (LaunchingConnector)this.findConnector("");
            args = con.defaultArguments();
            args.get("main").setValue((className + " " + commandLine).trim());
            args.get("options").setValue(vmArgs);
            Debug.debug("args=" + args);
            Debug.debug("con=" + con);
            Debug.debug("--------------------------------------------------");
            this.vm = null;
            try {
                Debug.debug("before: vm=" + this.vm);
                this.vm = con.launch(args);
                Debug.debug("after: vm=" + this.vm);
            }
            catch (VMDisconnectedException vmde) {
                this.app.handleInternalException(vmde);
            }
            catch (VMStartException vmse) {
                if (!recurse) {
                    this.app.handleInternalException(vmse);
                }
            }
            catch (IllegalConnectorArgumentsException icae) {
                if (!recurse) {
                    this.app.handleInternalException(icae);
                }
            }
            catch (Exception e) {
                if (recurse) break block11;
                this.app.handleInternalException(e);
            }
        }
        Debug.debug("Done vm=" + this.vm);
        if (this.vm != null) return this.vm;
        if (!recurse) {
            this.app.handleInternalException(new Exception("VM is null"));
            return this.vm;
        }
        Debug.debug("Recursing...");
        String newCommandLine = this.findClassName(commandLine);
        if (newCommandLine == null) {
            this.app.handleInternalException(new Exception("No class specified on the command line: " + commandLine));
            return this.vm;
        }
        this.app.outln("Cannot support the arguments: " + args);
        return this.findLaunchingVM(vmArgs, className, newCommandLine, false);
    }

    private Connector findConnector(String name) {
        Debug.debug(this, "Looking for connector " + name);
        Iterator<Connector> iter = Bootstrap.virtualMachineManager().allConnectors().iterator();
        while (iter.hasNext()) {
            Connector con = iter.next();
            if (!con.name().equals(name)) continue;
            return con;
        }
        return Bootstrap.virtualMachineManager().defaultConnector();
    }

    private String findClassName(String commandLine) {
        StringTokenizer tok = new StringTokenizer(commandLine);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens() || token.startsWith("-")) continue;
            return token;
        }
        return null;
    }

    private void redirect(final InputStream in, String name) {
        new Thread(name){

            public void run() {
                Debugger.this.dump(in);
            }
        }.start();
    }

    /*
     * WARNING - void declaration
     */
    private void dump(InputStream stream) {
        PrintStream out = this.app.getOutputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                void var4_4;
                out.println((String)var4_4);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }

    protected void readStartupFiles() {
        try {
            this.readCommand("ajdb.ini");
            this.readCommand(".ajdbrc");
        }
        catch (NoVMException nvme) {
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    public Object execute(String line) {
        Object o = null;
        Debugger.db("execute line=" + line);
        try {
            o = this.parser.parse(line);
        }
        catch (Exception e) {
            this.handle(e);
        }
        return o;
    }

    public void handle(Exception t) {
        if (t instanceof ParseException) {
            this.app.handleParseException((ParseException)t);
        } else if (t instanceof NoVMException) {
            this.app.handleNoVMException((NoVMException)t);
        } else if (t instanceof DebuggerException) {
            this.app.handleDebuggerException((DebuggerException)t);
        } else if (t instanceof VMDisconnectedException) {
            this.app.handleVMDisconnectedException((VMDisconnectedException)t);
        } else {
            this.app.handleInternalException(t);
        }
    }

    public Object run(String mainClass, String[] args) throws NoVMException, DebuggerException {
        String str = "";
        int N = args.length;
        int i = 0;
        while (i < N) {
            str = str + args[i] + (i < N - 1 ? " " : "");
            ++i;
        }
        return this.runCommand(mainClass, str);
    }

    public Object run(String mainClass) throws NoVMException, DebuggerException {
        return this.run(mainClass, new String[0]);
    }

    public Object executeCommand(String line) {
        return this.execute(line);
    }

    public ClassLineBreakpointRequestAction createClassLineEvent(String className, int line, boolean stop) throws DebuggerException {
        return this.createClassLineEvent(className, line, stop, null);
    }

    public ClassLineBreakpointRequestAction createClassLineEvent(String className, int line, boolean stop, String text) throws DebuggerException {
        ClassLineBreakpointRequestAction a = null;
        if (stop) {
            a = new StopAtRequest(this, className, line);
            a.setText(text);
        } else {
            a = new ClearAtRequest(this, className, line);
            a.setText(text);
        }
        return a;
    }

    public SourceLineBreakpointRequestAction createSourceLineEvent(String sourceName, int line, boolean stop) throws DebuggerException {
        return this.createSourceLineEvent(sourceName, line, stop, null);
    }

    public SourceLineBreakpointRequestAction createSourceLineEvent(String sourceName, int line, boolean stop, String text) throws DebuggerException {
        SourceLineBreakpointRequestAction a = null;
        if (stop) {
            a = new StopOnRequest(this, sourceName, line);
            a.setText(text);
        } else {
            a = new ClearOnRequest(this, sourceName, line);
            a.setText(text);
        }
        return a;
    }

    public Object runCommand() {
        try {
            return this.runCommand(this.getOptions());
        }
        catch (DebuggerException debuggerException) {
            return null;
        }
    }

    public Object runCommand(Options opts) throws NoVMException, DebuggerException {
        String className = opts.getClassName();
        String javaArgs = opts.getJavaArgs();
        String commandLine = opts.getCommandLine();
        return this.runCommand(className, javaArgs, commandLine, false, 0);
    }

    public Object runCommand(String className, String exArgs) throws NoVMException, DebuggerException {
        return this.runCommand(className, "", exArgs, false, 0);
    }

    public Object runCommand(String className, String vmArgs, String exArgs, boolean isSuspended, int debugTraceMode) throws NoVMException, DebuggerException {
        if (!this.getOptions().isSet("extra") && this.isRunning() && !this.app.canRestart()) {
            this.app.outln("VM already running. Use 'cont' to continue after events.");
            return null;
        }
        this.unstop();
        this.runningClass = className;
        if (!Modes.isJBuilder() && !Modes.isForte()) {
            this.app.outln("run " + className);
        } else {
            this.app.outln("connect " + className);
        }
        this.go(className, vmArgs, exArgs, isSuspended, debugTraceMode);
        return null;
    }

    public EventRequest clearAtCommand(String className, int line) throws NoVMException, DebuggerException {
        EventRequest er = (EventRequest)this.createClassLineEvent(className, line, false).go();
        this.app.clearAtCommand(className, line, er);
        return er;
    }

    public EventRequest clearInCommand(String className, String methodProto) throws NoVMException, DebuggerException {
        EventRequest er = (EventRequest)new ClearInRequest(this, className, methodProto).go();
        this.app.clearInCommand(className, methodProto, er);
        return er;
    }

    public EventRequest clearOnCommand(String sourceName, int line) throws NoVMException, DebuggerException {
        EventRequest er = (EventRequest)this.createSourceLineEvent(sourceName, line, false).go();
        this.app.clearOnCommand(sourceName, line, er);
        return er;
    }

    public List clearCommand() throws NoVMException, DebuggerException {
        List breakpoints = (List)new ClearListRequest(this).go();
        this.app.clearCommand(breakpoints);
        return breakpoints;
    }

    public List clearAllCommand() throws NoVMException, DebuggerException {
        List breakpoints = (List)new ClearAllRequest(this).go();
        this.app.clearAllCommand(breakpoints);
        return breakpoints;
    }

    public EventRequest stopAtCommand(String className, int line) throws NoVMException, DebuggerException {
        return this.stopAtCommand(className, line, null);
    }

    public EventRequest stopAtCommand(String className, int line, String text) throws NoVMException, DebuggerException {
        EventRequest er = (EventRequest)this.createClassLineEvent(className, line, true, text).go();
        this.app.stopAtCommand(className, line, er);
        return er;
    }

    public EventRequest stopInCommand(String className, String methodProto) throws NoVMException, DebuggerException {
        return this.stopInCommand(className, methodProto, null);
    }

    public EventRequest stopInCommand(String className, String methodProto, String text) throws NoVMException, DebuggerException {
        EventRequest er = (EventRequest)new StopInRequest(this, className, methodProto).setText(text).go();
        this.app.stopInCommand(className, methodProto, er);
        return er;
    }

    public EventRequest stopOnCommand(String sourceName, int line) throws NoVMException, DebuggerException {
        return this.stopOnCommand(sourceName, line, null);
    }

    public EventRequest stopOnCommand(String sourceName, int line, String text) throws NoVMException, DebuggerException {
        EventRequest er = (EventRequest)this.createSourceLineEvent(sourceName, line, true, text).go();
        this.app.stopOnCommand(sourceName, line, er);
        return er;
    }

    public List stopCommand() throws NoVMException, DebuggerException {
        List breakpoints = (List)new StopListRequest(this).go();
        this.app.stopCommand(breakpoints);
        return breakpoints;
    }

    public Object contCommand() throws NoVMException, DebuggerException {
        new ContRequest(this).go();
        this.fireStartEvent();
        this.app.contCommand();
        return null;
    }

    public List threadsCommand(String threadGroupName) throws NoVMException, DebuggerException {
        List threads = (List)new ThreadsRequest(this, threadGroupName).go();
        this.app.threadsCommand(threadGroupName, threads);
        return threads;
    }

    public List threadGroupsCommand() throws NoVMException, DebuggerException {
        List threadGroups = (List)new ThreadGroupsRequest(this).go();
        this.app.threadGroupsCommand(threadGroups);
        return threadGroups;
    }

    public List fieldsCommand(String className) throws NoVMException, DebuggerException {
        List fields = (List)new FieldsRequest(this, className).go();
        this.app.fieldsCommand(className, fields);
        return fields;
    }

    public List methodsCommand(String className) throws NoVMException, DebuggerException {
        List methods = (List)new MethodsRequest(this, className).go();
        this.app.methodsCommand(className, methods);
        return methods;
    }

    public List classesCommand() throws NoVMException, DebuggerException {
        List classes = (List)new ClassesRequest(this).go();
        this.app.classesCommand(classes);
        return classes;
    }

    public ReferenceType classCommand(String className) throws NoVMException, DebuggerException {
        ReferenceType refType = (ReferenceType)new ClassRequest(this, className).go();
        this.app.classCommand(className, refType);
        return refType;
    }

    public ThreadReference threadCommand(String threadName) throws NoVMException, DebuggerException {
        ThreadReference threadRef = this.setDefaultThread((ThreadReference)new ThreadRequest(this, threadName).go());
        this.app.threadCommand(threadName, threadRef);
        return threadRef;
    }

    public ThreadGroupReference threadGroupCommand(String threadGroupName) throws NoVMException, DebuggerException {
        ThreadGroupReference threadGroupRef = this.setDefaultThreadGroup((ThreadGroupReference)new ThreadGroupRequest(this, threadGroupName).go());
        this.app.threadGroupCommand(threadGroupName, threadGroupRef);
        return threadGroupRef;
    }

    public List suspendCommand() throws NoVMException, DebuggerException {
        List threads = this.suspendCommand(new Vector());
        this.fireStopEvent();
        return threads;
    }

    public List suspendCommand(List threadNames) throws NoVMException, DebuggerException {
        List threads = (List)new SuspendRequest(this, threadNames).go();
        this.fireStopEvent();
        this.app.suspendCommand(threadNames, threads);
        return threads;
    }

    public List resumeCommand(List threadNames) throws NoVMException, DebuggerException {
        List threads = (List)new ResumeRequest(this, threadNames).go();
        this.fireStartEvent();
        this.app.resumeCommand(threadNames, threads);
        return threads;
    }

    public List resumeCommand() throws NoVMException, DebuggerException {
        List threads = this.resumeCommand(new Vector());
        this.fireStartEvent();
        return threads;
    }

    public List whereCommand(String threadName) throws NoVMException, DebuggerException {
        List frames = (List)new WhereRequest(this, threadName).go();
        this.app.whereCommand(threadName, frames);
        return frames;
    }

    public List localsCommand() throws NoVMException, DebuggerException {
        List locals = (List)new LocalsRequest(this).go();
        this.app.localsCommand(locals);
        return locals;
    }

    public ThreadReference interruptCommand(String threadName) throws NoVMException, DebuggerException {
        ThreadReference threadRef = (ThreadReference)new InterruptRequest(this, threadName).go();
        this.fireStopEvent();
        this.app.interruptCommand(threadName, threadRef);
        return threadRef;
    }

    public StackFrame upCommand(int frames) throws NoVMException, DebuggerException {
        StackFrame frame = (StackFrame)new UpRequest(this, frames).go();
        this.app.upCommand(frames, frame);
        return frame;
    }

    public StackFrame downCommand(int frames) throws NoVMException, DebuggerException {
        StackFrame frame = (StackFrame)new DownRequest(this, frames).go();
        this.app.downCommand(frames, frame);
        return frame;
    }

    public StepRequest stepCommand() throws NoVMException, DebuggerException {
        this.unstop();
        StepRequest request = (StepRequest)new StepIntoRequest(this).go();
        this.fireStartEvent();
        this.app.stepCommand(request);
        return request;
    }

    public StepRequest stepUpCommand() throws NoVMException, DebuggerException {
        this.unstop();
        StepRequest request = (StepRequest)new StepUpRequest(this).go();
        this.fireStartEvent();
        this.app.stepUpCommand(request);
        return request;
    }

    public StepRequest stepiCommand() throws NoVMException, DebuggerException {
        this.unstop();
        StepRequest request = (StepRequest)new StepIRequest(this).go();
        this.fireStartEvent();
        this.app.stepiCommand(request);
        return request;
    }

    public StepRequest nextCommand() throws NoVMException, DebuggerException {
        this.unstop();
        StepRequest request = (StepRequest)new NextRequest(this).go();
        this.fireStartEvent();
        this.app.nextCommand(request);
        return request;
    }

    public Value printCommand(Object valueRep) throws NoVMException, DebuggerException {
        Value value = (Value)new PrintRequest(this, valueRep).go();
        this.app.printCommand(valueRep, value);
        return value;
    }

    public Value dumpCommand(Object valueRep) throws NoVMException, DebuggerException {
        Value value = (Value)new DumpRequest(this, valueRep).go();
        this.app.dumpCommand(valueRep, value);
        return value;
    }

    public Value evalCommand(Object valueRep) throws NoVMException, DebuggerException {
        Value value = (Value)new EvalRequest(this, valueRep).go();
        this.app.evalCommand(valueRep, value);
        return value;
    }

    public Value setCommand(Object lvalue, Object rvalue) throws NoVMException, DebuggerException {
        Value oldValue = (Value)new DumpRequest(this, lvalue).go();
        Value newValue = (Value)new SetRequest(this, lvalue, rvalue).go();
        this.app.setCommand(lvalue, rvalue, oldValue, newValue);
        return newValue;
    }

    public ClasspathRequest.Package classpathCommand() throws NoVMException, DebuggerException {
        ClasspathRequest.Package pkg = (ClasspathRequest.Package)new ClasspathRequest(this).go();
        this.app.classpathCommand(pkg.baseDirectory, pkg.paths);
        return pkg;
    }

    public LockInformation lockCommand(Object valueRep) throws NoVMException, DebuggerException {
        LockInformation lockInfo = (LockInformation)new LockRequest(this, valueRep).go();
        this.app.lockCommand(valueRep, lockInfo);
        return lockInfo;
    }

    public ThreadLockInformation threadlocksCommand(String threadName) throws NoVMException, DebuggerException {
        ThreadLockInformation threadLockInfo = (ThreadLockInformation)new ThreadLocksRequest(this, threadName).go();
        this.app.threadlocksCommand(threadName, threadLockInfo);
        return threadLockInfo;
    }

    public WatchpointRequest watchAccessCommand(String className, String fieldName) throws NoVMException, DebuggerException {
        return this.watchAccessCommand(className, fieldName, null);
    }

    public WatchpointRequest watchAccessCommand(String className, String fieldName, String text) throws NoVMException, DebuggerException {
        WatchpointRequest request = (WatchpointRequest)new WatchAccessRequest(this, className, fieldName).setText(text).go();
        this.app.watchAccessCommand(className, fieldName, request);
        return request;
    }

    public WatchpointRequest watchAllCommand(String className, String fieldName) throws NoVMException, DebuggerException {
        return this.watchAllCommand(className, fieldName, null);
    }

    public WatchpointRequest watchAllCommand(String className, String fieldName, String text) throws NoVMException, DebuggerException {
        WatchpointRequest request = (WatchpointRequest)new WatchAllRequest(this, className, fieldName).setText(text).go();
        this.app.watchAllCommand(className, fieldName, request);
        return request;
    }

    public WatchpointRequest unwatchAccessCommand(String className, String fieldName) throws NoVMException, DebuggerException {
        WatchpointRequest request = (WatchpointRequest)new UnwatchAccessRequest(this, className, fieldName).go();
        this.app.unwatchAccessCommand(className, fieldName, request);
        return request;
    }

    public WatchpointRequest unwatchAllCommand(String className, String fieldName) throws NoVMException, DebuggerException {
        WatchpointRequest request = (WatchpointRequest)new UnwatchAllRequest(this, className, fieldName).go();
        this.app.unwatchAllCommand(className, fieldName, request);
        return request;
    }

    public ExceptionRequest catchCommand(String className) throws NoVMException, DebuggerException {
        return this.catchCommand(className, null);
    }

    public ExceptionRequest catchCommand(String className, String text) throws NoVMException, DebuggerException {
        ExceptionRequest request = (ExceptionRequest)new CatchRequest(this, className).setText(text).go();
        this.app.catchCommand(className, request);
        return request;
    }

    public ExceptionRequest ignoreCommand(String className) throws NoVMException, DebuggerException {
        ExceptionRequest request = (ExceptionRequest)new IgnoreRequest(this, className).go();
        this.app.ignoreCommand(className, request);
        return request;
    }

    public TraceMethodsRequest.EntryExitPair traceMethodsCommand(String threadName) throws NoVMException, DebuggerException {
        TraceMethodsRequest.EntryExitPair pair = (TraceMethodsRequest.EntryExitPair)new TraceMethodsRequest(this, threadName).go();
        this.app.traceMethodsCommand(threadName, pair);
        return pair;
    }

    public UntraceMethodsRequest.EntryExitPair untraceMethodsCommand(String threadName) throws NoVMException, DebuggerException {
        UntraceMethodsRequest.EntryExitPair pair = (UntraceMethodsRequest.EntryExitPair)new UntraceMethodsRequest(this, threadName).go();
        this.app.untraceMethodsCommand(threadName, pair);
        return pair;
    }

    public List excludeCommand(List classNames) throws NoVMException, DebuggerException {
        List classes = (List)new ExcludeRequest(this, classNames).go();
        this.app.excludeCommand(classNames, classes);
        return classes;
    }

    public Object quitCommand() throws NoVMException, DebuggerException {
        this.fireStopEvent();
        this.app.quitCommand();
        return new QuitRequest(this).go();
    }

    public Object helpCommand() throws NoVMException, DebuggerException {
        String helpString = (String)new HelpRequest(this).go();
        this.app.helpCommand(helpString);
        return helpString;
    }

    public Object versionCommand() throws NoVMException, DebuggerException {
        Object version = new VersionRequest(this).go();
        this.app.versionCommand(version);
        return version;
    }

    public ThreadReference killCommand(String threadName, String valueRep) throws NoVMException, DebuggerException {
        ThreadReference threadRef = (ThreadReference)new KillRequest(this, threadName, valueRep).go();
        this.app.killCommand(threadName, valueRep, threadRef);
        return threadRef;
    }

    public String useCommand(String sourcePath) throws NoVMException, DebuggerException {
        String newSourcePath = (String)new UseRequest(this, sourcePath).go();
        this.app.useCommand(sourcePath, newSourcePath);
        return newSourcePath;
    }

    public String workingdirCommand(String workingdirPath) throws NoVMException, DebuggerException {
        String newWorkingdirPath = (String)new WorkingdirRequest(this, workingdirPath).go();
        this.app.workingdirCommand(workingdirPath, newWorkingdirPath);
        return newWorkingdirPath;
    }

    public List listCommand() throws NoVMException, DebuggerException {
        ListRequest.SourceAndLines sal = (ListRequest.SourceAndLines)new ListRequest(this).go();
        this.app.listCommand(sal.getSourceName(), sal.getLines());
        return sal.getLines();
    }

    public List listCommand(String sourceName) throws NoVMException, DebuggerException {
        ListRequest.SourceAndLines sal = (ListRequest.SourceAndLines)new ListRequest(this, sourceName).go();
        this.app.listCommand(sal.getSourceName(), sal.getLines());
        return sal.getLines();
    }

    public SourceManager.SourceLine listCommand(String sourceName, int lineNumber) throws NoVMException, DebuggerException {
        ListRequest.SourceAndLines sal = (ListRequest.SourceAndLines)new ListRequest(this, sourceName, lineNumber).go();
        SourceManager.SourceLine sl = (SourceManager.SourceLine)sal.getLines().get(0);
        this.app.listCommand(sal.getSourceName(), sl.lineNumber, sl);
        return sl;
    }

    public List listCommand(String sourceName, int startLine, int endLine) throws NoVMException, DebuggerException {
        ListRequest.SourceAndLines sal = (ListRequest.SourceAndLines)new ListRequest(this, sourceName, startLine, endLine).go();
        this.app.listCommand(sal.getSourceName(), startLine, endLine, sal.getLines());
        return sal.getLines();
    }

    public String monitorCommand(String command) throws NoVMException, DebuggerException {
        String result = (String)new MonitorRequest(this, command, this.monitors++).go();
        this.app.monitorCommand(command, result);
        return result;
    }

    public List monitorCommand() throws NoVMException, DebuggerException {
        List monitors = (List)new MonitorListRequest(this).go();
        this.app.monitorCommand(monitors);
        return monitors;
    }

    public MonitorRequest unmonitorCommand(int number) throws NoVMException, DebuggerException {
        MonitorRequest request = (MonitorRequest)new UnmonitorRequest(this, number).go();
        this.app.unmonitorCommand(number, request);
        return request;
    }

    public List readCommand(String sourceName) throws NoVMException, DebuggerException {
        return this.readCommand(sourceName, false);
    }

    public List readCommand(String sourceName, boolean silent) throws NoVMException, DebuggerException {
        List commands = (List)new ReadRequest(this, sourceName, silent).go();
        this.app.readCommand(sourceName, commands);
        return commands;
    }

    public VirtualMachine connectCommand() throws NoVMException, DebuggerException {
        return this.connectCommand("", "", "");
    }

    public VirtualMachine connectCommand(String vmArgs, String className, String commandLine) throws NoVMException, DebuggerException {
        try {
            this.startUpVM((VirtualMachine)new ConnectRequest(this, vmArgs, className, commandLine).go());
        }
        catch (ClassNotFoundException cnfe) {
            this.handleClassNotFound(cnfe);
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.handleClassNotFound(ncdfe);
            return null;
        }
        this.app.connectCommand(this.vm);
        return this.vm;
    }

    public Object bangBangCommand(String lastCommand) throws NoVMException, DebuggerException {
        Object result = new BangBangRequest(this, lastCommand).go();
        return result;
    }

    public Object importCommand(String importPath) throws NoVMException, DebuggerException {
        Object path = new ImportRequest(this, importPath).go();
        return path;
    }

    public Object deportCommand(String importPath) throws NoVMException, DebuggerException {
        Object path = new DeportRequest(this, importPath).go();
        return path;
    }

    public List viewCommand(String source) throws NoVMException, DebuggerException {
        ListRequest.SourceAndLines sal = (ListRequest.SourceAndLines)new ViewRequest(this, source).go();
        this.app.listCommand(sal.getSourceName(), sal.getLines());
        return sal.getLines();
    }

    public String tostringCommand() throws NoVMException, DebuggerException {
        String tostring = (String)new TostringRequest(this).go();
        this.app.tostringCommand(tostring);
        return tostring;
    }

    public File pwdCommand() throws NoVMException, DebuggerException {
        File pwd = (File)new PwdRequest(this).go();
        this.app.pwdCommand(pwd);
        return pwd;
    }

    public List lsCommand(String fileName) throws NoVMException, DebuggerException {
        List files = (List)new LsRequest(this, fileName).go();
        this.app.lsCommand(fileName, files);
        return files;
    }

    public boolean handle(Event event) {
        if (event == null) {
            return false;
        }
        if (event instanceof AccessWatchpointEvent) {
            this.handleAccessWatchpointEvent((AccessWatchpointEvent)event);
            return true;
        }
        if (event instanceof BreakpointEvent) {
            this.handleBreakpointEvent((BreakpointEvent)event);
            return false;
        }
        if (event instanceof ClassPrepareEvent) {
            this.handleClassPrepareEvent((ClassPrepareEvent)event);
            return true;
        }
        if (event instanceof ClassUnloadEvent) {
            this.handleClassUnloadEvent((ClassUnloadEvent)event);
            return true;
        }
        if (event instanceof ExceptionEvent) {
            this.handleExceptionEvent((ExceptionEvent)event);
            return true;
        }
        if (event instanceof MethodEntryEvent) {
            this.handleMethodEntryEvent((MethodEntryEvent)event);
            return true;
        }
        if (event instanceof MethodExitEvent) {
            this.handleMethodExitEvent((MethodExitEvent)event);
            return true;
        }
        if (event instanceof ModificationWatchpointEvent) {
            this.handleModificationWatchpointEvent((ModificationWatchpointEvent)event);
            return true;
        }
        if (event instanceof StepEvent) {
            this.handleStepEvent((StepEvent)event);
            return false;
        }
        if (event instanceof ThreadDeathEvent) {
            this.handleThreadDeathEvent((ThreadDeathEvent)event);
            return true;
        }
        if (event instanceof ThreadStartEvent) {
            this.handleThreadStartEvent((ThreadStartEvent)event);
            return true;
        }
        if (event instanceof VMDeathEvent) {
            this.handleVMDeathEvent((VMDeathEvent)event);
            return false;
        }
        if (event instanceof VMDisconnectEvent) {
            this.handleVMDisconnectEvent((VMDisconnectEvent)event);
            return false;
        }
        if (event instanceof VMStartEvent) {
            this.handleVMStartEvent((VMStartEvent)event);
            return false;
        }
        return false;
    }

    public List locals() {
        try {
            StackFrame frame = this.getDefaultFrame();
            if (frame != null) {
                return frame.visibleVariables();
            }
        }
        catch (InvalidStackFrameException e0) {
        }
        catch (AbsentInformationException e1) {
            this.error("Local variable information not available. Compile with -g to generate variable information");
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
        return new Vector();
    }

    void handleVMStartEvent(VMStartEvent event) {
        this.resetPrompt(true);
        int i = 0;
        while (i < this.vmListeners.size()) {
            ((VMListener)this.vmListeners.get(i)).vmStartEvent(event);
            ++i;
        }
    }

    void handleVMDeathEvent(VMDeathEvent event) {
        this.resetPrompt(false);
        int i = 0;
        while (i < this.vmListeners.size()) {
            ((VMListener)this.vmListeners.get(i)).vmDeathEvent(event);
            ++i;
        }
    }

    void handleVMDisconnectEvent(VMDisconnectEvent event) {
        this.resetPrompt(false);
        int i = 0;
        while (i < this.vmListeners.size()) {
            ((VMListener)this.vmListeners.get(i)).vmDisconnectEvent(event);
            ++i;
        }
    }

    void handleThreadStartEvent(ThreadStartEvent event) {
        int i = 0;
        while (i < this.threadListeners.size()) {
            ((ThreadListener)this.threadListeners.get(i)).threadStartEvent(event);
            ++i;
        }
    }

    void handleThreadDeathEvent(ThreadDeathEvent event) {
        int i = 0;
        while (i < this.threadListeners.size()) {
            ((ThreadListener)this.threadListeners.get(i)).threadDeathEvent(event);
            ++i;
        }
    }

    void handleClassPrepareEvent(ClassPrepareEvent event) {
        int i = 0;
        while (i < this.classListeners.size()) {
            ((ClassListener)this.classListeners.get(i)).classPrepareEvent(event);
            ++i;
        }
    }

    void handleClassUnloadEvent(ClassUnloadEvent event) {
        int i = 0;
        while (i < this.classListeners.size()) {
            ((ClassListener)this.classListeners.get(i)).classUnloadEvent(event);
            ++i;
        }
    }

    void handleBreakpointEvent(BreakpointEvent event) {
        Thread.yield();
        this.setDefaults(event);
        int i = 0;
        while (i < this.stopListeners.size()) {
            ((StopListener)this.stopListeners.get(i)).breakpointEvent(event);
            ++i;
        }
        this.setPrompt();
        this.fireStopEvent();
    }

    void handleAccessWatchpointEvent(AccessWatchpointEvent event) {
        Thread.yield();
        this.setDefaults(event);
        int i = 0;
        while (i < this.stopListeners.size()) {
            ((StopListener)this.stopListeners.get(i)).accessWatchpointEvent(event);
            ++i;
        }
        this.setPrompt();
        this.fireStopEvent();
    }

    void handleModificationWatchpointEvent(ModificationWatchpointEvent event) {
        Thread.yield();
        this.setDefaults(event);
        int i = 0;
        while (i < this.stopListeners.size()) {
            ((StopListener)this.stopListeners.get(i)).modificationWatchpointEvent(event);
            ++i;
        }
        this.setPrompt();
        this.fireStopEvent();
    }

    void handleStepEvent(StepEvent event) {
        Thread.yield();
        this.setDefaults(event);
        int i = 0;
        while (i < this.stopListeners.size()) {
            ((StopListener)this.stopListeners.get(i)).stepEvent(event);
            ++i;
        }
        this.setPrompt();
        this.fireStopEvent();
    }

    void handleExceptionEvent(ExceptionEvent event) {
        this.setDefaults(event);
        int i = 0;
        while (i < this.stopListeners.size()) {
            ((StopListener)this.stopListeners.get(i)).exceptionEvent(event);
            ++i;
        }
        if (event.location() == null) {
            try {
                this.suspendCommand();
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
        }
        this.setPrompt();
        this.fireStopEvent();
    }

    void handleMethodEntryEvent(MethodEntryEvent event) {
        int i = 0;
        while (i < this.methodListeners.size()) {
            ((MethodListener)this.methodListeners.get(i)).methodEntryEvent(event);
            ++i;
        }
    }

    void handleMethodExitEvent(MethodExitEvent event) {
        int i = 0;
        while (i < this.methodListeners.size()) {
            ((MethodListener)this.methodListeners.get(i)).methodExitEvent(event);
            ++i;
        }
    }

    public void fireRequestSetEvent(RequestEvent re) {
        int i = 0;
        while (i < this.debuggerListeners.size()) {
            ((DebuggerListener)this.debuggerListeners.get(i)).requestSetEvent(re);
            ++i;
        }
    }

    public void fireRequestClearEvent(RequestEvent re) {
        int i = 0;
        while (i < this.debuggerListeners.size()) {
            ((DebuggerListener)this.debuggerListeners.get(i)).requestClearEvent(re);
            ++i;
        }
    }

    public void fireRequestDeferredEvent(RequestEvent re) {
        int i = 0;
        while (i < this.debuggerListeners.size()) {
            ((DebuggerListener)this.debuggerListeners.get(i)).requestDeferredEvent(re);
            ++i;
        }
    }

    public void fireRequestFailedEvent(RequestEvent re) {
        int i = 0;
        while (i < this.debuggerListeners.size()) {
            ((DebuggerListener)this.debuggerListeners.get(i)).requestFailedEvent(re);
            ++i;
        }
    }

    public void fireResetPrompt() {
        int i = 0;
        while (i < this.promptListeners.size()) {
            ((PromptListener)this.promptListeners.get(i)).resetPrompt();
            ++i;
        }
    }

    public void fireSourcePathChanged() {
        int i = 0;
        while (i < this.sourcePathListeners.size()) {
            ((SourcePathListener)this.sourcePathListeners.get(i)).sourcePathChanged();
            ++i;
        }
    }

    public void fireStartEvent() {
        if (this.vm() == null) {
            return;
        }
        int i = 0;
        while (i < this.progressListeners.size()) {
            ((ProgressListener)this.progressListeners.get(i)).startEvent();
            ++i;
        }
    }

    public void fireStopEvent() {
        if (this.vm() == null) {
            return;
        }
        int i = 0;
        while (i < this.progressListeners.size()) {
            ((ProgressListener)this.progressListeners.get(i)).stopEvent();
            ++i;
        }
    }

    public void addClassListener(ClassListener listener) {
        if (!this.classListeners.contains(listener)) {
            this.classListeners.add(listener);
        }
    }

    public void addStopListener(StopListener listener) {
        if (!this.stopListeners.contains(listener)) {
            this.stopListeners.add(listener);
        }
    }

    public void addMethodListener(MethodListener listener) {
        if (!this.methodListeners.contains(listener)) {
            this.methodListeners.add(listener);
        }
    }

    public void addThreadListener(ThreadListener listener) {
        if (!this.threadListeners.contains(listener)) {
            this.threadListeners.add(listener);
        }
    }

    public void addVMListener(VMListener listener) {
        if (!this.vmListeners.contains(listener)) {
            this.vmListeners.add(listener);
        }
    }

    public void addDebuggerListener(DebuggerListener listener) {
        if (!this.debuggerListeners.contains(listener)) {
            this.debuggerListeners.add(listener);
        }
    }

    public void addPromptListener(PromptListener listener) {
        if (!this.promptListeners.contains(listener)) {
            this.promptListeners.add(listener);
        }
    }

    public void addSourcePathListener(SourcePathListener listener) {
        if (!this.sourcePathListeners.contains(listener)) {
            this.sourcePathListeners.add(listener);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        if (!this.progressListeners.contains(listener)) {
            this.progressListeners.add(listener);
        }
    }

    public boolean removeClassListener(ClassListener listener) {
        return this.classListeners.remove(listener);
    }

    public boolean removeStopListener(StopListener listener) {
        return this.stopListeners.remove(listener);
    }

    public boolean removeMethodListener(MethodListener listener) {
        return this.methodListeners.remove(listener);
    }

    public boolean removeThreadListener(ThreadListener listener) {
        return this.threadListeners.remove(listener);
    }

    public boolean removeVMListener(VMListener listener) {
        return this.vmListeners.remove(listener);
    }

    public boolean removeDebuggerListener(DebuggerListener listener) {
        return this.debuggerListeners.remove(listener);
    }

    public boolean removePromptListener(PromptListener listener) {
        return this.promptListeners.remove(listener);
    }

    public boolean removeSourcePathListener(SourcePathListener listener) {
        return this.sourcePathListeners.remove(listener);
    }

    public boolean removeProgressListener(ProgressListener listener) {
        return this.progressListeners.remove(listener);
    }

    private final void me() {
        String user = System.getProperty("user.name");
        if (user != null && user.equals("palm") && System.getProperty("no.logger") != null) {
            System.out.println("Setting options for me...");
            this.getOptions().set("debugging-for-jeff");
            this.getOptions().set("nodemangle");
            this.getOptions().set("extra");
        }
    }

    public String toLongString() {
        return this.toString();
    }

    public void exception(String msg) {
        this.exception(msg, null);
    }

    public void exception(Throwable t) {
        this.exception(null, t);
    }

    public void exception(String msg, Throwable t) {
        this.error((msg != null ? msg : "") + (t != null ? ":" + t.getMessage() : ""));
    }

    public void classNotPreparedException(ClassNotPreparedException e, String className) {
        this.exception("The class " + className + " was not prepared", e);
    }

    public void objectCollectedException(ObjectCollectedException e, String object) {
        this.exception("The object " + object + " was collected", e);
    }

    public void invalidLineNumberException(InvalidLineNumberException e, String className, int line) {
        this.exception("The line " + line + " is invalid in class " + className, e);
    }

    static class AppVector
    extends Vector {
        AppVector() {
        }

        public boolean add(Object o) {
            if (o instanceof DebuggerApp) {
                this.add(0, o);
                return true;
            }
            return super.add(o);
        }
    }

    static interface RequestComparator {
        public boolean wantsRequest(Object var1);
    }
}

