/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import org.aspectj.debugger.base.ErrorLoggable;
import org.aspectj.debugger.base.Options;

class AbstractErrorLogger {
    private ErrorLoggable loggable;
    private String errorFileName = ".ajdbErrors";

    public AbstractErrorLogger(ErrorLoggable loggable) {
        this.loggable = loggable;
        Options options = loggable.getOptions();
        Object userErrorFileName = options.get("errorfile");
        if (userErrorFileName != null) {
            this.errorFileName = userErrorFileName + "";
        }
    }

    public void log(Throwable t) {
        this.log("No message", t);
    }

    public void log(String msg) {
        this.log(msg, new Throwable(msg));
    }

    public void log(String msg, Throwable t) {
        try {
            PrintWriter printWriter = new PrintWriter(this.getOutputStream());
            printWriter.println(this.heading());
            printWriter.println(msg);
            t.printStackTrace(printWriter);
            printWriter.close();
        }
        catch (IOException ioe) {
            this.loggable.fatal("Could not open error file for writing.");
        }
    }

    private String heading() {
        String date = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        String username = System.getProperty("user.name");
        StringBuffer buf = new StringBuffer();
        buf.append("# -----------------------------------------------------------\n");
        buf.append("# Date: " + date + "\n");
        buf.append("# User: " + username + "\n");
        buf.append("# -----------------------------------------------------------\n");
        return buf.toString();
    }

    public OutputStream getOutputStream() throws IOException {
        File file = new File(this.getErrorFileName());
        boolean append = false;
        if (file != null && file.exists()) {
            append = true;
        }
        FileOutputStream out = new FileOutputStream(this.getErrorFileName(), append);
        return out;
    }

    public String getErrorFileName() {
        return this.errorFileName;
    }

    public void setErrorFile(String errorFileName) {
        this.errorFileName = errorFileName;
    }
}

