/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.crosscuts.joinpoints.AndJpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.util.FuzzyBoolean;

class OrJpPlanner
extends JpPlanner {
    List list;

    public OrJpPlanner(List list) {
        this.list = list;
    }

    public OrJpPlanner(JpPlanner p1, JpPlanner p2) {
        this.list = new ArrayList();
        this.list.add(p1);
        this.list.add(p2);
    }

    public void walk(Object data) {
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            p.walk(data);
        }
    }

    public FuzzyBoolean fastMatch(JoinPoint jp) {
        FuzzyBoolean ret = FuzzyBoolean.NO;
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            ret = ret.or(p.fastMatch(jp));
        }
        return ret;
    }

    public JpPlan makePlan(JoinPoint jp) {
        JpPlan plan = JpPlan.NO_PLAN;
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            plan = p.makePlan(jp).or(plan);
        }
        return plan;
    }

    public JpPlanner or(JpPlanner other) {
        ArrayList<JpPlanner> newList = new ArrayList<JpPlanner>(this.list);
        if (other instanceof OrJpPlanner) {
            newList.addAll(((OrJpPlanner)other).list);
        } else {
            newList.add(other);
        }
        return new OrJpPlanner(newList);
    }

    public JpPlanner and(JpPlanner other) {
        ArrayList<JpPlanner> newList = new ArrayList<JpPlanner>(this.list.size());
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            newList.add(p.and(other));
        }
        return new OrJpPlanner(newList);
    }

    public JpPlanner not() {
        ArrayList<JpPlanner> newList = new ArrayList<JpPlanner>(this.list.size());
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            newList.add(p.not());
        }
        return new AndJpPlanner(newList, Collections.EMPTY_LIST);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.list.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            buf.append(p.toString());
            if (!i.hasNext()) continue;
            buf.append(" || ");
        }
        return buf.toString();
    }
}

