/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.AnonymousMethodExpr;
import org.aspectj.compiler.crosscuts.joinpoints.CodeBodyJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public abstract class ExprJp
extends CodeBodyJp {
    public Expr expr;
    AnonymousMethodExpr syntheticCall = null;
    FormalDec targetFormal = null;
    FormalDec thisFormal = null;

    public ExprJp(Expr expr, JoinPoint enclosingJoinPoint) {
        super(enclosingJoinPoint);
        this.expr = expr;
    }

    public abstract Dec getTargetDec();

    public String toString() {
        return this.getKind().toShortString() + "(" + this.getTargetDec().toShortString() + ")";
    }

    FormalDec getTargetFormal() {
        if (this.getTargetExprType() == null) {
            return null;
        }
        if (this.targetFormal == null) {
            this.targetFormal = this.getAST().makeFormal(this.getTargetExprType(), "target");
        }
        return this.targetFormal;
    }

    FormalDec getThisFormal() {
        return null;
    }

    public abstract Type getTargetExprType();

    public abstract Type getTargetType();

    public Expr makeTargetExpr() {
        FormalDec formal = this.getTargetFormal();
        if (formal == null) {
            return null;
        }
        return this.getAST().makeVar(formal);
    }

    public Expr makeTargetExprOrType() {
        Expr ret = this.makeTargetExpr();
        if (ret != null) {
            return ret;
        }
        return this.getAST().makeTypeExpr(this.getTargetType());
    }

    public Expr makeThisExpr() {
        return super.makeThisExpr();
    }

    public Type getResultType() {
        return this.expr.getType();
    }

    public ASTObject getSourceLocation() {
        return this.expr;
    }

    protected abstract AnonymousMethodExpr makeSyntheticCall();

    protected abstract ASTObject makeInnerCall(Expr var1, Exprs var2);

    protected AnonymousMethodExpr makeAnonMethodExpr(Formals formals, Expr targetExpr, Exprs argsExprs) {
        FormalDec thisFormal;
        AST ast = this.getAST();
        FormalDec targetFormal = this.getTargetFormal();
        if (targetFormal != null) {
            formals.add(0, targetFormal);
            argsExprs.add(0, targetExpr);
        }
        if ((thisFormal = this.getThisFormal()) != null) {
            formals.add(0, thisFormal);
            argsExprs.add(0, ast.makeThis(this.getThisExprType()));
        }
        ASTObject innerCall = this.makeInnerCall(this.makeTargetExprOrType(), this.makeArgsExprs());
        Modifiers modifiers = ast.makeModifiers(2);
        if (this.getThisExprType() == null) {
            modifiers.setStatic(true);
        }
        String innerName = this.getAST().makeGeneratedName(this.getTargetDec().getName() + "$" + this.getKind());
        Type innerResultType = this.getResultType();
        Stmt stmt = innerResultType.isVoid() ? (innerCall instanceof Stmt ? (Stmt)innerCall : ast.makeStmt((Expr)innerCall)) : ast.makeReturn((Expr)innerCall);
        SourceLocation loc = this.getSourceLocation().getSourceLocation();
        innerCall.setSourceLocation(loc);
        stmt.setSourceLocation(loc);
        MethodDec innerMethod = ast.makeMethod(modifiers, innerResultType, innerName, formals, ast.makeBlock(stmt));
        innerMethod.setAllEnclosingTypes(this.getBytecodeType());
        return new AnonymousMethodExpr(loc, argsExprs, innerMethod);
    }

    AnonymousMethodExpr getSyntheticCall() {
        if (this.syntheticCall == null) {
            this.syntheticCall = this.makeSyntheticCall();
            this.syntheticCall.grabContext();
            this.replaceExprWith(this.syntheticCall);
        }
        return this.syntheticCall;
    }

    protected void replaceExprWith(Expr newExpr) {
        this.expr.replaceWith(newExpr);
    }

    public CodeDec getBaseCodeDec() {
        return this.getSyntheticCall().getMethodDec();
    }

    public Stmts getStmts() {
        return this.getBaseCodeDec().getBody().getStmts();
    }

    public void setStmts(Stmts stmts) {
        this.getBaseCodeDec().getBody().setStmts(stmts);
    }

    public void finishJoinPoint() {
        super.finishJoinPoint();
        this.getBaseCodeDec().computeMinimalThrows();
    }
}

