/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.Collection;
import java.util.Collections;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.joinpoints.CodeBodyJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class ExceptionHandlerJp
extends CodeBodyJp {
    CatchClause catchClause;
    static final JoinPoint.Kind KIND = new JoinPoint.Kind("exception-handler", 256);
    private static int counter = 0;

    public ExceptionHandlerJp(CatchClause catchClause, JoinPoint enclosingJoinPoint) {
        super(enclosingJoinPoint);
        this.catchClause = catchClause;
    }

    public JoinPoint.Kind getKind() {
        return KIND;
    }

    protected Expr makeSignatureExpr() {
        return this.makeSignatureExpr(this.catchClause);
    }

    public ASTObject getSourceLocation() {
        return this.catchClause;
    }

    public Expr makeThrowableExpr() {
        return this.getAST().makeVar(this.catchClause.getFormal());
    }

    public Type getTargetType() {
        return null;
    }

    public Dec getTargetDec() {
        return this.catchClause.getEnclosingCodeDec();
    }

    public Type getResultType() {
        return this.getTypeManager().voidType;
    }

    public Type getExceptionType() {
        return this.catchClause.getFormal().getType();
    }

    public Exprs makeArgsExprs() {
        return this.getAST().makeExprs(this.makeThrowableExpr());
    }

    public boolean canThrow(Type t) {
        return t.isUncheckedThrowable();
    }

    public Collection getPossibleCheckedExceptions() {
        return Collections.EMPTY_LIST;
    }

    public Stmts getStmts() {
        Stmt body = this.catchClause.getBody();
        if (body instanceof BlockStmt) {
            return ((BlockStmt)body).getStmts();
        }
        return this.getAST().makeStmts(body);
    }

    public void setStmts(Stmts stmts) {
        this.catchClause.setBody(this.getAST().makeBlock(stmts));
    }

    public FormalDec getFormal() {
        return this.catchClause.getFormal();
    }

    public String toString() {
        return "handler(" + this.catchClause.getFormal() + ")";
    }

    protected String getJoinPointNameModifier() {
        return "Handler" + counter++;
    }
}

