/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.crosscuts.joinpoints.InstanceTest;

public class DynamicPointTest
extends CompilerObject {
    public Expr dynamicTest = null;
    public InstanceTest enclosingInstanceTest;
    public InstanceTest calledInstanceTest;

    public DynamicPointTest(JavaCompiler compiler) {
        super(compiler);
    }

    public void addExprTest(Expr newExprTest) {
        this.dynamicTest = this.intersectTests(this.dynamicTest, newExprTest);
    }

    public void addTest(DynamicPointTest other) {
        this.dynamicTest = this.intersectTests(this.dynamicTest, other.dynamicTest);
        this.calledInstanceTest = this.intersectInstanceTests(this.calledInstanceTest, other.calledInstanceTest);
        this.enclosingInstanceTest = this.intersectInstanceTests(this.enclosingInstanceTest, other.enclosingInstanceTest);
    }

    public DynamicPointTest intersect(DynamicPointTest other) {
        DynamicPointTest newTest = new DynamicPointTest(this.getCompiler());
        newTest.dynamicTest = this.intersectTests(this.dynamicTest, other.dynamicTest);
        newTest.calledInstanceTest = this.intersectInstanceTests(this.calledInstanceTest, other.calledInstanceTest);
        newTest.enclosingInstanceTest = this.intersectInstanceTests(this.enclosingInstanceTest, other.enclosingInstanceTest);
        return newTest;
    }

    public DynamicPointTest union(DynamicPointTest other) {
        DynamicPointTest newTest = new DynamicPointTest(this.getCompiler());
        newTest.dynamicTest = this.unionTests(this.dynamicTest, other.dynamicTest);
        newTest.calledInstanceTest = this.unionInstanceTests(this.calledInstanceTest, other.calledInstanceTest);
        newTest.enclosingInstanceTest = this.unionInstanceTests(this.enclosingInstanceTest, other.enclosingInstanceTest);
        return newTest;
    }

    public DynamicPointTest complement() {
        DynamicPointTest newTest = new DynamicPointTest(this.getCompiler());
        newTest.dynamicTest = this.complementTest(this.dynamicTest);
        newTest.calledInstanceTest = this.complementInstanceTest(this.calledInstanceTest);
        newTest.enclosingInstanceTest = this.complementInstanceTest(this.enclosingInstanceTest);
        return newTest;
    }

    private InstanceTest intersectInstanceTests(InstanceTest test1, InstanceTest test2) {
        if (test1 == null) {
            return test2;
        }
        if (test2 == null) {
            return test1;
        }
        return test1.intersect(test2);
    }

    private Expr intersectTests(Expr test1, Expr test2) {
        if (test1 == null) {
            return test2;
        }
        if (test2 == null) {
            return test1;
        }
        return this.getAST().makeBinop("&&", test1, test2);
    }

    private InstanceTest unionInstanceTests(InstanceTest test1, InstanceTest test2) {
        if (test1 == null) {
            return test2;
        }
        if (test2 == null) {
            return test1;
        }
        return test1.union(test2);
    }

    private Expr unionTests(Expr test1, Expr test2) {
        if (test1 == null) {
            return test2;
        }
        if (test2 == null) {
            return test1;
        }
        return this.getAST().makeBinop("||", test1, test2);
    }

    private InstanceTest complementInstanceTest(InstanceTest instanceTest) {
        if (instanceTest == null) {
            return null;
        }
        return instanceTest.complement();
    }

    private Expr complementTest(Expr test) {
        if (test == null) {
            return null;
        }
        return this.getAST().makeUnop("!", test);
    }

    public Expr getTestExpr() {
        Expr test = this.dynamicTest;
        return test;
    }

    public boolean hasTest() {
        return this.dynamicTest != null || this.calledInstanceTest != null || this.enclosingInstanceTest != null;
    }
}

