/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.OrJpPlanner;
import org.aspectj.util.FuzzyBoolean;

class AndJpPlanner
extends JpPlanner {
    List _true;
    List _false;

    public AndJpPlanner(List _true, List _false) {
        this._true = _true;
        this._false = _false;
    }

    public AndJpPlanner(JpPlanner p1, JpPlanner p2) {
        this._true = new ArrayList();
        this._true.add(p1);
        this._true.add(p2);
        this._false = new ArrayList();
    }

    public void walk(Object data) {
        Iterator i = this._true.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            p.walk(data);
        }
        Iterator i2 = this._false.iterator();
        while (i2.hasNext()) {
            JpPlanner p = (JpPlanner)i2.next();
            p.walk(data);
        }
    }

    public FuzzyBoolean fastMatch(JoinPoint jp) {
        FuzzyBoolean ret = FuzzyBoolean.YES;
        Iterator i = this._true.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            ret = ret.and(p.fastMatch(jp));
        }
        Iterator i2 = this._false.iterator();
        while (i2.hasNext()) {
            JpPlanner p = (JpPlanner)i2.next();
            ret = ret.and(p.fastMatch(jp).not());
        }
        return ret;
    }

    public JpPlan makePlan(JoinPoint jp) {
        JpPlan plan = JpPlan.ANY_PLAN;
        Iterator i = this._true.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            plan = plan.and(p.makePlan(jp));
        }
        Iterator i2 = this._false.iterator();
        while (i2.hasNext()) {
            JpPlanner p = (JpPlanner)i2.next();
            plan = plan.and(p.makePlan(jp).not());
        }
        return plan;
    }

    public JpPlanner or(JpPlanner other) {
        return new OrJpPlanner(this, other);
    }

    public JpPlanner and(JpPlanner other) {
        ArrayList<JpPlanner> newTrue = new ArrayList<JpPlanner>(this._true);
        ArrayList newFalse = new ArrayList(this._false);
        if (other instanceof AndJpPlanner) {
            AndJpPlanner otherAnd = (AndJpPlanner)other;
            newTrue.addAll(otherAnd._true);
            newFalse.addAll(otherAnd._false);
        } else {
            newTrue.add(other);
        }
        return new AndJpPlanner(newTrue, newFalse);
    }

    public JpPlanner not() {
        ArrayList<JpPlanner> newList = new ArrayList<JpPlanner>();
        Iterator i = this._true.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            newList.add(p.not());
        }
        Iterator i2 = this._false.iterator();
        while (i2.hasNext()) {
            JpPlanner p = (JpPlanner)i2.next();
            newList.add(p);
        }
        return new OrJpPlanner(newList);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this._true.iterator();
        while (i.hasNext()) {
            JpPlanner p = (JpPlanner)i.next();
            buf.append(p.toString());
            if (!i.hasNext() && this._false.size() <= 0) continue;
            buf.append(" && ");
        }
        Iterator i2 = this._false.iterator();
        while (i2.hasNext()) {
            JpPlanner p = (JpPlanner)i2.next();
            buf.append("!");
            buf.append(p.toString());
            if (!i2.hasNext()) continue;
            buf.append(" && ");
        }
        return buf.toString();
    }
}

