/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Iterator;
import java.util.List;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.crosscuts.ast.NamePattern;

public class WildName
extends NamePattern {
    protected List pieces;

    public String getLookupString() {
        return "*";
    }

    public boolean isStar() {
        return false;
    }

    private boolean matches(String s, int sIndex, int pieceIndex) {
        if (pieceIndex == this.pieces.size()) {
            return sIndex == s.length();
        }
        String piece = (String)this.pieces.get(pieceIndex);
        if (piece == "*") {
            int i = sIndex;
            while (i <= s.length()) {
                if (this.matches(s, i, pieceIndex + 1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (!s.regionMatches(sIndex, piece, 0, piece.length())) {
            return false;
        }
        return this.matches(s, sIndex + piece.length(), pieceIndex + 1);
    }

    public boolean matches(String s) {
        return this.matches(s, 0, 0);
    }

    public String toShortString() {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.pieces.iterator();
        while (i.hasNext()) {
            buf.append(i.next());
        }
        return buf.toString();
    }

    public List getPieces() {
        return this.pieces;
    }

    public void setPieces(List _pieces) {
        this.pieces = _pieces;
    }

    public WildName(SourceLocation location, List _pieces) {
        super(location);
        this.setPieces(_pieces);
    }

    protected WildName(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        WildName ret = new WildName(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.pieces = this.pieces;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "WildName(pieces: " + this.pieces + ")";
    }
}

