/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.util.FuzzyBoolean;

public class UnionTypeName
extends GenTypeName {
    protected GenTypeName name1;
    protected GenTypeName name2;

    public String toShortString() {
        return this.name1.toShortString() + " || " + this.name2.toShortString();
    }

    public boolean matches(Type type) {
        return this.name1.matches(type) || this.name2.matches(type);
    }

    public FuzzyBoolean matchesInstance(Type type) {
        return this.name1.matchesInstance(type).or(this.name2.matchesInstance(type));
    }

    public JpPlan makePlan(JoinPoint jp, Expr expr) {
        JpPlan plan1 = this.name1.makePlan(jp, expr);
        JpPlan plan2 = this.name2.makePlan(jp, expr);
        return plan1.or(plan2);
    }

    public GenTypeName getName1() {
        return this.name1;
    }

    public void setName1(GenTypeName _name1) {
        if (_name1 != null) {
            _name1.setParent(this);
        }
        this.name1 = _name1;
    }

    public GenTypeName getName2() {
        return this.name2;
    }

    public void setName2(GenTypeName _name2) {
        if (_name2 != null) {
            _name2.setParent(this);
        }
        this.name2 = _name2;
    }

    public UnionTypeName(SourceLocation location, GenTypeName _name1, GenTypeName _name2) {
        super(location);
        this.setName1(_name1);
        this.setName2(_name2);
    }

    protected UnionTypeName(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        UnionTypeName ret = new UnionTypeName(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.name1 != null) {
            ret.setName1((GenTypeName)walker.process(this.name1));
        }
        if (this.name2 != null) {
            ret.setName2((GenTypeName)walker.process(this.name2));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.name1;
            }
            case 1: {
                return this.name2;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "name1";
            }
            case 1: {
                return "name2";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setName1((GenTypeName)child);
                return;
            }
            case 1: {
                this.setName2((GenTypeName)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "UnionTypeName()";
    }
}

