/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.NamePcd;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlannerMaker;

public class PlanData {
    public AspectDec inAspect;
    private JpPlannerMaker jpPlannerMaker;
    public Set bindingNames = new HashSet();
    public Type nameBindingType;

    public PlanData(AspectDec inAspect, JpPlannerMaker jpPlannerMaker) {
        this.jpPlannerMaker = jpPlannerMaker;
        this.inAspect = inAspect;
    }

    public ASTObject getPlanMaker() {
        if (this.jpPlannerMaker instanceof ASTObject) {
            return (ASTObject)((Object)this.jpPlannerMaker);
        }
        return this.getAspectDec();
    }

    public AspectDec getAspectDec() {
        return this.inAspect;
    }

    public Type getNameBindingType() {
        if (this.nameBindingType == null) {
            if (this.inAspect == null) {
                return null;
            }
            return this.inAspect.getType();
        }
        return this.nameBindingType;
    }

    public PlanData makeInner(NamePcd bindingName) {
        PlanData pd = new PlanData(this.inAspect, this.jpPlannerMaker);
        pd.bindingNames.addAll(this.bindingNames);
        pd.bindingNames.add(bindingName);
        pd.nameBindingType = bindingName.getParentName() != null ? bindingName.getParentName().getType() : this.nameBindingType;
        return pd;
    }

    public boolean isPlanning(NamePcd namePcd) {
        return this.bindingNames.contains(namePcd);
    }
}

